/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.eclipse.stardust.engine.api.model.IModel;
import org.eclipse.stardust.reporting.common.DbAwareGroupColumn;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;
import org.eclipse.stardust.reporting.common.Parameter;
import org.eclipse.stardust.reporting.common.PartitionInfo;
import org.eclipse.stardust.reporting.common.ProcessDatabaseQueryException;
import org.eclipse.stardust.reporting.common.ReportingCommon_Messages;
import org.eclipse.stardust.reporting.common.View;
import org.eclipse.stardust.reporting.common.metadata.columns.DbColumn;
import org.eclipse.stardust.reporting.common.metadata.columns.ModelDescriptionColumn;
import org.eclipse.stardust.reporting.common.metadata.columns.ModelNameColumn;
import org.eclipse.stardust.reporting.common.utils.Localizer;
import org.eclipse.stardust.reporting.common.utils.ModelUtils;
import org.eclipse.stardust.reporting.common.utils.SqlUtils;
import org.eclipse.stardust.reporting.common.utils.sql.DbUtils;

public class ModelDetailsView
extends View {
    public static final String MODEL_VIEW_REPORT_TYPE = "ModelDetailsView";
    private static Logger log = LogUtils.getLogger(ModelDetailsView.class);
    private List<DbAwareGroupColumn> reportColumns;
    private DbAwareGroupColumn nameColumn;
    private DbAwareGroupColumn idColumn;
    private DbAwareGroupColumn oidColumn;
    private DbAwareGroupColumn versionColumn;
    private DbAwareGroupColumn isActiveColumn;
    private DbAwareGroupColumn disabledColumn;
    private DbAwareGroupColumn validFromColumn;
    private DbAwareGroupColumn descriptionColumn;

    public ModelDetailsView() {
        super(MODEL_VIEW_REPORT_TYPE);
        this.addParameter("ModelID", String.class, false, Parameter.STRING_DEFAULT_VALUE, null);
    }

    @Override
    protected void createDefaultFields() {
        this.reportColumns = new ArrayList<DbAwareGroupColumn>();
        this.nameColumn = new DbAwareGroupColumn(this, "Name", ReportingCommon_Messages.ColumnName, String.class);
        this.idColumn = new DbAwareGroupColumn(this, "ID", ReportingCommon_Messages.ColumnId, String.class);
        this.oidColumn = new DbAwareGroupColumn(this, "OID", ReportingCommon_Messages.ColumnOid, String.class);
        this.versionColumn = new DbAwareGroupColumn(this, "Version", ReportingCommon_Messages.ColumnVersion, String.class);
        this.isActiveColumn = new DbAwareGroupColumn(this, "Active", ReportingCommon_Messages.ColumnActive, String.class);
        this.disabledColumn = new DbAwareGroupColumn(this, "Disabled", ReportingCommon_Messages.ColumnDisabled, String.class);
        this.validFromColumn = new DbAwareGroupColumn(this, "Valid From", ReportingCommon_Messages.ColumnValidFrom, String.class);
        this.descriptionColumn = new DbAwareGroupColumn(this, "Description", ReportingCommon_Messages.ColumnDescription, String.class);
        this.reportColumns.add(this.nameColumn);
        this.reportColumns.add(this.idColumn);
        this.reportColumns.add(this.oidColumn);
        this.reportColumns.add(this.versionColumn);
        this.reportColumns.add(this.isActiveColumn);
        this.reportColumns.add(this.disabledColumn);
        this.reportColumns.add(this.validFromColumn);
        this.reportColumns.add(this.descriptionColumn);
        this.addGroupColumns(this.reportColumns);
    }

    @Override
    public String getReportType() {
        return MODEL_VIEW_REPORT_TYPE;
    }

    @Override
    protected String getModelIdParameter(Object[] parameters) {
        return (String)parameters[0];
    }

    @Override
    public String getQueryString(List<IModel> allDeployedModels, Object[] parameters) throws ProcessDatabaseQueryException {
        String tableAlias = "mr";
        DbColumn partionColumnName = new DbColumn("partition", tableAlias);
        DbColumn idColumnName = new DbColumn("id", tableAlias);
        DbColumn oidColumnName = new DbColumn("oid", tableAlias);
        DbColumn versionColumnName = new DbColumn("version", tableAlias);
        DbColumn disabledColumnName = new DbColumn("disabled", tableAlias, Boolean.class);
        DbColumn validFromColumnName = new DbColumn("validFrom", tableAlias, Date.class);
        ModelNameColumn nameColumnName = new ModelNameColumn(oidColumnName, tableAlias);
        ModelDescriptionColumn descriptionColumnName = new ModelDescriptionColumn(oidColumnName);
        ArrayList<DbColumn> columnNames = new ArrayList<DbColumn>();
        columnNames.add(nameColumnName);
        columnNames.add(idColumnName);
        columnNames.add(oidColumnName);
        columnNames.add(versionColumnName);
        columnNames.add(disabledColumnName);
        columnNames.add(validFromColumnName);
        DbUtils.indexColumns(columnNames);
        this.nameColumn.setDbColumn(nameColumnName);
        this.idColumn.setDbColumn(idColumnName);
        this.oidColumn.setDbColumn(oidColumnName);
        this.versionColumn.setDbColumn(versionColumnName);
        this.isActiveColumn.setDbColumn(null);
        this.disabledColumn.setDbColumn(disabledColumnName);
        this.validFromColumn.setDbColumn(validFromColumnName);
        this.descriptionColumn.setDbColumn(descriptionColumnName);
        String modelId = this.getModelIdParameter(parameters);
        PartitionInfo partitionInfo = this.getPartitionInfo();
        StringBuffer buffer = new StringBuffer();
        String selectedColumns = DbUtils.getColumnList(columnNames);
        buffer.append("select ").append(selectedColumns);
        buffer.append(" from ").append(this.getQualifiedTableName("model")).append(" ").append(tableAlias);
        buffer.append(" where ").append(partionColumnName).append(" = ");
        buffer.append(partitionInfo.getPartitionOid());
        buffer.append(" and ").append(idColumnName).append(" = ").append(SqlUtils.quoteParameter(modelId));
        buffer.append(" order by ").append(oidColumnName).append(" DESC");
        return buffer.toString();
    }

    @Override
    public Object[][] evaluateResultSet(List<IModel> allDeployedModels, ResultSet resultSet, Object[] parameterValues) {
        List<IModel> activeModels = ModelUtils.findActiveModels(allDeployedModels);
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        Localizer localizer = new Localizer(allDeployedModels);
        try {
            while (resultSet.next()) {
                Object[] row = new Object[this.reportColumns.size()];
                int i = 0;
                while (i < this.reportColumns.size()) {
                    long modelOid;
                    IModel activeModel;
                    String value = null;
                    DbAwareGroupColumn column = this.reportColumns.get(i);
                    value = column == this.isActiveColumn ? ((activeModel = ModelDetailsView.findModelByOID(activeModels, modelOid = this.oidColumn.getLongValue(resultSet))) == null ? Localizer.localizeBoolean(false) : Localizer.localizeBoolean(true)) : column.getStringValue(localizer, resultSet);
                    row[i] = value;
                    ++i;
                }
                rows.add(row);
            }
        }
        catch (SQLException e) {
            log.error(e);
            throw new RuntimeException(e);
        }
        return this.convertRowsToRowSet(rows);
    }
}

