/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common;

import java.util.List;
import java.util.Properties;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stardust.reporting.common.GroupColumn;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;
import org.eclipse.stardust.reporting.common.Parameter;
import org.eclipse.stardust.reporting.common.ReportingCommon_Messages;
import org.eclipse.stardust.reporting.common.View;

public class ModelPropertyColumn
extends GroupColumn {
    private static Logger log = LogUtils.getLogger(ModelPropertyColumn.class);
    private String propertyFullName;
    private Parameter valueFilterParameter;

    public ModelPropertyColumn(View view, String name, String label, Class type, String propertyFullName) {
        super(view, name, label, type, false, true);
        if (log.isDebugEnabled()) {
            log.debug("=> ModelPropertyColumn(,," + type + ")");
        }
        if (!view.allowsUserDefinedDataColumns().contains(this.getClass())) {
            throw new RuntimeException(ReportingCommon_Messages.ExceptionDataFieldsCannotBeDefinedForThisView);
        }
        this.propertyFullName = propertyFullName;
        this.adjustViewCumulation();
    }

    public ModelPropertyColumn(View view, String name, String label, Class type, Properties properties) {
        this(view, name, label, type, properties.getProperty("propertyFullName"));
    }

    @Override
    public void initViewParameter() {
        super.initViewParameter();
        this.valueFilterParameter = this.isNumeric() || this.isBoolean() ? this.getView().addParameter(NLS.bind((String)ReportingCommon_Messages.ValueFilter, (Object)this.getName()), this.getType(), false, Parameter.NUMERIC_DEFAULT_VALUE, null) : this.getView().addParameter(NLS.bind((String)ReportingCommon_Messages.ValueFilter, (Object)this.getName()), this.getType(), false, Parameter.STRING_DEFAULT_VALUE, null);
        this.addParameter(this.valueFilterParameter);
    }

    public String getPropertyFullName() {
        return this.propertyFullName;
    }

    public void setPropertyFullName(String propertyFullName) {
        this.propertyFullName = propertyFullName;
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.valueFilterParameter.setName(NLS.bind((String)ReportingCommon_Messages.ValueFilter, (Object)name));
        if (log.isDebugEnabled()) {
            log.debug("Value Filter renamed to " + this.valueFilterParameter.getName());
        }
    }

    @Override
    public void setType(Class type) {
        if (log.isDebugEnabled()) {
            log.debug("=> setType(" + type + ")");
        }
        super.setType(type);
        this.adjustViewCumulation();
        this.valueFilterParameter.setType(type);
        if (this.isNumeric() || this.isBoolean()) {
            this.valueFilterParameter.setDefaultValue(Parameter.NUMERIC_DEFAULT_VALUE);
        } else {
            this.valueFilterParameter.setDefaultValue(Parameter.STRING_DEFAULT_VALUE);
        }
    }

    public Parameter getValueFilterParameter() {
        return this.valueFilterParameter;
    }

    @Override
    public String getXMLSpecification() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<column type='");
        buffer.append(this.getClass().getName());
        buffer.append("' name='");
        buffer.append(this.getName());
        buffer.append("' columntype='");
        buffer.append(this.getType().getName());
        buffer.append("'>\n");
        buffer.append("<property name='propertyFullName'>" + (this.getPropertyFullName() != null ? this.getPropertyFullName() : "") + "</property>\n");
        buffer.append("</column>\n");
        return buffer.toString();
    }

    protected String getSelectFragment() {
        return "";
    }

    protected String getANSIJoin(List dataOIDList, boolean useOuterJoin) {
        return "";
    }

    protected String getDataValueFilter(Object[] parameters) {
        return "";
    }
}

