/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common;

import java.util.HashMap;
import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.error.PublicException;
import org.eclipse.stardust.reporting.common.ForeignDataColumn;
import org.eclipse.stardust.reporting.common.PredefinedForeignDataDescriptor;
import org.eclipse.stardust.reporting.common.ReportingCommon_Messages;
import org.eclipse.stardust.reporting.common.View;
import org.eclipse.stardust.reporting.common.utils.SqlUtils;

public class PredefinedForeignDataFactory {
    public static final String STARTING_PROCESS_ID_LITERAL = "STARTING_PROCESS_ID";
    public static final PredefinedForeignDataFactory STARTING_PROCESS_ID;
    private String name;
    private String tableId;
    private boolean useOuterJoins;
    private String foreignJoinColumnName;
    private static final Map tableNameProviders;

    static {
        tableNameProviders = new HashMap();
        STARTING_PROCESS_ID = new PredefinedForeignDataFactory(ReportingCommon_Messages.StartingProcessID, STARTING_PROCESS_ID_LITERAL, "ai_oid", true);
        tableNameProviders.put(STARTING_PROCESS_ID_LITERAL, new TableNameProvider(){

            @Override
            public String getTablename(View view) {
                return PredefinedForeignDataFactory.getStartingProcDefIdView(view);
            }
        });
    }

    private PredefinedForeignDataFactory(String name, String tableId, String foreignJoinColumnName, boolean useOuterJoins) {
        this.name = name;
        this.tableId = tableId;
        this.foreignJoinColumnName = "dummySchema.dummyTable." + foreignJoinColumnName;
        this.useOuterJoins = useOuterJoins;
    }

    public PredefinedForeignDataDescriptor getInstance(View view, String joinColumnName, String columnAlias, Class columnType, String qualifiedForeignColumnName) {
        PredefinedForeignDataDescriptor descriptor = new PredefinedForeignDataDescriptor(view, this.name, this.tableId, joinColumnName, this.useOuterJoins);
        descriptor.setQualifiedForeignJoinColumnName(this.foreignJoinColumnName);
        descriptor.addGroupColumn(new ForeignDataColumn(view, columnAlias, columnAlias, columnType, qualifiedForeignColumnName, false));
        return descriptor;
    }

    public static String getTableName(PredefinedForeignDataDescriptor descriptor) {
        TableNameProvider provider = (TableNameProvider)tableNameProviders.get(descriptor.getTableId());
        if (provider != null) {
            return provider.getTablename(descriptor.getView());
        }
        throw new PublicException(NLS.bind((String)ReportingCommon_Messages.CouldNotFindTablenameForTableId, (Object)descriptor.getTableId()));
    }

    private static String getStartingProcDefIdView(View view) {
        StringBuffer buffer = new StringBuffer();
        String mqtName = SqlUtils.getMqtForSubQuery(view, "StartingProcDef");
        if (!StringUtils.isEmpty((String)mqtName)) {
            buffer.append(mqtName);
        } else {
            buffer.append('(');
            buffer.append("SELECT ai.oid ai_oid,");
            buffer.append("       pd.Id");
            buffer.append(" FROM ").append(view.getQualifiedTableName("activity_instance ai"));
            buffer.append("       LEFT OUTER JOIN ").append(view.getQualifiedTableName("process_instance pi"));
            buffer.append("         ON (pi.oid = ai.processinstance)");
            buffer.append("       LEFT OUTER JOIN ").append(view.getQualifiedTableName("process_definition pd"));
            buffer.append("         ON (pd.oid = pi.processdefinition");
            buffer.append("             AND pd.model = pi.model)");
            buffer.append(')');
        }
        return buffer.toString();
    }

    private static interface TableNameProvider {
        public String getTablename(View var1);
    }
}

