/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common;

import java.sql.Connection;
import java.util.ArrayList;
import java.util.List;
import javax.xml.namespace.QName;
import org.eclipse.stardust.engine.api.dto.ModelDetails;
import org.eclipse.stardust.engine.api.model.IModel;
import org.eclipse.stardust.engine.api.model.ProcessDefinition;
import org.eclipse.stardust.engine.api.model.ProcessInterface;
import org.eclipse.stardust.engine.core.runtime.beans.ModelManagerFactory;
import org.eclipse.stardust.reporting.common.GroupColumn;
import org.eclipse.stardust.reporting.common.Parameter;
import org.eclipse.stardust.reporting.common.ProcessDatabaseQueryException;
import org.eclipse.stardust.reporting.common.ReportingCommon_Messages;
import org.eclipse.stardust.reporting.common.View;
import org.eclipse.stardust.reporting.common.utils.Localizer;
import org.eclipse.stardust.reporting.common.utils.ViewUtils;

public class ProvidedProcessInterfacesView
extends View {
    public static final String MODEL_VIEW_REPORT_TYPE = "ProvidedProcessInterfacesView";

    public ProvidedProcessInterfacesView() {
        super(MODEL_VIEW_REPORT_TYPE);
        this.addParameter("ModelOID", String.class, false, Parameter.STRING_DEFAULT_VALUE, null);
    }

    @Override
    protected void createDefaultFields() {
        this.addGroupColumn(new GroupColumn(this, "ModelId", ReportingCommon_Messages.ColumnModelId, String.class));
        this.addGroupColumn(new GroupColumn(this, "ModelName", ReportingCommon_Messages.ColumnModelName, String.class));
        this.addGroupColumn(new GroupColumn(this, "ProcessId", ReportingCommon_Messages.ColumnProcessId, String.class));
        this.addGroupColumn(new GroupColumn(this, "ProcessName", ReportingCommon_Messages.ColumnProcessName, String.class));
    }

    @Override
    protected String getModelOidParameter(Object[] parameters) {
        return (String)parameters[0];
    }

    @Override
    public String getReportType() {
        return MODEL_VIEW_REPORT_TYPE;
    }

    @Override
    public Object[][] executeQuery(List<IModel> allDeployedModels, Connection connection, Object[] parameterValues) throws ProcessDatabaseQueryException {
        Localizer localizer = new Localizer(allDeployedModels);
        ArrayList<Object[]> rows = new ArrayList<Object[]>();
        String modelOIDParam = this.getModelOidParameter(parameterValues);
        long reportModelOID = ViewUtils.converToLong(modelOIDParam);
        IModel model = ModelManagerFactory.getCurrent().findModel(reportModelOID);
        if (model != null) {
            ModelDetails modelDetails = new ModelDetails(model);
            List processDefs = modelDetails.getAllProcessDefinitions();
            for (ProcessDefinition def : processDefs) {
                ProcessInterface pi = def.getDeclaredProcessInterface();
                if (pi == null) continue;
                QName interfaceId = pi.getDeclaringProcessDefinitionId();
                String modelId = interfaceId.getNamespaceURI();
                String processId = interfaceId.getLocalPart();
                String modelName = this.getModelName(localizer, modelId);
                String processName = this.getProcessName(localizer, modelId, processId);
                Object[] row = new Object[]{modelId, modelName, processId, processName};
                rows.add(row);
            }
        }
        return this.convertRowsToRowSet(rows);
    }

    private String getProcessName(Localizer localizer, String modelId, String processId) {
        String processName = processId;
        IModel referencedModel = ModelManagerFactory.getCurrent().findActiveModel(modelId);
        if (referencedModel != null) {
            long modelOid = referencedModel.getModelOID();
            processName = localizer.localizeProcessName(modelOid, processId, processId);
        }
        return processName;
    }

    private String getModelName(Localizer localizer, String modelId) {
        String modelName = modelId;
        IModel referencedModel = ModelManagerFactory.getCurrent().findActiveModel(modelId);
        if (referencedModel != null) {
            long modelOid = referencedModel.getModelOID();
            modelName = localizer.localizeModelName(modelOid, modelId);
        }
        return modelName;
    }
}

