/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common;

import javax.ejb.CreateException;
import org.eclipse.core.runtime.Platform;
import org.eclipse.stardust.engine.api.model.Modules;
import org.eclipse.stardust.engine.api.runtime.ServiceNotAvailableException;
import org.eclipse.stardust.modeling.common.BpmCommonActivator;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;
import org.eclipse.stardust.reporting.common.ProcessDatabaseQueryService;
import org.eclipse.stardust.reporting.common.ProcessModelQueryService;
import org.eclipse.stardust.reporting.common.ReportingCommon_Messages;
import org.eclipse.stardust.reporting.common.beans.ProcessDatabaseQueryServiceEJB;
import org.eclipse.stardust.reporting.common.beans.ProcessModelQueryServiceEJB;
import org.eclipse.stardust.reporting.common.plugin.ReportingPlugin;

public class QueryServiceFactory {
    private static final Logger log = LogUtils.getLogger(QueryServiceFactory.class);
    private static String LICENSE_MESSAGE = ReportingCommon_Messages.LicenseNotValid;
    private static Modules[] modules = new Modules[]{Modules.REPORT_RUNTIME, Modules.DEVELOPER, Modules.MODELLING};
    private static QueryServiceFactory singleton;

    private QueryServiceFactory() {
    }

    public static synchronized QueryServiceFactory getInstance() {
        if (singleton == null) {
            singleton = new QueryServiceFactory();
        }
        return singleton;
    }

    public ProcessDatabaseQueryService createProcessDatabaseQueryService(String dataSourceName, String driverClassName, String databaseURL, String databaseAccount, String databasePassword, String databasePartition, String databaseDefaultSchema, String schemaPatterns, String worktimeCalculatorClassName) throws CreateException {
        try {
            if (Platform.isRunning()) {
                ReportingPlugin.initializeExtensions(Modules.REPORT_RUNTIME);
            }
        }
        catch (ServiceNotAvailableException e) {
            log.error((Object)e);
            throw new CreateException(LICENSE_MESSAGE);
        }
        try {
            return new ProcessDatabaseQueryServiceEJB(dataSourceName, driverClassName, databaseURL, databaseAccount, databasePassword, databasePartition, databaseDefaultSchema, schemaPatterns, worktimeCalculatorClassName);
        }
        catch (Exception e) {
            e.printStackTrace();
            throw new CreateException(e.getLocalizedMessage());
        }
    }

    public ProcessModelQueryService createProcessModelQueryService(String modelFilePath) throws CreateException {
        if (Platform.isRunning()) {
            BpmCommonActivator activator = BpmCommonActivator.getDefault();
            Exception le = null;
            Modules[] modulesArray = modules;
            int n = modules.length;
            int n2 = 0;
            while (n2 < n) {
                Modules module = modulesArray[n2];
                le = activator.initializeExtensions(module);
                if (le == null) break;
                ++n2;
            }
            if (le != null) {
                log.error(le);
                throw new CreateException(LICENSE_MESSAGE);
            }
        }
        try {
            if (log.isDebugEnabled()) {
                log.debug("Model file path: " + modelFilePath);
            }
            return new ProcessModelQueryServiceEJB(modelFilePath);
        }
        catch (Exception e) {
            log.error(e);
            throw new CreateException(e.getLocalizedMessage());
        }
    }
}

