/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common;

import java.io.PrintWriter;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Vector;
import javax.sql.DataSource;
import org.eclipse.stardust.common.config.CustomParameters;
import org.eclipse.stardust.common.config.Parameters;
import org.eclipse.stardust.common.error.ConcurrencyException;
import org.eclipse.stardust.engine.core.persistence.FetchPredicate;
import org.eclipse.stardust.engine.core.persistence.Join;
import org.eclipse.stardust.engine.core.persistence.Joins;
import org.eclipse.stardust.engine.core.persistence.Persistent;
import org.eclipse.stardust.engine.core.persistence.PersistentVector;
import org.eclipse.stardust.engine.core.persistence.PredicateTerm;
import org.eclipse.stardust.engine.core.persistence.QueryDescriptor;
import org.eclipse.stardust.engine.core.persistence.QueryExtension;
import org.eclipse.stardust.engine.core.persistence.ResultIterator;
import org.eclipse.stardust.engine.core.persistence.jdbc.DBDescriptor;
import org.eclipse.stardust.engine.core.persistence.jdbc.DmlManagerRegistry;
import org.eclipse.stardust.engine.core.persistence.jdbc.Session;
import org.eclipse.stardust.engine.core.persistence.jdbc.SqlUtils;
import org.eclipse.stardust.engine.core.persistence.jdbc.TypeDescriptorRegistry;
import org.eclipse.stardust.engine.core.runtime.setup.DataClusterInstance;
import org.eclipse.stardust.reporting.common.utils.sql.DbUtils;

public class ReportingSession
extends Session {
    private final String defaultSchemaName;
    private final Session session;

    public ReportingSession(String defaultSchemaName, Connection connection) {
        super("AuditTrail");
        this.defaultSchemaName = defaultSchemaName;
        CustomParameters customParams = new CustomParameters();
        customParams.setString("AuditTrail.Schema", this.defaultSchemaName);
        DBDescriptor dbDescriptor = DbUtils.getCurrentDbDescriptor();
        Session.DmlManagerRegistryProvider provider = new Session.DmlManagerRegistryProvider(){

            public DmlManagerRegistry getDmlManagerRegistry(String sessionName, SqlUtils sqlUtils, DBDescriptor dbDescriptor, TypeDescriptorRegistry tdRegistry) {
                DmlManagerRegistry registry = new DmlManagerRegistry();
                registry.registerDefaultRuntimeClasses(dbDescriptor, sqlUtils, tdRegistry);
                return registry;
            }
        };
        Session jdbcSession = new Session("AuditTrail", (Parameters)customParams, dbDescriptor, Session.DEFAULT_TYPE_DESCRIPTOR_REGISTRY_PROVIDER, provider);
        jdbcSession.connect((DataSource)new ConnectionWrapper(connection));
        this.session = jdbcSession;
    }

    public DBDescriptor getDBDescriptor() {
        return this.session.getDBDescriptor();
    }

    public void cluster(DataClusterInstance cluster) {
        throw new UnsupportedOperationException();
    }

    public void cluster(Persistent object) {
    }

    public PersistentVector createPersistentVector() {
        return this.session.createPersistentVector();
    }

    public void delete(Class type, PredicateTerm predicate, boolean delay) {
        throw new UnsupportedOperationException();
    }

    public void delete(Class type, PredicateTerm predicate, Join join, boolean delay) {
        throw new UnsupportedOperationException();
    }

    public void delete(Class type, PredicateTerm predicate, Joins joins, boolean delay) {
        throw new UnsupportedOperationException();
    }

    public void deleteAllInstances(Class type, boolean delay) {
        throw new UnsupportedOperationException();
    }

    public void disconnect() throws SQLException {
        this.session.disconnect();
    }

    public boolean exists(Class type, QueryExtension queryExtension) {
        return this.session.exists(type, queryExtension);
    }

    public boolean existsInCache(Class type, Object identityKey) {
        return this.session.existsInCache(type, identityKey);
    }

    public boolean isReadOnly() {
        return this.session.isReadOnly();
    }

    public Persistent fetchLink(Persistent persistent, String linkName) {
        return this.session.fetchLink(persistent, linkName);
    }

    public Persistent findByOID(Class type, long oid) {
        return this.session.findByOID(type, oid);
    }

    public Persistent findFirst(Class type, QueryExtension queryExtension, int timeout) {
        return this.session.findFirst(type, queryExtension, timeout);
    }

    public Persistent findFirst(Class type, QueryExtension queryExtension) {
        return this.session.findFirst(type, queryExtension);
    }

    public long getCount(Class type, QueryExtension queryExtension, boolean mayFail) {
        return this.session.getCount(type, queryExtension, mayFail);
    }

    public long getCount(Class type, QueryExtension queryExtension, FetchPredicate fetchPredicate, int timeout) {
        return this.session.getCount(type, queryExtension, fetchPredicate, timeout);
    }

    public long getCount(Class type, QueryExtension queryExtension, int timeout) {
        return this.session.getCount(type, queryExtension, timeout);
    }

    public long getCount(Class type, QueryExtension queryExtension) {
        return this.session.getCount(type, queryExtension);
    }

    public long getCount(Class type) {
        return this.session.getCount(type);
    }

    public ResultIterator getIterator(Class type, QueryExtension queryExtension, int startIndex, int extent, FetchPredicate fetchPredicate, boolean countAll, int timeout) {
        return this.session.getIterator(type, queryExtension, startIndex, extent, fetchPredicate, countAll, timeout);
    }

    public ResultIterator getIterator(Class type, QueryExtension queryExtension, int startIndex, int extent, int timeout) {
        return this.session.getIterator(type, queryExtension, startIndex, extent, timeout);
    }

    public ResultIterator getIterator(Class type, QueryExtension queryExtension, int startIndex, int extent) {
        return this.session.getIterator(type, queryExtension, startIndex, extent);
    }

    public ResultIterator getIterator(Class type, QueryExtension queryExtension) {
        return this.session.getIterator(type, queryExtension);
    }

    public ResultIterator getIterator(Class type) {
        return this.session.getIterator(type);
    }

    public Vector getVector(Class type, QueryExtension queryExtension) {
        return this.session.getVector(type, queryExtension);
    }

    public Vector getVector(Class type) {
        return this.session.getVector(type);
    }

    public boolean isSynchronized(Persistent persistent) {
        return this.session.isSynchronized(persistent);
    }

    public void lock(Class type, long oid) throws ConcurrencyException {
        throw new UnsupportedOperationException();
    }

    public void rollback() {
        throw new UnsupportedOperationException();
    }

    public void save() {
        throw new UnsupportedOperationException();
    }

    public void flush() {
    }

    public boolean isUsingDataClusters() {
        return false;
    }

    public void setSynchronized(Persistent persistent) {
        this.session.setSynchronized(persistent);
    }

    public ResultSet executeQuery(QueryDescriptor queryDescr) {
        return this.session.executeQuery(queryDescr, 0);
    }

    private static class ConnectionWrapper
    implements DataSource {
        Connection connection;

        private ConnectionWrapper(Connection connection) {
            this.connection = connection;
        }

        @Override
        public Connection getConnection() throws SQLException {
            return this.connection;
        }

        @Override
        public Connection getConnection(String username, String password) throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public int getLoginTimeout() throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public PrintWriter getLogWriter() throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setLoginTimeout(int seconds) throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public void setLogWriter(PrintWriter out) throws SQLException {
            throw new UnsupportedOperationException();
        }

        @Override
        public <T> T unwrap(Class<T> iface) throws SQLException {
            return null;
        }

        @Override
        public boolean isWrapperFor(Class<?> iface) throws SQLException {
            return false;
        }
    }
}

