/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common;

import java.util.List;
import java.util.Properties;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.reporting.common.AbstractDataColumn;
import org.eclipse.stardust.reporting.common.ColumnProvider;
import org.eclipse.stardust.reporting.common.DataInfo;
import org.eclipse.stardust.reporting.common.DataJoinInfo;
import org.eclipse.stardust.reporting.common.DbColumnRef;
import org.eclipse.stardust.reporting.common.IOneOfManyColumns;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;
import org.eclipse.stardust.reporting.common.Parameter;
import org.eclipse.stardust.reporting.common.ReportingCommon_Messages;
import org.eclipse.stardust.reporting.common.StructDataDescriptor;
import org.eclipse.stardust.reporting.common.View;
import org.eclipse.stardust.reporting.common.utils.ViewUtils;

public class StructDataColumn
extends AbstractDataColumn
implements IOneOfManyColumns {
    private static final long serialVersionUID = 1L;
    private static Logger log = LogUtils.getLogger(StructDataColumn.class);
    private StructDataDescriptor descriptor = null;
    private String xpath;

    public StructDataColumn(View view, String name, String label, Class type, String xpath) {
        super(view, name, label, type, false, true);
        this.xpath = xpath;
    }

    public StructDataColumn(View view, String name, String label, Class type, Properties properties) {
        this(view, name, label, type, properties.getProperty("xpath").length() > 0 ? properties.getProperty("xpath") : null);
    }

    @Override
    public void initViewParameter() {
        String filterDefault = Parameter.STRING_DEFAULT_VALUE;
        String columnName = "string_value";
        if (this.isNumeric() || this.isBoolean()) {
            filterDefault = Parameter.NUMERIC_DEFAULT_VALUE;
            columnName = "number_value";
        }
        this.valueFilterParameter = this.getView().addParameter(NLS.bind((String)ReportingCommon_Messages.ValueFilter, (Object)this.getFullName()), this.getType(), false, filterDefault, null);
        this.setDbColumnRef(new DbColumnRef(columnName, null, this.getAlias()));
        this.addParameter(this.valueFilterParameter);
    }

    public String getXpath() {
        return this.xpath;
    }

    @Override
    public Parameter getValueFilterParameter() {
        return this.valueFilterParameter;
    }

    @Override
    public String getDataValueFilter(Object[] parameters) {
        StringBuffer buffer = new StringBuffer();
        String stringifiedParameterValue = parameters[this.getValueFilterParameter().getIndex() - 1].toString();
        stringifiedParameterValue = stringifiedParameterValue.replaceAll("(?i:true)", "1");
        stringifiedParameterValue = stringifiedParameterValue.replaceAll("(?i:false)", "0");
        stringifiedParameterValue = ViewUtils.replaceDateWithTimeInMillis(stringifiedParameterValue);
        String[] parameterParts = stringifiedParameterValue.split(",");
        int n = 0;
        while (n < parameterParts.length) {
            stringifiedParameterValue = parameterParts[n].trim();
            if (this.isNumeric() || this.isBoolean()) {
                if (stringifiedParameterValue.length() != 0) {
                    if (n == 0) {
                        buffer.append(" (");
                    } else {
                        buffer.append(" or ");
                    }
                    buffer.append(this.getAlias());
                    buffer.append(".number_value = ");
                    buffer.append(stringifiedParameterValue);
                }
            } else if (stringifiedParameterValue.length() != 0 && !stringifiedParameterValue.equals("%")) {
                if (n == 0) {
                    buffer.append(" (");
                } else {
                    buffer.append(" or ");
                }
                buffer.append(this.getAlias());
                buffer.append(".string_value like '");
                buffer.append(stringifiedParameterValue);
                buffer.append("'");
            }
            ++n;
        }
        if (buffer.length() > 0) {
            buffer.append(")");
        }
        return buffer.toString();
    }

    @Override
    public String getSelectFragment() {
        StringBuffer buffer = new StringBuffer();
        String alias = this.getAlias();
        buffer.append(alias);
        buffer.append(".type_key");
        buffer.append(", ");
        buffer.append(alias);
        buffer.append(".string_value");
        buffer.append(", ");
        buffer.append(alias);
        buffer.append(".number_value");
        buffer.append(", ");
        buffer.append(alias);
        buffer.append(".oid");
        return buffer.toString();
    }

    @Override
    public String getAnsiJoin(List<DataJoinInfo> joinInfos, boolean useOuterJoin) {
        StringBuffer buffer = new StringBuffer();
        if (useOuterJoin) {
            buffer.append(" left outer join ");
        } else {
            buffer.append(" inner join ");
        }
        buffer.append(this.getView().getQualifiedTableName("structured_data_value")).append(' ');
        String alias = this.getAlias();
        buffer.append(alias);
        buffer.append(" on (pi.scopeprocessinstance = ");
        buffer.append(alias);
        buffer.append(".processinstance and (");
        if (joinInfos != null && !joinInfos.isEmpty()) {
            int count = 0;
            for (DataJoinInfo joinInfo : joinInfos) {
                if (++count > 1) {
                    buffer.append(" or ");
                }
                buffer.append(alias);
                buffer.append(".xpath = ");
                buffer.append(joinInfo.getDataValueInfo().getXPathOid());
                List<StructDataColumn> sameParentColumns = joinInfo.getSameParentColumns();
                if (sameParentColumns == null || sameParentColumns.isEmpty()) continue;
                StructDataColumn sameParentColumn = sameParentColumns.get(0);
                buffer.append(" and ");
                buffer.append(this.getAlias());
                buffer.append(".");
                buffer.append("parent");
                buffer.append(" = ");
                buffer.append(sameParentColumn.getAlias());
                buffer.append(".");
                buffer.append("parent");
            }
        } else {
            buffer.append(alias);
            buffer.append(".xpath = ");
            buffer.append(-1);
        }
        buffer.append("))");
        return buffer.toString();
    }

    public String getANSIJoin(List<DataInfo> dataValueInfos, boolean useOuterJoin, String additionalJoinCondition) {
        StringBuffer buffer = new StringBuffer();
        if (useOuterJoin) {
            buffer.append(" left outer join ");
        } else {
            buffer.append(" inner join ");
        }
        buffer.append(this.getView().getQualifiedTableName("structured_data_value")).append(' ');
        String alias = this.getAlias();
        buffer.append(alias);
        buffer.append(" on (pi.scopeprocessinstance = ");
        buffer.append(alias);
        buffer.append(".processinstance and (");
        if (dataValueInfos != null && !dataValueInfos.isEmpty()) {
            int count = 0;
            for (DataInfo info : dataValueInfos) {
                if (++count > 1) {
                    buffer.append(" or ");
                }
                buffer.append(alias);
                buffer.append(".xpath = ");
                buffer.append(info.getXPathOid());
            }
        } else {
            buffer.append(alias);
            buffer.append(".xpath = ");
            buffer.append(-1);
        }
        if (StringUtils.isNotEmpty((String)additionalJoinCondition)) {
            buffer.append(additionalJoinCondition);
        }
        buffer.append("))");
        return buffer.toString();
    }

    @Override
    public String getAliasedColumn() {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.getAlias());
        if (this.isNumeric() || this.isBoolean()) {
            buffer.append(".number_value");
        } else {
            buffer.append(".string_value");
        }
        return buffer.toString();
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        this.valueFilterParameter.setName(NLS.bind((String)ReportingCommon_Messages.ValueFilter, (Object)name));
        if (log.isDebugEnabled()) {
            log.debug("Value Filter renamed to " + this.valueFilterParameter.getName());
        }
    }

    @Override
    public String getXMLSpecification() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<column type='");
        buffer.append(this.getClass().getName());
        buffer.append("' name='");
        buffer.append(this.getName());
        buffer.append("' columntype='");
        buffer.append(this.getType().getName());
        buffer.append("'>\n");
        buffer.append("<property name='xpath'>" + this.getXpath()).append("</property>\n");
        buffer.append("</column>\n");
        return buffer.toString();
    }

    @Override
    public ColumnProvider getColumnProvider() {
        return this.descriptor;
    }

    @Override
    public void setColumnProvider(ColumnProvider columnProvider) {
        this.descriptor = (StructDataDescriptor)columnProvider;
    }

    @Override
    public String getDataId() {
        return this.descriptor.getDataId();
    }

    @Override
    public String getModelId() {
        if (this.descriptor != null) {
            return this.descriptor.getModelId();
        }
        return super.getModelId();
    }

    @Override
    public String getAttributeName() {
        return this.getXpath();
    }

    @Override
    public String getFullName() {
        return this.descriptor == null ? this.getName() : String.valueOf(this.descriptor.getName()) + "_" + this.getName();
    }
}

