/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;
import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.engine.api.model.IModel;
import org.eclipse.stardust.engine.api.query.UserQuery;
import org.eclipse.stardust.engine.api.runtime.QueryService;
import org.eclipse.stardust.engine.core.persistence.jdbc.DBDescriptor;
import org.eclipse.stardust.engine.core.runtime.utils.Authorization2;
import org.eclipse.stardust.engine.core.runtime.utils.AuthorizationContext;
import org.eclipse.stardust.reporting.common.GroupColumn;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;
import org.eclipse.stardust.reporting.common.Parameter;
import org.eclipse.stardust.reporting.common.ReportingCommon_Messages;
import org.eclipse.stardust.reporting.common.View;
import org.eclipse.stardust.reporting.common.metadata.columns.DbColumn;
import org.eclipse.stardust.reporting.common.metadata.columns.IDbColumn;
import org.eclipse.stardust.reporting.common.utils.MathUtils;
import org.eclipse.stardust.reporting.common.utils.sql.DbUtils;

public class UserWorklistView
extends View {
    private static Logger log = LogUtils.getLogger(UserWorklistView.class);

    public UserWorklistView() {
        super("UserWorklist");
        DbColumn uFirstName = new DbColumn("firstName", "u");
        DbColumn uLastName = new DbColumn("lastName", "u");
        DbColumn aId = new DbColumn("id", "ad");
        DbColumn aiStartTime = new DbColumn("startTime", "ai");
        DbColumn aiLastMod = new DbColumn("lastModificationTime", "ai");
        this.addParameter(ReportingCommon_Messages.ColumnUserFirstName, String.class, false, Parameter.STRING_DEFAULT_VALUE, uFirstName.getQualifiedName());
        this.addParameter(ReportingCommon_Messages.ColumnUserLastName, String.class, false, Parameter.STRING_DEFAULT_VALUE, uLastName.getQualifiedName());
        this.addParameter(ReportingCommon_Messages.ColumnActivityIds, String.class, false, Parameter.STRING_DEFAULT_VALUE, aId.getQualifiedName());
        View.ReportingTimestampRange timestampRange = new View.ReportingTimestampRange();
        this.addParameter(ReportingCommon_Messages.ColumnStartDate, Timestamp.class, false, timestampRange.getSqlStartTimestamp().toString(), aiStartTime.getQualifiedName());
        this.addParameter(ReportingCommon_Messages.ColumnEndDate, Timestamp.class, false, timestampRange.getSqlEndTimestamp().toString(), aiLastMod.getQualifiedName());
    }

    @Override
    protected void createDefaultFields() {
        this.addGroupColumn(new GroupColumn(this, "OID", ReportingCommon_Messages.ColumnOid, Long.class));
        this.addGroupColumn(new GroupColumn(this, "ID", ReportingCommon_Messages.ColumnId, String.class));
        this.addGroupColumn(new GroupColumn(this, "FirstName", ReportingCommon_Messages.ColumnFirstName, String.class));
        this.addGroupColumn(new GroupColumn(this, "LastName", ReportingCommon_Messages.ColumnLastName, String.class));
        this.addGroupColumn(new GroupColumn(this, "EMail", ReportingCommon_Messages.ColumnEmail, String.class));
        this.addGroupColumn(new GroupColumn(this, "Description", ReportingCommon_Messages.ColumnDescription, String.class));
        this.addGroupColumn(new GroupColumn(this, "ValidFrom", ReportingCommon_Messages.ColumnValidFrom, Date.class));
        this.addGroupColumn(new GroupColumn(this, "ValidTo", ReportingCommon_Messages.ColumnValidTo, Date.class));
        this.addGroupColumn(new GroupColumn(this, "TotalAssignedItemCount", ReportingCommon_Messages.ColumnTotalAssignedItemCount, Integer.class));
        this.addGroupColumn(new GroupColumn(this, "TotalPerformedItemCount", ReportingCommon_Messages.ColumnTotalFormdItemCount, Integer.class));
        this.addGroupColumn(new GroupColumn(this, "WorkingTimeOnUnfinishedActivities", ReportingCommon_Messages.ColumnWorktimeOnUnfinishedActivities, Long.class));
        this.addGroupColumn(new GroupColumn(this, "WorkingTimeOnCompletedActivties", ReportingCommon_Messages.ColumnTimeOnCompletedActivities, Long.class));
        this.addGroupColumn(new GroupColumn(this, "TotalWorkingTime", ReportingCommon_Messages.ColumnTotalWorkingTime, Long.class));
        this.addGroupColumn(new GroupColumn(this, "FullTimeEquivalent", ReportingCommon_Messages.ColumnFullTimeEquivalent, Long.class));
        this.addGroupColumn(new GroupColumn(this, "PercentageWorkload", ReportingCommon_Messages.ColumnPercentageWorkLoad, BigDecimal.class));
    }

    @Override
    public String getReportType() {
        return "UserWorklist";
    }

    @Override
    public String getQueryString(List<IModel> allDeployedModels, Object[] parameters) {
        DbColumn wuLastName = new DbColumn("lastName", "u");
        DbColumn aiStartTime = new DbColumn("startTime", "ai");
        DBDescriptor dbDescriptor = DbUtils.getCurrentDbDescriptor();
        DbColumn aiCurUserPerf = new DbColumn("currentUserPerformer", "ai");
        DbColumn aiPerBy = new DbColumn("performedBy", "ai");
        String selectList = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("oid", "u"), new DbColumn("account", "u"), new DbColumn("firstName", "u"), wuLastName, new DbColumn("eMail", "u"), new DbColumn("description", "u"), new DbColumn("validFrom", "u"), new DbColumn("validTo", "u"), aiCurUserPerf, aiPerBy, aiStartTime, new DbColumn("lastModificationTime", "ai"), new DbColumn("model", "ai"), new DbColumn("id", "ad")});
        StringBuffer buffer = new StringBuffer(500);
        buffer.append("select distinct ").append(selectList);
        buffer.append(" from ").append(this.getCurrentPartitionSqlFragment(this.getQualifiedTableName("workflowuser"), "u"));
        String predicate1 = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("oid", "u"), aiPerBy}, " = ");
        String predicate2 = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("oid", "u"), aiCurUserPerf}, " = ");
        buffer.append(" inner join ").append(this.getQualifiedTableName("activity_instance")).append(' ').append("ai").append(DbUtils.getOrOnFragment(predicate1, predicate2));
        predicate1 = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("activity", "ai"), new DbColumn("oid", "ad")}, " = ");
        predicate2 = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("model", "ai"), new DbColumn("model", "ad")}, " = ");
        buffer.append(" inner join ").append(this.getQualifiedTableName("activity")).append(' ').append("ad").append(DbUtils.getAndOnFragment(predicate1, predicate2));
        String parameterFilters = this.getParameterFilters(parameters, false);
        if (!StringUtils.isEmpty((String)parameterFilters)) {
            buffer.append(" where ").append(parameterFilters);
        }
        buffer.append(" order by ").append(DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{wuLastName, aiStartTime}));
        return buffer.toString();
    }

    @Override
    public Object[][] evaluateResultSet(List<IModel> allDeployedModels, ResultSet resultSet, Object[] parameterValues) {
        LogUtils.enterInternal(log, "evaluateResultSet()");
        try {
            Object[] row;
            long userOID = 0L;
            int performedInstanceCount = 0;
            int assignedInstanceCount = 0;
            long workingTimeOnUnfinishedActivitiesMillis = 0L;
            long workingTimeOnCompletedActivitiesMillis = 0L;
            long totalWorkingTimeMillis = 0L;
            long fteMillis = 0L;
            long startTime = 0L;
            String userID = null;
            String userFirstName = null;
            String userLastName = null;
            String userEMail = null;
            String userDescription = null;
            long validFrom = 0L;
            long validTo = 0L;
            DecimalFormatSymbols dezimalSymbol = new DecimalFormatSymbols();
            dezimalSymbol.setDecimalSeparator('.');
            DecimalFormat format = new DecimalFormat("0.00", dezimalSymbol);
            ArrayList<Object[]> rows = new ArrayList<Object[]>();
            while (resultSet.next()) {
                String activityId;
                boolean initLoginData = this.initLoginData();
                boolean canFetchUser = true;
                if (initLoginData) {
                    long modelOid = resultSet.getLong(13);
                    AuthorizationContext authorizationContext = AuthorizationContext.create(QueryService.class, (String)"getAllUsers", (Class[])new Class[]{UserQuery.class});
                    authorizationContext.setModel(modelOid);
                    canFetchUser = Authorization2.hasPermission((AuthorizationContext)authorizationContext);
                }
                if ("DefaultCaseActivity".equals(activityId = resultSet.getString(14)) || !canFetchUser) continue;
                if (userOID == 0L) {
                    userOID = resultSet.getLong(1);
                    userID = resultSet.getString(2);
                    userFirstName = resultSet.getString(3);
                    userLastName = resultSet.getString(4);
                    userEMail = resultSet.getString(5);
                    userDescription = resultSet.getString(6);
                    validFrom = resultSet.getLong(7);
                    validTo = resultSet.getLong(8);
                    startTime = resultSet.getLong(11);
                }
                if (userOID != resultSet.getLong(1)) {
                    row = new Object[15];
                    row[0] = new Long(userOID);
                    row[1] = userID;
                    row[2] = userFirstName;
                    row[3] = userLastName;
                    row[4] = userEMail;
                    row[5] = userDescription;
                    row[6] = new Date(validFrom);
                    row[7] = validTo != 0L ? new Date(validTo) : null;
                    row[8] = new Integer(assignedInstanceCount);
                    row[9] = new Integer(performedInstanceCount);
                    row[10] = new Long(workingTimeOnUnfinishedActivitiesMillis / 1000L / 60L);
                    row[11] = new Long(workingTimeOnCompletedActivitiesMillis / 1000L / 60L);
                    row[12] = new Long(totalWorkingTimeMillis / 1000L / 60L);
                    fteMillis = System.currentTimeMillis() - startTime;
                    row[13] = new Long(fteMillis / 1000L / 60L);
                    double a = 100.0 * (double)totalWorkingTimeMillis;
                    long b = fteMillis;
                    double percentage = MathUtils.divide(a, b);
                    if (log.isDebugEnabled()) {
                        log.debug(format.format(percentage));
                    }
                    row[14] = new BigDecimal(format.format(percentage));
                    rows.add(row);
                    userOID = resultSet.getLong(1);
                    userID = resultSet.getString(2);
                    userFirstName = resultSet.getString(3);
                    userLastName = resultSet.getString(4);
                    userEMail = resultSet.getString(5);
                    userDescription = resultSet.getString(6);
                    validFrom = resultSet.getLong(7);
                    validTo = resultSet.getLong(8);
                    startTime = resultSet.getLong(11);
                    performedInstanceCount = 0;
                    assignedInstanceCount = 0;
                    totalWorkingTimeMillis = 0L;
                    workingTimeOnUnfinishedActivitiesMillis = 0L;
                    workingTimeOnCompletedActivitiesMillis = 0L;
                }
                if (resultSet.getLong(9) != 0L) {
                    ++assignedInstanceCount;
                    workingTimeOnUnfinishedActivitiesMillis += resultSet.getLong(12) - resultSet.getLong(11);
                } else {
                    ++performedInstanceCount;
                    workingTimeOnCompletedActivitiesMillis += resultSet.getLong(12) - resultSet.getLong(11);
                }
                totalWorkingTimeMillis += resultSet.getLong(12) - resultSet.getLong(11);
            }
            if (userOID != 0L) {
                row = new Object[15];
                row[0] = new Long(userOID);
                row[1] = userID;
                row[2] = userFirstName;
                row[3] = userLastName;
                row[4] = userEMail;
                row[5] = userDescription;
                row[6] = new Date(validFrom);
                row[7] = validTo != 0L ? new Date(validTo) : null;
                row[8] = new Integer(assignedInstanceCount);
                row[9] = new Integer(performedInstanceCount);
                row[10] = new Long(workingTimeOnUnfinishedActivitiesMillis / 1000L / 60L);
                row[11] = new Long(workingTimeOnCompletedActivitiesMillis / 1000L / 60L);
                row[12] = new Long(totalWorkingTimeMillis / 1000L / 60L);
                fteMillis = System.currentTimeMillis() - startTime;
                row[13] = new Long(fteMillis / 1000L / 60L);
                double a = 100.0 * (double)totalWorkingTimeMillis;
                long b = fteMillis;
                double percentage = MathUtils.divide(a, b);
                row[14] = new BigDecimal(format.format(percentage));
                rows.add(row);
            }
            LogUtils.exitInternal(log, "evaluateResultSet()");
            return this.convertRowsToRowSet(rows);
        }
        catch (SQLException e) {
            log.error(e);
            throw new RuntimeException(e);
        }
    }

    @Override
    protected String getCurrentPartitionSqlFragment(String tableName, String tableAlias) {
        StringBuffer buffer = new StringBuffer();
        DBDescriptor dbDescriptor = DbUtils.getCurrentDbDescriptor();
        buffer.append(this.getQualifiedTableName("wfuser_realm")).append(' ').append("ur");
        DbColumn partition = new DbColumn(dbDescriptor.quoteIdentifier("partition"), "ur");
        String predicate = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("realm", tableAlias), new DbColumn("oid", "ur")}, " = ");
        buffer.append(" inner join ").append(tableName).append(' ').append(tableAlias).append(" on (").append(partition).append(" = ").append(this.getPartitionInfo().getPartitionOid()).append(" AND ").append(predicate).append(")");
        return buffer.toString();
    }
}

