/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.sql.Connection;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.antlr.runtime.tree.CommonTree;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stardust.common.CompareHelper;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.config.CurrentVersion;
import org.eclipse.stardust.common.config.Version;
import org.eclipse.stardust.engine.api.model.IModel;
import org.eclipse.stardust.engine.core.compatibility.ipp.PreStardustTypeNameResolver;
import org.eclipse.stardust.engine.core.persistence.Operator;
import org.eclipse.stardust.engine.core.runtime.utils.AbstractAuthorization2Predicate;
import org.eclipse.stardust.engine.core.runtime.utils.AuthorizationContext;
import org.eclipse.stardust.reporting.common.AbstractCumulationAspect;
import org.eclipse.stardust.reporting.common.AbstractDataColumn;
import org.eclipse.stardust.reporting.common.ActiveModelsView;
import org.eclipse.stardust.reporting.common.ActivityInstanceStateChangeView;
import org.eclipse.stardust.reporting.common.ActivityInstanceView;
import org.eclipse.stardust.reporting.common.Column;
import org.eclipse.stardust.reporting.common.ColumnProvider;
import org.eclipse.stardust.reporting.common.ConsumedProcessInterfacesView;
import org.eclipse.stardust.reporting.common.CumulationKeyGenerator;
import org.eclipse.stardust.reporting.common.DataColumn;
import org.eclipse.stardust.reporting.common.DataColumnAliasRegistry;
import org.eclipse.stardust.reporting.common.DataInfo;
import org.eclipse.stardust.reporting.common.DataJoinInfo;
import org.eclipse.stardust.reporting.common.DataValueView;
import org.eclipse.stardust.reporting.common.DbColumnRef;
import org.eclipse.stardust.reporting.common.EnumStructDataColumn;
import org.eclipse.stardust.reporting.common.ForeignDataColumn;
import org.eclipse.stardust.reporting.common.ForeignDataDescriptor;
import org.eclipse.stardust.reporting.common.GroupColumn;
import org.eclipse.stardust.reporting.common.IDataColumn;
import org.eclipse.stardust.reporting.common.LogEntryView;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;
import org.eclipse.stardust.reporting.common.ModelConsumerView;
import org.eclipse.stardust.reporting.common.ModelDetailsView;
import org.eclipse.stardust.reporting.common.ModelPropertyColumn;
import org.eclipse.stardust.reporting.common.ModelProviderView;
import org.eclipse.stardust.reporting.common.OrganizationalWorklistView;
import org.eclipse.stardust.reporting.common.Parameter;
import org.eclipse.stardust.reporting.common.PartitionInfo;
import org.eclipse.stardust.reporting.common.PathView;
import org.eclipse.stardust.reporting.common.ProcessDatabaseQueryException;
import org.eclipse.stardust.reporting.common.ProcessInstanceStateView;
import org.eclipse.stardust.reporting.common.ProcessInstanceView;
import org.eclipse.stardust.reporting.common.ProvidedProcessInterfacesView;
import org.eclipse.stardust.reporting.common.QualityAssuranceCodeView;
import org.eclipse.stardust.reporting.common.QualityAssuranceView;
import org.eclipse.stardust.reporting.common.ReportingCommon_Messages;
import org.eclipse.stardust.reporting.common.StructDataColumn;
import org.eclipse.stardust.reporting.common.StructDataDescriptor;
import org.eclipse.stardust.reporting.common.SubColumn;
import org.eclipse.stardust.reporting.common.TransitionView;
import org.eclipse.stardust.reporting.common.UserWorklistView;
import org.eclipse.stardust.reporting.common.WorkflowUserView;
import org.eclipse.stardust.reporting.common.cluster.ClusterInfo;
import org.eclipse.stardust.reporting.common.cluster.Data2ClusterMapper;
import org.eclipse.stardust.reporting.common.cluster.IData2ClusterMapper;
import org.eclipse.stardust.reporting.common.i18n.LocalizationUtils;
import org.eclipse.stardust.reporting.common.metadata.columns.DbColumn;
import org.eclipse.stardust.reporting.common.metadata.columns.DbTable;
import org.eclipse.stardust.reporting.common.parser.ExpressionUtil;
import org.eclipse.stardust.reporting.common.parser.ParsedExpression;
import org.eclipse.stardust.reporting.common.parser.generated.ExpressionGrammarParser;
import org.eclipse.stardust.reporting.common.utils.SqlUtils;
import org.eclipse.stardust.reporting.common.utils.UserDefinedColumnsIterator;
import org.eclipse.stardust.reporting.common.utils.ViewUtils;
import org.eclipse.stardust.reporting.common.utils.sql.DbUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public abstract class View
implements Cloneable {
    private static Logger log = LogUtils.getLogger(View.class);
    private static Logger perf = LogUtils.getLogger(String.valueOf(View.class.getName()) + "PERF", "DEBUG");
    protected static final char SPACE = ' ';
    protected static final String P_TABLE_NAME = "process_definition";
    protected static final String P_ALIAS = "pd";
    protected static final String A_TABLE_NAME = "activity";
    protected static final String A_ALIAS = "ad";
    protected static final String PI_TABLE_NAME = "process_instance";
    protected static final String PI_ALIAS = "pi";
    protected static final String AI_TABLE_NAME = "activity_instance";
    protected static final String AI_ALIAS = "ai";
    protected static final String PIH_TABLE_NAME = "procinst_hierarchy";
    protected static final String PIH_ALIAS = "pih";
    protected static final String PIH_FIELD_PI = "processInstance";
    protected static final String PIH_FIELD_SUB_PI = "subProcessInstance";
    protected static final String AIH_TABLE_NAME = "act_inst_history";
    protected static final String AIH_ALIAS = "aih";
    protected static final String AIH_FIELD_PI = "processInstance";
    protected static final String AIH_FIELD_AI = "activityInstance";
    protected static final String AIH_FIELD_STATE = "state";
    protected static final String AIH_FIELD_FROM = "fromTimestamp";
    protected static final String AIH_FIELD_UNTIL = "untilTimestamp";
    protected static final String AIHA_ALIAS = "aih_view";
    protected static final String PIAT_ALIAS = "piat";
    protected static final String SPIAT_ALIAS = "spiat";
    protected static final String SD_ALIAS = "sd";
    protected static final String SDV_ALIAS = "sdv";
    protected static final String DEP_TABLE_NAME = "department";
    protected static final String DEP_ALIAS = "dptm";
    public static final String EXPRESSION_TAG_NAME = "expression";
    public static final String[] EXPRESSION_TAGS = new String[]{"<expression>", "</expression>"};
    public static final String USE_EXPRESSION_BUILDER_ATT_TAG = "useExpressionBuilder";
    public static final String GROUP_BY_COLUMNS_ATT_TAG = "groupByColumns";
    public static final String ADD_TOTAL_ACTIVE_TIME_COLUMN_ATT_TAG = "addTotalActiveTimeColumn";
    public static final String PROVIDE_EMPTY_GROUP_VALUES_ATT_TAG = "provideEmptyGroupValues";
    public static final String REPORT_TYPE = "reportType";
    public static final String NAME_PROPERTY = "name";
    public static final String CUMULATED = "cumulated";
    public static final String INTERVAL_LENGTH = "intervalLength";
    public static final String PROCESS_FILTER = "processFilter";
    public static final String START_TIME_STAMP = "startTimeStamp";
    public static final String END_TIME_STAMP = "endTimeStamp";
    public static final String PATH_REPORT_TYPE = "Path";
    public static final String PROCESS_INSTANCE_REPORT_TYPE = "ProcessInstance";
    public static final String PROCESS_INSTANCE_STATE_REPORT_TYPE = "ProcessState";
    public static final String ACTIVITY_INSTANCE_REPORT_TYPE = "ActivityInstance";
    public static final String ACTIVITY_INSTANCE_STATE_CHANGE_REPORT_TYPE = "ActivityInstanceStateChange";
    public static final String RESOURCE_REPORT_TYPE = "Resource";
    public static final String ORGANIZATIONAL_WORKLIST_REPORT_TYPE = "OrganizationalWorklist";
    public static final String USER_WORKLIST_REPORT_TYPE = "UserWorklist";
    public static final String LOG_ENTRY_REPORT_TYPE = "LogEntry";
    public static final String TRANSITION_REPORT_TYPE = "Transition";
    public static final String DATA_VALUE_REPORT_TYPE = "DataValue";
    public static final String MODEL_TABLE_NAME = "model";
    public static final String MODEL_VARIABLE_NAME = "m";
    public static final String PROCESS_INSTANCE_TABLE_NAME = "process_instance";
    public static final String PROCESS_INSTANCE_VARIABLE_NAME = "pi";
    public static final String PROCESS_TABLE_NAME = "process_definition";
    public static final String PROCESS_VARIABLE_NAME = "p";
    public static final String DV_TABLE_NAME = "data_value";
    public static final String DV_ALIAS = "dv";
    public static final String DATA_TABLE_NAME = "data";
    public static final String DATA_ALIAS = "dd";
    public static final String STRUCT_DATA_TABLE_NAME = "structured_data";
    public static final String STRUCT_DATA_ALIAS = "sd";
    public static final String STRUCT_DV_TABLE_NAME = "structured_data_value";
    public static final String STRUCT_DV_ALIAS = "sdv";
    public static final String ACTIVITY_INSTANCE_TABLE_NAME = "activity_instance";
    public static final String ACTIVITY_INSTANCE_VARIABLE_NAME = "ai";
    public static final String ACTIVITY_TABLE_NAME = "activity";
    public static final String ACTIVITY_VARIABLE_NAME = "a";
    public static final String TRANSITION_TABLE_NAME = "transition";
    public static final String TRANSITION_INSTANCE_TABLE_NAME = "trans_inst";
    public static final String PARTICIPANT_TABLE_NAME = "participant";
    public static final String PARTICIPANT_VARIABLE_NAME = "mpd";
    public static final String USER_TABLE_NAME = "workflowuser";
    public static final String USER_VARIABLE_NAME = "wu";
    public static final String LOG_ENTRY_TABLE_NAME = "log_entry";
    public static final String LOG_ENTRY_VARIABLE_NAME = "le";
    public static final String SINGLE_INTERVAL = "single";
    public static final String YEAR_INTERVAL = "year";
    public static final String QUARTER_INTERVAL = "quarter";
    public static final String MONTH_INTERVAL = "month";
    public static final String WEEK_INTERVAL = "week";
    public static final String DAY_INTERVAL = "day";
    public static final String HOUR_INTERVAL = "hour";
    public static final String MINUTE_INTERVAL = "minute";
    public static final String[] INTERVAL_TYPES = new String[]{"single", "year", "quarter", "month", "week", "day", "hour", "minute"};
    public static final String MODEL_ID_PARAMETER_NAME = "ModelID";
    public static final String MODEL_OID_PARAMETER_NAME = "ModelOID";
    protected static final String MODEL_TAB_NAME = "model";
    protected static final String REALM_TAB_NAME = "wfuser_realm";
    protected static final String PROCDEF_TAB_NAME = "process_definition";
    protected static final String ACTIVITY_TAB_NAME = "activity";
    protected static final String PROCINST_TAB_NAME = "process_instance";
    protected static final String ACTIVITYINST_TAB_NAME = "activity_instance";
    protected static final String PROCINST_TAB_ALIAS = "pi";
    protected static final String ACTIVITYINST_TAB_ALIAS = "ai";
    protected static final String PROCDEF_TAB_ALIAS = "p";
    protected static final String ACTIVITY_TAB_ALIAS = "a";
    private PartitionInfo partitionInfo;
    private static Map<Class<? extends View>, String> viewClassMap = new HashMap<Class<? extends View>, String>();
    private String id;
    private boolean cumulated;
    private boolean provideEmptyGroupValues;
    private String intervalType;
    private String defaultSchemaName;
    private boolean useExpressionBuilder;
    private String expression;
    private Version version;
    private List uncumulatedGroupColumnList;
    private List uncumulatedLeafColumnList;
    private List cumulatedGroupColumnList;
    private List cumulatedLeafColumnList;
    private List columnProviderList;
    private List optionalColumnProviderList;
    private List parameters;
    protected Map tableNames;
    private List groupByGroupColumns;
    private List[] groupByDomains;
    protected IData2ClusterMapper dataMapper;
    private boolean isGroupingHandlingNecessary = false;
    private DataColumnAliasRegistry aliasRegistry;
    protected Connection connection;
    protected AuthorizationContext authorizationContext;
    protected AbstractAuthorization2Predicate authPredicate;
    protected boolean initLoginData = false;

    static {
        View.addViewClass(ProcessInstanceView.class, ReportingCommon_Messages.ProcessInstanceView);
        View.addViewClass(ProcessInstanceStateView.class, ReportingCommon_Messages.ProcessInstanceStateView);
        View.addViewClass(ActivityInstanceView.class, ReportingCommon_Messages.ActivityInstanceView);
        View.addViewClass(ActivityInstanceStateChangeView.class, ReportingCommon_Messages.ActivityInstanceStateChangeView);
        View.addViewClass(OrganizationalWorklistView.class, ReportingCommon_Messages.OrganizationalWorklistView);
        View.addViewClass(UserWorklistView.class, ReportingCommon_Messages.UserWorklistView);
        View.addViewClass(LogEntryView.class, ReportingCommon_Messages.LogEntryView);
        View.addViewClass(DataValueView.class, ReportingCommon_Messages.DataValueView);
        View.addViewClass(TransitionView.class, ReportingCommon_Messages.TransitionView);
        View.addViewClass(PathView.class, ReportingCommon_Messages.PathView);
        View.addViewClass(ActiveModelsView.class, ReportingCommon_Messages.ActiveModelsView);
        View.addViewClass(ModelDetailsView.class, ReportingCommon_Messages.ModelDetailsView);
        View.addViewClass(ModelConsumerView.class, ReportingCommon_Messages.ModelConsumerView);
        View.addViewClass(ModelProviderView.class, ReportingCommon_Messages.ModelProviderView);
        View.addViewClass(ConsumedProcessInterfacesView.class, ReportingCommon_Messages.ConsumedProcessInterfacesView);
        View.addViewClass(ProvidedProcessInterfacesView.class, ReportingCommon_Messages.ProvidedProcessInterfacesView);
        View.addViewClass(WorkflowUserView.class, ReportingCommon_Messages.WorkflowUserView);
        View.addViewClass(QualityAssuranceView.class, ReportingCommon_Messages.QualityAssuranceView);
        View.addViewClass(QualityAssuranceCodeView.class, ReportingCommon_Messages.QualityAssuranceCodeView);
        if (log.isDebugEnabled()) {
            log.debug("View class list initialized.");
        }
    }

    private static void addViewClass(Class<? extends View> viewClass, String localizedName) {
        try {
            viewClassMap.put(viewClass, localizedName);
        }
        catch (Exception x) {
            x.printStackTrace();
            log.error(x);
            throw new RuntimeException(NLS.bind((String)ReportingCommon_Messages.CouldNotAddViewClass, viewClass, (Object)x));
        }
        if (log.isDebugEnabled()) {
            log.debug("View class " + viewClass + " added.");
        }
    }

    public static Collection getAllViewClasses() {
        ArrayList<Class<? extends View>> viewClasses = new ArrayList<Class<? extends View>>(viewClassMap.keySet());
        Collections.sort(viewClasses, new ClassNameComparator());
        return viewClasses;
    }

    public static String getLabel(Class<? extends View> viewClass) {
        String label = LocalizationUtils.getLabel(viewClassMap, viewClass);
        return label;
    }

    protected boolean initLoginData() {
        return ViewUtils.isAuthentificationRequired();
    }

    public static View readFromXMLEncoded(String xmlString) {
        LogUtils.enterInternal(log, "readFromXMLEncoded()");
        if (xmlString.startsWith("<![CDATA[")) {
            xmlString = xmlString.substring(9, xmlString.length() - 3);
            if (log.isDebugEnabled()) {
                log.debug("CDATA Decoding: " + xmlString);
            }
        }
        xmlString = xmlString.replaceAll("@lt;", "<");
        xmlString = xmlString.replaceAll("@gt;", ">");
        View view = View.readFromXML(xmlString);
        LogUtils.enterInternal(log, "readFromXMLEncoded()");
        return view;
    }

    public static View readFromXML(String xmlString) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            Node groupByColumnAttributeNode;
            String viewClassType;
            PreStardustTypeNameResolver resolver;
            String newViewClassType;
            DocumentBuilder builder = factory.newDocumentBuilder();
            Document document = builder.parse(new ByteArrayInputStream(("<?xml version='1.0'?>" + xmlString).getBytes()));
            NodeList nodeList = document.getChildNodes();
            Node viewNode = nodeList.item(0);
            if (log.isDebugEnabled()) {
                log.debug(viewNode.getNodeName());
            }
            if ((newViewClassType = (resolver = new PreStardustTypeNameResolver()).resolveTypeName(viewClassType = viewNode.getAttributes().getNamedItem("type").getNodeValue())) != null) {
                viewClassType = newViewClassType;
            }
            Class<?> type = Class.forName(viewClassType);
            Constructor<?> constructor = type.getConstructor(new Class[0]);
            View view = (View)constructor.newInstance(new Object[0]);
            String nameString = viewNode.getAttributes().getNamedItem(NAME_PROPERTY).getNodeValue();
            view.setName(nameString);
            if (log.isDebugEnabled()) {
                log.debug("Importing view " + nameString);
            }
            Node versionNode = viewNode.getAttributes().getNamedItem("version");
            String versionString = null;
            if (versionNode != null && !StringUtils.isEmpty((String)(versionString = versionNode.getNodeValue()))) {
                view.setVersion(new Version(versionString));
                if (log.isDebugEnabled()) {
                    log.debug("Set property version to " + versionString);
                }
            }
            String cumulatedString = viewNode.getAttributes().getNamedItem(CUMULATED).getNodeValue();
            if (log.isDebugEnabled()) {
                log.debug("Set property cumulated to " + cumulatedString + " " + Boolean.valueOf(cumulatedString));
            }
            view.setCumulated(Boolean.valueOf(cumulatedString));
            if (view.isCumulated()) {
                String intervalTypeString = viewNode.getAttributes().getNamedItem("cumulationIntervalType").getNodeValue();
                view.setIntervalType(intervalTypeString);
                Node attributeNode = viewNode.getAttributes().getNamedItem(PROVIDE_EMPTY_GROUP_VALUES_ATT_TAG);
                if (attributeNode != null) {
                    String providesEmptyGroupValuesString = attributeNode.getNodeValue();
                    view.setProvideEmptyGroupValues(Boolean.valueOf(providesEmptyGroupValuesString));
                }
            }
            Node addActiveTimeColumnNode = viewNode.getAttributes().getNamedItem(ADD_TOTAL_ACTIVE_TIME_COLUMN_ATT_TAG);
            String addTotalActiveTimeColumnString = Boolean.FALSE.toString();
            if (addActiveTimeColumnNode != null) {
                addTotalActiveTimeColumnString = addActiveTimeColumnNode.getNodeValue();
            }
            view.setAddingTotalActiveTimeColumn(Boolean.valueOf(addTotalActiveTimeColumnString));
            Node useExprBuilderAttNode = viewNode.getAttributes().getNamedItem(USE_EXPRESSION_BUILDER_ATT_TAG);
            if (useExprBuilderAttNode != null) {
                String useExpressionBuilder = useExprBuilderAttNode.getNodeValue();
                view.setUseExpressionBuilder(Boolean.valueOf(useExpressionBuilder));
            }
            nodeList = viewNode.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node = nodeList.item(n);
                if ("column".equalsIgnoreCase(node.getNodeName())) {
                    GroupColumn rawGroupColumn = View.processColumnNode(node, view);
                    if (rawGroupColumn instanceof ForeignDataColumn) {
                        Properties properties = new Properties();
                        NodeList propertyNodeList = node.getChildNodes();
                        int m = 0;
                        while (m < propertyNodeList.getLength()) {
                            Node propertyNode = propertyNodeList.item(m);
                            if (propertyNode.getNodeName().equalsIgnoreCase("property")) {
                                String propertyName = propertyNode.getAttributes().getNamedItem(NAME_PROPERTY).getNodeValue();
                                String propertyValue = "";
                                NodeList propertyValueNodeList = propertyNode.getChildNodes();
                                int k = 0;
                                while (k < propertyValueNodeList.getLength()) {
                                    propertyValue = String.valueOf(propertyValue) + propertyValueNodeList.item(k).getNodeValue();
                                    ++k;
                                }
                                properties.setProperty(propertyName, propertyValue);
                            }
                            ++m;
                        }
                        ForeignDataColumn foreignDataColumn = (ForeignDataColumn)rawGroupColumn;
                        ForeignDataDescriptor foreignDataDescriptor = new ForeignDataDescriptor(foreignDataColumn.getView(), foreignDataColumn.getName(), properties.getProperty("qualifiedForeignJoinColumnName").length() > 0 ? properties.getProperty("qualifiedForeignJoinColumnName") : null, properties.getProperty("joinColumnName").length() > 0 ? properties.getProperty("joinColumnName") : null, properties.getProperty("useOuterJoin") == null || properties.getProperty("useOuterJoin").length() > 0 ? Boolean.valueOf(properties.getProperty("useOuterJoin")) : false);
                        foreignDataDescriptor.addGroupColumn(foreignDataColumn);
                        view.addColumnProvider(foreignDataDescriptor);
                    } else {
                        view.addGroupColumn(rawGroupColumn);
                    }
                } else if ("columnProvider".equalsIgnoreCase(node.getNodeName())) {
                    view.addColumnProvider(View.processProviderNode(node, view));
                } else if (EXPRESSION_TAG_NAME.equalsIgnoreCase(node.getNodeName())) {
                    view.setExpression(View.processExpression(node));
                }
                ++n;
            }
            if (log.isDebugEnabled()) {
                log.debug("All columns parsed.");
            }
            if (view.isCumulated() && (groupByColumnAttributeNode = viewNode.getAttributes().getNamedItem(GROUP_BY_COLUMNS_ATT_TAG)) != null) {
                String[] groupByColumnNames = groupByColumnAttributeNode.getNodeValue().split(",");
                ArrayList<GroupColumn> list = new ArrayList<GroupColumn>();
                int n2 = 0;
                while (n2 < groupByColumnNames.length) {
                    list.add(view.findGroupColumnByName(groupByColumnNames[n2].trim()));
                    ++n2;
                }
                view.setGroupByGroupColumns(list);
            }
            return view;
        }
        catch (ParserConfigurationException e1) {
            log.error(e1);
            throw new RuntimeException(e1);
        }
        catch (SAXException e) {
            log.error(e);
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            log.error(e);
            throw new RuntimeException(e);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
            log.error(e);
            throw new RuntimeException(e);
        }
        catch (SecurityException e) {
            log.error(e);
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            log.error(e);
            throw new RuntimeException(e);
        }
        catch (IllegalArgumentException e) {
            log.error(e);
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            log.error(e);
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            log.error(e);
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            log.error(e);
            throw new RuntimeException(e);
        }
    }

    private static GroupColumn processColumnNode(Node columnNode, View view) {
        try {
            String providerName;
            PreStardustTypeNameResolver resolver = new PreStardustTypeNameResolver();
            String typeString = columnNode.getAttributes().getNamedItem("type").getNodeValue();
            String newTypeString = resolver.resolveTypeName(typeString);
            if (StringUtils.isNotEmpty((String)newTypeString)) {
                typeString = newTypeString;
            }
            if (log.isDebugEnabled()) {
                log.debug("Parsing column " + typeString);
            }
            Class<?> type = Class.forName(typeString);
            String nameString = columnNode.getAttributes().getNamedItem(NAME_PROPERTY).getNodeValue();
            String columnTypeString = columnNode.getAttributes().getNamedItem("columntype").getNodeValue();
            Class<?> columnType = Class.forName(columnTypeString);
            Properties properties = new Properties();
            NodeList propertyNodeList = columnNode.getChildNodes();
            int m = 0;
            while (m < propertyNodeList.getLength()) {
                Node propertyNode = propertyNodeList.item(m);
                if (propertyNode.getNodeName().equalsIgnoreCase("property")) {
                    String propertyName = propertyNode.getAttributes().getNamedItem(NAME_PROPERTY).getNodeValue();
                    String propertyValue = "";
                    NodeList propertyValueNodeList = propertyNode.getChildNodes();
                    int k = 0;
                    while (k < propertyValueNodeList.getLength()) {
                        propertyValue = String.valueOf(propertyValue) + propertyValueNodeList.item(k).getNodeValue();
                        ++k;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug(String.valueOf(propertyName) + "=" + propertyValue);
                    }
                    properties.setProperty(propertyName, propertyValue);
                }
                ++m;
            }
            Constructor<?> constructor = type.getConstructor(View.class, String.class, String.class, Class.class, Properties.class);
            Version upgradeVersion = new Version(4, 9, 0);
            Version viewVersion = view.getVersion();
            if ((viewVersion == null || upgradeVersion.compareTo(viewVersion) == 1) && StructDataColumn.class.isAssignableFrom(type) && nameString.startsWith(String.valueOf(providerName = columnNode.getParentNode().getAttributes().getNamedItem(NAME_PROPERTY).getNodeValue()) + "_")) {
                nameString = nameString.substring(providerName.length() + 1);
            }
            GroupColumn groupColumn = (GroupColumn)constructor.newInstance(view, nameString, nameString, columnType, properties);
            return groupColumn;
        }
        catch (ClassNotFoundException e) {
            log.error(e);
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            log.error(e);
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            log.error(e);
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            log.error(e);
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            log.error(e);
            throw new RuntimeException(e);
        }
    }

    private static String processExpression(Node expressionNode) {
        Node child = expressionNode.getFirstChild();
        Node sibling = child.getNextSibling();
        return sibling != null ? sibling.getNodeValue() : "";
    }

    private static ColumnProvider processProviderNode(Node providerNode, View view) {
        try {
            PreStardustTypeNameResolver resolver = new PreStardustTypeNameResolver();
            String typeString = providerNode.getAttributes().getNamedItem("type").getNodeValue();
            String newTypeString = resolver.resolveTypeName(typeString);
            if (StringUtils.isNotEmpty((String)newTypeString)) {
                typeString = newTypeString;
            }
            if (log.isDebugEnabled()) {
                log.debug("Parsing provider " + typeString);
            }
            Class<?> type = Class.forName(typeString);
            String nameString = providerNode.getAttributes().getNamedItem(NAME_PROPERTY).getNodeValue();
            Properties properties = new Properties();
            NodeList propertyNodeList = providerNode.getChildNodes();
            int m = 0;
            while (m < propertyNodeList.getLength()) {
                Node propertyNode = propertyNodeList.item(m);
                if (propertyNode.getNodeName().equalsIgnoreCase("property")) {
                    String propertyName = propertyNode.getAttributes().getNamedItem(NAME_PROPERTY).getNodeValue();
                    String propertyValue = "";
                    NodeList propertyValueNodeList = propertyNode.getChildNodes();
                    int k = 0;
                    while (k < propertyValueNodeList.getLength()) {
                        propertyValue = String.valueOf(propertyValue) + propertyValueNodeList.item(k).getNodeValue();
                        ++k;
                    }
                    if (log.isDebugEnabled()) {
                        log.debug(String.valueOf(propertyName) + "=" + propertyValue);
                    }
                    properties.setProperty(propertyName, propertyValue);
                }
                ++m;
            }
            Constructor<?> constructor = type.getConstructor(View.class, String.class, Properties.class);
            ColumnProvider provider = (ColumnProvider)constructor.newInstance(view, nameString, properties);
            NodeList nodeList = providerNode.getChildNodes();
            int n = 0;
            while (n < nodeList.getLength()) {
                Node node = nodeList.item(n);
                if ("column".equalsIgnoreCase(node.getNodeName())) {
                    GroupColumn groupColumn = View.processColumnNode(node, view);
                    provider.addGroupColumn(groupColumn);
                }
                ++n;
            }
            return provider;
        }
        catch (ClassNotFoundException e) {
            log.error(e);
            throw new RuntimeException(e);
        }
        catch (NoSuchMethodException e) {
            log.error(e);
            throw new RuntimeException(e);
        }
        catch (IllegalAccessException e) {
            log.error(e);
            throw new RuntimeException(e);
        }
        catch (InstantiationException e) {
            log.error(e);
            throw new RuntimeException(e);
        }
        catch (InvocationTargetException e) {
            log.error(e);
            throw new RuntimeException(e);
        }
    }

    protected View(String id) {
        this.id = id;
        this.intervalType = DAY_INTERVAL;
        this.uncumulatedGroupColumnList = new ArrayList();
        this.uncumulatedLeafColumnList = new ArrayList();
        this.cumulatedGroupColumnList = new ArrayList();
        this.cumulatedLeafColumnList = new ArrayList();
        this.columnProviderList = new ArrayList();
        this.optionalColumnProviderList = new ArrayList();
        this.parameters = new ArrayList();
        this.createDefaultFields();
        this.groupByGroupColumns = new ArrayList();
        this.groupByDomains = new List[0];
        this.aliasRegistry = new DataColumnAliasRegistry();
    }

    protected abstract void createDefaultFields();

    protected void clearAllFields() {
        this.uncumulatedGroupColumnList.clear();
        this.uncumulatedLeafColumnList.clear();
        this.cumulatedGroupColumnList.clear();
        this.cumulatedLeafColumnList.clear();
        this.columnProviderList.clear();
        this.optionalColumnProviderList.clear();
    }

    public String getName() {
        return this.id;
    }

    public Version getVersion() {
        return this.version;
    }

    public void setVersion(Version version) {
        this.version = version;
    }

    public void setName(String name) {
        this.id = name;
    }

    public String getLabel() {
        String label = View.getLabel(this.getClass());
        if (this.isCumulated()) {
            label = String.valueOf(label) + ReportingCommon_Messages.CumulatedView;
        }
        return label;
    }

    public GroupColumn findGroupColumnByName(String name) {
        int n = 0;
        while (n < this.getGroupColumns().size()) {
            GroupColumn groupColumn = (GroupColumn)this.getGroupColumns().get(n);
            if (groupColumn.getName().equals(name)) {
                return groupColumn;
            }
            ++n;
        }
        return null;
    }

    public GroupColumn findGroupColumnByParameter(Parameter parameter) {
        HashSet allGroupColumns = new HashSet(this.uncumulatedGroupColumnList);
        allGroupColumns.addAll(this.cumulatedGroupColumnList);
        for (GroupColumn groupColumn : allGroupColumns) {
            DbColumnRef dbColumnRef = groupColumn.getDbColumnRef();
            if (dbColumnRef == null || !dbColumnRef.getTableAliasedColumnId().equalsIgnoreCase(parameter.getColumnID())) continue;
            return groupColumn;
        }
        return null;
    }

    public void addColumnProvider(ColumnProvider provider) {
        this.columnProviderList.add(provider);
        for (Object rawColumn : provider.getGroupColumns()) {
            if (!(rawColumn instanceof GroupColumn)) continue;
            GroupColumn groupColumn = (GroupColumn)rawColumn;
            this.addGroupColumn(groupColumn);
        }
    }

    public void removeColumnProvider(ColumnProvider provider) {
        if (provider != null) {
            for (Object rawColumn : provider.getGroupColumns()) {
                if (!(rawColumn instanceof GroupColumn)) continue;
                GroupColumn groupColumn = (GroupColumn)rawColumn;
                this.removeGroupColumn(groupColumn);
            }
            this.columnProviderList.remove(provider);
        }
    }

    public void addOptionalColumnProvider(ColumnProvider provider) {
        this.optionalColumnProviderList.add(provider);
    }

    public void removeOptionalColumnProvider(ColumnProvider provider) {
        this.removeColumnProvider(provider);
        this.columnProviderList.remove(provider);
    }

    public void addGroupColumn(GroupColumn field) {
        field.initViewParameter();
        this.addGroupColumnUncumulated(field);
        this.addGroupColumnCumulated(field);
    }

    public void addGroupColumns(List<? extends GroupColumn> columns) {
        for (GroupColumn groupColumn : columns) {
            this.addGroupColumn(groupColumn);
        }
    }

    protected boolean userDefinedColumnsFromSameModel() {
        UserDefinedColumnsIterator iter = new UserDefinedColumnsIterator(this.getGroupColumns().iterator());
        String previousModelId = "";
        int count = 0;
        while (iter.hasNext()) {
            Object o = iter.next();
            String modelId = null;
            if (!(o instanceof AbstractDataColumn)) continue;
            ++count;
            modelId = ((AbstractDataColumn)o).getModelId();
            if (StringUtils.isEmpty((String)modelId)) {
                return false;
            }
            if (count > 1 && !modelId.equals(previousModelId)) {
                return false;
            }
            previousModelId = modelId;
        }
        return true;
    }

    protected void addGroupColumnUncumulated(GroupColumn column) {
        if (log.isDebugEnabled()) {
            log.debug("Adding default field " + column.getFullName() + " in report " + this.getName() + ".");
        }
        this.uncumulatedGroupColumnList.add(column);
        this.uncumulatedLeafColumnList.add(column);
        if (log.isDebugEnabled()) {
            log.debug("Added field " + column.getName() + " as leaf.");
        }
    }

    protected void addGroupColumnCumulated(GroupColumn column) {
        this.cumulatedGroupColumnList.add(column);
        Iterator iterator = column.getSubFields().iterator();
        if (iterator.hasNext()) {
            while (iterator.hasNext()) {
                SubColumn subField = (SubColumn)iterator.next();
                this.cumulatedLeafColumnList.add(subField);
            }
        } else {
            this.cumulatedLeafColumnList.add(column);
        }
    }

    public void remove(String dataId, String modelId) {
        StructDataDescriptor dataDescriptor;
        AbstractDataColumn dataColumn = this.findDataColumn(dataId, modelId);
        if (dataColumn != null) {
            this.removeGroupColumn(dataColumn);
        }
        if ((dataDescriptor = this.findStructDataDescriptor(dataId, modelId)) != null) {
            this.removeColumnProvider(dataDescriptor);
        }
    }

    private StructDataDescriptor findStructDataDescriptor(String dataId, String modelId) {
        List columnProvider = this.getColumnProvider();
        for (Object o : columnProvider) {
            StructDataDescriptor dataDescriptor;
            if (!(o instanceof StructDataDescriptor) || !(dataDescriptor = (StructDataDescriptor)o).getModelId().equals(modelId) || !dataDescriptor.getDataId().equals(dataId)) continue;
            return dataDescriptor;
        }
        return null;
    }

    private AbstractDataColumn findDataColumn(String dataId, String modelId) {
        List groupColumns = this.getGroupColumns();
        for (Object o : groupColumns) {
            AbstractDataColumn dataColumn;
            if (!(o instanceof AbstractDataColumn) || !(dataColumn = (AbstractDataColumn)o).getModelId().equals(modelId) || !dataColumn.getDataId().equals(dataId)) continue;
            return dataColumn;
        }
        return null;
    }

    public void removeGroupColumn(GroupColumn column) {
        if (column != null) {
            if (log.isDebugEnabled()) {
                log.debug("Removing group column " + column.getFullName() + " in report " + this.getName() + ".");
            }
            this.uncumulatedGroupColumnList.remove(column);
            this.uncumulatedLeafColumnList.remove(column);
            this.cumulatedGroupColumnList.remove(column);
            Iterator iterator = column.getSubFields().iterator();
            if (iterator.hasNext()) {
                while (iterator.hasNext()) {
                    SubColumn subField = (SubColumn)iterator.next();
                    this.cumulatedLeafColumnList.remove(subField);
                    if (!log.isDebugEnabled()) continue;
                    log.debug("Removed sub column " + subField.getFullName() + " for group column " + column.getName());
                }
            } else {
                this.cumulatedLeafColumnList.remove(column);
            }
            for (Parameter parameter : column.getParameters()) {
                this.parameters.remove(parameter);
            }
            this.groupByGroupColumns.remove(column);
        }
    }

    public List getGroupColumns() {
        if (this.isCumulated()) {
            return this.cumulatedGroupColumnList;
        }
        return this.uncumulatedGroupColumnList;
    }

    public List getLeafFields() {
        if (this.isCumulated()) {
            return this.cumulatedLeafColumnList;
        }
        return this.uncumulatedLeafColumnList;
    }

    public List getLeafColumnsUncumulated() {
        return this.uncumulatedLeafColumnList;
    }

    public List getLeafColumnsCumulated() {
        return this.cumulatedLeafColumnList;
    }

    protected int getUserDefinedColumnsCount() {
        int columnCount = 0;
        UserDefinedColumnsIterator iter = new UserDefinedColumnsIterator(this.getGroupColumns().iterator());
        while (iter.hasNext()) {
            ++columnCount;
            iter.next();
        }
        return columnCount;
    }

    protected int getCumulatableColumnsCount() {
        int columnCount = 0;
        int n = 0;
        while (n < this.getGroupColumns().size()) {
            GroupColumn column = (GroupColumn)this.getGroupColumns().get(n);
            if (column.isCumulatable() && column != this.groupByGroupColumns) {
                ++columnCount;
            }
            ++n;
        }
        return columnCount;
    }

    protected int getUncumulatableColumnsCount() {
        int columnCount = 0;
        int n = 0;
        while (n < this.getGroupColumns().size()) {
            GroupColumn column = (GroupColumn)this.getGroupColumns().get(n);
            if (!column.isCumulatable() && column != this.groupByGroupColumns) {
                ++columnCount;
            }
            ++n;
        }
        return columnCount;
    }

    public int getColumnIndexUncumulated(GroupColumn column) {
        int n = 0;
        while (n < this.uncumulatedGroupColumnList.size()) {
            if (column == this.uncumulatedGroupColumnList.get(n)) {
                return n;
            }
            ++n;
        }
        return -1;
    }

    public void setCumulated(boolean cumulated) {
        this.cumulated = cumulated;
    }

    protected int getUncumulatedTimestampColumnIndex() {
        return -1;
    }

    protected int getCumulatedTimestampColumnIndex() {
        return -1;
    }

    protected int getCumulatedVolumeColumnIndex() {
        return -1;
    }

    public boolean canBeCumulated() {
        return false;
    }

    public boolean mustBeCumulated() {
        return false;
    }

    public List allowsUserDefinedDataColumns() {
        ArrayList<Class<ModelPropertyColumn>> classList = new ArrayList<Class<ModelPropertyColumn>>();
        classList.add(ModelPropertyColumn.class);
        return classList;
    }

    public boolean isCumulated() {
        return this.cumulated;
    }

    public boolean isProvidingEmptyGroupValues() {
        return this.provideEmptyGroupValues;
    }

    public void setProvideEmptyGroupValues(boolean provideEmptyGroupValues) {
        this.provideEmptyGroupValues = provideEmptyGroupValues;
    }

    public String getIntervalType() {
        return this.intervalType;
    }

    public void setIntervalType(String intervalType) {
        this.intervalType = intervalType;
    }

    public abstract String getReportType();

    public List getParameters() {
        return this.parameters;
    }

    public Parameter addParameter(String name, Class type, boolean nullable, String value, String columnID) {
        Parameter parameter = new Parameter(this.parameters.size() + 1, name, type, nullable, value, columnID);
        this.parameters.add(parameter);
        return parameter;
    }

    public Parameter getParameterByName(String name) {
        for (Parameter parameter : this.parameters) {
            if (!parameter.getName().equals(name)) continue;
            return parameter;
        }
        return null;
    }

    public List getGroupByGroupCandidateColumns() {
        ArrayList<GroupColumn> list = new ArrayList<GroupColumn>();
        int n = 0;
        while (n < this.getGroupColumns().size()) {
            GroupColumn groupColumn = (GroupColumn)this.getGroupColumns().get(n);
            if ((groupColumn.isPredefined() && this.uncumulatedGroupColumnList.contains(groupColumn) || groupColumn instanceof IDataColumn || groupColumn instanceof ForeignDataColumn) && !this.getGroupByGroupColumns().contains(groupColumn)) {
                list.add(groupColumn);
            }
            ++n;
        }
        return list;
    }

    public List getGroupByGroupColumns() {
        return this.groupByGroupColumns;
    }

    public void setGroupByGroupColumns(List groupByGroupColumns) {
        if (groupByGroupColumns == null) {
            throw new IllegalArgumentException(ReportingCommon_Messages.ExceptionGroupByColumnListMustNotBeNull);
        }
        this.groupByGroupColumns = groupByGroupColumns;
        this.cumulatedLeafColumnList.clear();
        int n = 0;
        while (n < this.getGroupColumns().size()) {
            GroupColumn groupColumn = (GroupColumn)this.getGroupColumns().get(n);
            if (groupByGroupColumns.contains(groupColumn)) {
                this.cumulatedLeafColumnList.add(groupColumn);
            } else {
                Iterator iterator = groupColumn.getSubFields().iterator();
                if (iterator.hasNext()) {
                    while (iterator.hasNext()) {
                        SubColumn subField = (SubColumn)iterator.next();
                        this.cumulatedLeafColumnList.add(subField);
                    }
                } else {
                    this.cumulatedLeafColumnList.add(groupColumn);
                }
            }
            ++n;
        }
    }

    public String getSelectString() {
        LogUtils.enterInternal(log, "getSelectString()");
        String selectString = "";
        Iterator iterator = this.uncumulatedGroupColumnList.iterator();
        boolean first = true;
        while (iterator.hasNext()) {
            GroupColumn groupColumn = (GroupColumn)iterator.next();
            if (groupColumn.getQueryVariable() == null) continue;
            if (first) {
                first = false;
            } else {
                selectString = String.valueOf(selectString) + ", ";
            }
            selectString = String.valueOf(selectString) + groupColumn.getQueryVariable();
        }
        LogUtils.exitInternal(log, "getSelectString()");
        return selectString;
    }

    public String getFromString() {
        LogUtils.enterInternal(log, "getFromString()");
        StringBuffer buffer = new StringBuffer(100);
        Iterator iterator = this.tableNames.keySet().iterator();
        while (iterator.hasNext()) {
            String key = (String)iterator.next();
            buffer.append(this.getQualifiedTableName(key)).append(" ").append(this.tableNames.get(key));
            if (!iterator.hasNext()) continue;
            buffer.append(", ");
        }
        LogUtils.exitInternal(log, "getFromString()");
        return buffer.toString();
    }

    public String getWhereString(Object[] parameters) {
        return null;
    }

    protected String getModelSelectionFragment(String operator, Object[] parameters) {
        String modelIdParam;
        StringBuffer fragment = new StringBuffer();
        String modelOidParam = this.getModelOidParameter(parameters);
        long modelOid = ViewUtils.determineModelOid(modelOidParam, modelIdParam = this.getModelIdParameter(parameters));
        if (modelOid != -1L) {
            DbColumn modelOidField = new DbColumn("oid", MODEL_VARIABLE_NAME);
            fragment.append(operator);
            fragment.append(modelOidField);
            fragment.append(" = ");
            fragment.append(modelOid);
        }
        return fragment.toString();
    }

    protected String getModelJoinFragment(String joinTableAlias, String joinColumnName, String selectTableAlias) {
        PartitionInfo partitionInfo = this.getPartitionInfo();
        DbColumn joinSourceColumn = new DbColumn(joinColumnName, selectTableAlias);
        DbColumn joinTargetColumn = new DbColumn("oid", joinTableAlias);
        DbColumn partitionColumn = new DbColumn("partition", joinTableAlias);
        StringBuffer buffer = new StringBuffer();
        buffer.append("inner join ").append(this.getQualifiedTableName("model")).append(" ");
        buffer.append(joinTableAlias).append(" on(").append(joinSourceColumn).append(" = ").append(joinTargetColumn);
        buffer.append(" and ").append(partitionColumn).append(" = ").append(partitionInfo.getPartitionOid()).append(")");
        return buffer.toString();
    }

    protected String getModelIdParameter(Object[] parameters) {
        return null;
    }

    protected String getModelOidParameter(Object[] parameters) {
        return null;
    }

    public String getQueryString(List<IModel> allDeployedModels, Object[] parameters) throws ProcessDatabaseQueryException {
        LogUtils.enterInternal(log, "getQueryString()");
        String queryString = "select distinct ";
        queryString = String.valueOf(queryString) + this.getSelectString();
        queryString = String.valueOf(queryString) + " from ";
        queryString = String.valueOf(queryString) + this.getFromString();
        String whereClause = this.getWhereString(parameters);
        if (whereClause != null && whereClause.trim().length() > 0) {
            queryString = String.valueOf(queryString) + " where ";
            queryString = String.valueOf(queryString) + whereClause;
        }
        LogUtils.exitInternal(log, "getQueryString()");
        return queryString;
    }

    protected Map<IDataColumn, List<DataInfo>> getDataInfos(List<? extends IDataColumn> dataColumns) throws SQLException {
        PreparedStatement ps = null;
        ResultSet rs = null;
        HashSet<String> predicates = new HashSet<String>();
        HashMap<IDataColumn, List<DataInfo>> dataInfoMap = new HashMap<IDataColumn, List<DataInfo>>();
        for (IDataColumn iDataColumn : dataColumns) {
            String xpathPredicate = "' and sd.xpath is null)";
            if (iDataColumn instanceof StructDataColumn) {
                StructDataColumn column = (StructDataColumn)iDataColumn;
                xpathPredicate = "' and sd.xpath = '" + column.getXpath() + "')";
            } else if (iDataColumn instanceof EnumStructDataColumn) {
                xpathPredicate = "' and sd.xpath = '')";
            }
            StringBuffer predicateBuffer = new StringBuffer();
            predicateBuffer.append("(d.id = '");
            predicateBuffer.append(iDataColumn.getDataId());
            predicateBuffer.append(xpathPredicate);
            predicates.add(predicateBuffer.toString());
        }
        if (!predicates.isEmpty()) {
            String string = StringUtils.join(predicates.iterator(), (String)" or ");
            StringBuffer buffer = new StringBuffer(500);
            buffer.append("select distinct d.id, d.oid, m.id, m.oid, sd.xpath, sd.oid from ").append(this.getCurrentPartitionSqlFragment(this.getQualifiedTableName(DATA_TABLE_NAME), "d")).append(" left outer join ").append(this.getQualifiedTableName("structured_data sd")).append(" on(d.oid = sd.data and d.model = sd.model)").append(" where ").append(string).append(" order by d.id, sd.xpath");
            ps = this.connection.prepareStatement(buffer.toString());
            if (log.isDebugEnabled()) {
                log.debug("Executing query: " + buffer.toString());
            }
            rs = SqlUtils.performQuery(ps, buffer.toString());
            while (rs.next()) {
                List valueInfos;
                long modelOid = rs.getLong(4);
                long dataOid = rs.getLong(2);
                long xPathOid = rs.getLong(6);
                String modelId = rs.getString(3);
                String dataId = View.replaceNull(rs.getString(1), "");
                String xpath = rs.getString(5);
                DataInfo dataInfo = new DataInfo();
                dataInfo.setModelId(modelId);
                dataInfo.setDataId(dataId);
                dataInfo.setXPath(xpath);
                dataInfo.setModelOid(modelOid);
                dataInfo.setDataOid(dataOid);
                dataInfo.setXPathOid(xPathOid);
                IDataColumn column = this.findColumnForData(dataInfo, dataColumns);
                if (!dataInfoMap.containsKey(column)) {
                    dataInfoMap.put(column, new ArrayList());
                }
                if (this.containsDataValueInfo(dataInfo, valueInfos = (List)dataInfoMap.get(column))) continue;
                valueInfos.add(dataInfo);
            }
        }
        return dataInfoMap;
    }

    private boolean containsDataValueInfo(DataInfo info, List<DataInfo> valueInfos) {
        for (DataInfo tmp : valueInfos) {
            if (!CompareHelper.areEqual((Object)tmp.getDataId(), (Object)info.getDataId()) || !CompareHelper.areEqual((Object)tmp.getXPathOid(), (Object)info.getXPathOid())) continue;
            return true;
        }
        return false;
    }

    protected DataInfo findDataForColumnAndModel(IDataColumn dataColumn, long modelOid, List<DataInfo> dataValueInfos) {
        if (dataValueInfos != null) {
            for (DataInfo info : dataValueInfos) {
                String dataId = dataColumn.getDataId();
                String xpath = dataColumn.getAttributeName();
                if (info.getModelOid() != modelOid || !CompareHelper.areEqual((Object)dataId, (Object)info.getDataId()) || !CompareHelper.areEqual((Object)xpath, (Object)info.getXPath())) continue;
                return info;
            }
        }
        return null;
    }

    protected IDataColumn findColumnForData(DataInfo info, List<? extends IDataColumn> dataColumns) {
        if (dataColumns != null) {
            for (IDataColumn iDataColumn : dataColumns) {
                String dataId = iDataColumn.getDataId();
                String xpath = iDataColumn.getAttributeName();
                if (!CompareHelper.areEqual((Object)dataId, (Object)info.getDataId()) || !CompareHelper.areEqual((Object)xpath, (Object)info.getXPath())) continue;
                return iDataColumn;
            }
        }
        return null;
    }

    private static String replaceNull(String inputValue, String defaultValue) {
        return inputValue != null ? inputValue : defaultValue;
    }

    public Object[][] evaluateResultSet(List<IModel> allDeployedModels, ResultSet resultSet, Object[] parameterValues) {
        LogUtils.enterInternal(log, "evaluateResultSet()");
        try {
            ArrayList<Object[]> rows = new ArrayList<Object[]>();
            while (resultSet.next()) {
                Object[] row = new Object[this.getLeafFields().size()];
                int n = 0;
                while (n < this.getLeafFields().size()) {
                    Column column = (Column)this.getLeafFields().get(n);
                    if (log.isDebugEnabled()) {
                        log.debug("Column " + column.getName() + " type " + column.getType());
                    }
                    row[n] = column.getType() == Date.class ? new Date(resultSet.getLong(n + 1)) : (column.getType() == Long.class ? new Long(resultSet.getLong(n + 1)) : (column.getType() == Integer.class ? new Integer(resultSet.getInt(n + 1)) : (column.getType() == String.class ? resultSet.getString(n + 1) : (column.getType() == Timestamp.class ? new Timestamp(resultSet.getLong(n + 1)) : resultSet.getObject(n + 1)))));
                    if (log.isDebugEnabled()) {
                        log.debug("Retrieving row " + row[n]);
                    }
                    ++n;
                }
                rows.add(row);
            }
            Object[][] rowSet = this.convertRowsToRowSet(rows);
            LogUtils.exitInternal(log, "evaluateResultSet()");
            return rowSet;
        }
        catch (SQLException e) {
            log.debug(e);
            throw new RuntimeException(e);
        }
    }

    protected Object[][] convertRowsToRowSet(List rows) {
        LogUtils.enterInternal(perf, "convertRowsToRowSet()");
        if (log.isDebugEnabled()) {
            log.debug("Creating row set for row count " + rows.size());
        }
        Object[][] rowSet = new Object[rows.size()][];
        int n = 0;
        while (n < rows.size()) {
            rowSet[n] = (Object[])rows.get(n);
            ++n;
        }
        if (log.isDebugEnabled()) {
            log.debug("Row set populated.");
        }
        LogUtils.exitInternal(perf, "convertRowsToRowSet()");
        return rowSet;
    }

    public String getXMLSpecification() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("<view type='");
        buffer.append(this.getClass().getName());
        buffer.append("' name='");
        buffer.append(this.getName());
        buffer.append("' version='");
        buffer.append(CurrentVersion.getVersion());
        buffer.append("' cumulated='");
        buffer.append(this.isCumulated());
        if (this.isCumulated()) {
            buffer.append("' cumulationIntervalType='");
            buffer.append(this.getIntervalType());
            if (this.getGroupByGroupColumns().size() > 0) {
                buffer.append("' groupByColumns='");
                int n = 0;
                while (n < this.getGroupByGroupColumns().size()) {
                    if (n > 0) {
                        buffer.append(", ");
                    }
                    buffer.append(((GroupColumn)this.getGroupByGroupColumns().get(n)).getName());
                    ++n;
                }
            }
            buffer.append("' ").append(PROVIDE_EMPTY_GROUP_VALUES_ATT_TAG).append("='");
            buffer.append(this.isProvidingEmptyGroupValues());
        }
        buffer.append("' ").append(ADD_TOTAL_ACTIVE_TIME_COLUMN_ATT_TAG).append("='");
        buffer.append(this.isAddingTotalActiveTimeColumn());
        buffer.append("' ").append(USE_EXPRESSION_BUILDER_ATT_TAG).append("='").append(this.isUsingExpressionBuilder());
        buffer.append("'>\n");
        buffer.append(EXPRESSION_TAGS[0]).append("\n").append("<![CDATA[").append(this.getExpression()).append("]]>\n").append(EXPRESSION_TAGS[1]).append("\n");
        ArrayList<GroupColumn> providerColumns = new ArrayList<GroupColumn>();
        for (Object o : this.getColumnProvider()) {
            ColumnProvider provider = (ColumnProvider)o;
            List tmpProviderColumns = provider.getGroupColumns();
            for (Object i : tmpProviderColumns) {
                providerColumns.add((GroupColumn)i);
            }
            buffer.append(provider.getXMLSpecification());
        }
        for (Object o : this.getGroupColumns()) {
            if (providerColumns.contains(o)) continue;
            GroupColumn groupColumn = (GroupColumn)o;
            buffer.append(groupColumn.getXMLSpecification());
        }
        buffer.append("</view>");
        return buffer.toString();
    }

    public String getXMLSpecificationEncoded() {
        LogUtils.enterInternal(log, "getXMLSpecificationEncoded()");
        String specification = this.getXMLSpecification();
        specification = specification.replaceAll("<", "@lt;");
        specification = specification.replaceAll(">", "@gt;");
        LogUtils.exitInternal(log, "getXMLSpecificationEncoded()");
        return specification;
    }

    protected String getWhereExpressionFragment(Object[] parameters, boolean useAnd) {
        StringBuilder expressionFragmentBuilder = new StringBuilder();
        String expressionString = StringUtils.replace((String)this.getExpression(), (String)"\n", (String)" ");
        expressionString = expressionString.replaceAll("(?i:true)", "1");
        expressionString = expressionString.replaceAll("(?i:false)", "0");
        expressionString = ViewUtils.replaceDateWithTimeInMillis(expressionString);
        try {
            ExpressionGrammarParser parser = ExpressionUtil.getParserForExpression(expressionString, true);
            CommonTree tree = (CommonTree)parser.parseExpression().getTree();
            ExpressionUtil.validateExpression(tree, this);
            List<ParsedExpression> columnNames = ExpressionUtil.getColumnNames(tree);
            HashMap<ParsedExpression, GroupColumn> columnNamesReplacementMap = new HashMap<ParsedExpression, GroupColumn>(columnNames.size());
            for (ParsedExpression columnName : columnNames) {
                columnNamesReplacementMap.put(columnName, ViewUtils.findColumnByName(this, columnName.getText()));
            }
            List<ParsedExpression> parameterReferences = ExpressionUtil.getParameterReferences(tree);
            HashMap<ParsedExpression, Parameter> parameterReferenceReplacementMap = new HashMap<ParsedExpression, Parameter>(parameterReferences.size());
            for (ParsedExpression parameterReference : parameterReferences) {
                String parameterName = ExpressionUtil.getParameterName(parameterReference.getText());
                parameterReferenceReplacementMap.put(parameterReference, ViewUtils.findParameterByName(this, parameterName));
            }
            for (Parameter p : parameterReferenceReplacementMap.values()) {
                int index = p.getIndex();
                String parameterValue = (String)parameters[index - 1];
                p.setCurrentValue(parameterValue);
            }
            String replacedExpressionString = ExpressionUtil.replace(this.expression, columnNamesReplacementMap, parameterReferenceReplacementMap);
            if (useAnd) {
                expressionFragmentBuilder.append(" AND");
            }
            expressionFragmentBuilder.append("(");
            expressionFragmentBuilder.append(replacedExpressionString);
            expressionFragmentBuilder.append(")");
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return expressionFragmentBuilder.toString();
    }

    protected String getParameterFilters(Object[] parameterValues) {
        return this.getParameterFilters(parameterValues, null, true);
    }

    protected String getParameterFilters(Object[] parameterValues, boolean useAnd) {
        return this.getParameterFilters(parameterValues, new ParametersFilterEvaluator(){

            @Override
            public boolean applyFilter(Parameter parameter) {
                return true;
            }
        }, useAnd);
    }

    protected String getParameterFilters(Object[] parameterValues, ParametersFilterEvaluator nestedEvaluator, boolean useAnd) {
        ExpressionUsageFilterEvaluator evaluator = new ExpressionUsageFilterEvaluator(nestedEvaluator);
        StringBuffer buffer = new StringBuffer("");
        int n = 0;
        while (n < this.getParameters().size()) {
            Object parameterValue;
            Parameter parameter = (Parameter)this.getParameters().get(n);
            if (evaluator.applyFilter(parameter) && (parameterValue = parameterValues[n]) != null && parameter.getColumnID() != null) {
                if (parameter.getType() == String.class) {
                    buffer.append(this.getStringFilter(parameter.getColumnID(), (String)parameterValues[n], useAnd));
                } else if (parameter.getType() == Long.class) {
                    buffer.append(this.getLongFilter(parameter.getColumnID(), (String)parameterValues[n], useAnd));
                } else if (parameter.getType() == Integer.class) {
                    buffer.append(this.getIntegerFilter(parameter.getColumnID(), (String)parameterValues[n], useAnd));
                }
                if (!StringUtils.isEmpty((String)buffer.toString().trim())) {
                    useAnd = true;
                }
            }
            ++n;
        }
        return buffer.toString();
    }

    protected String getStringFilter(String column, String stringParameter) {
        return this.getStringFilter(column, stringParameter, true);
    }

    protected String getStringFilter(String column, String stringParameter, boolean useAnd) {
        if (ViewUtils.isSelectAllWildcard(stringParameter)) {
            return "";
        }
        StringBuffer buffer = new StringBuffer(100).append(" ");
        if (useAnd) {
            buffer.append("and ");
        }
        buffer.append(column);
        if (stringParameter.indexOf("%") < 0) {
            if (stringParameter.indexOf(",") > 0) {
                String[] ids = stringParameter.split(",");
                buffer.append(" in (");
                int n = 0;
                while (n < ids.length) {
                    if (n > 0) {
                        buffer.append(", ");
                    }
                    buffer.append("'").append(ids[n].trim()).append("'");
                    ++n;
                }
                buffer.append(")");
            } else {
                buffer.append(" = '").append(stringParameter).append("'");
            }
        } else {
            buffer.append(" like '").append(stringParameter).append("'");
        }
        return buffer.toString();
    }

    protected String getLongFilter(String column, String stringParameter) {
        return this.getLongFilter(column, stringParameter, true);
    }

    protected String getLongFilter(String column, String stringParameter, boolean useAnd) {
        StringBuffer buffer = new StringBuffer(100);
        if (stringParameter.indexOf("%") < 0) {
            buffer.append(" ");
            if (useAnd) {
                buffer.append("and ");
            }
            buffer.append(column);
            if (stringParameter.indexOf(",") > 0) {
                String[] ids = stringParameter.split(",");
                buffer.append(" in (");
                int n = 0;
                while (n < ids.length) {
                    if (n > 0) {
                        buffer.append(", ");
                    }
                    buffer.append(ids[n]);
                    ++n;
                }
                buffer.append(")");
            } else {
                buffer.append(" = ").append(stringParameter);
            }
        }
        return buffer.toString();
    }

    protected String getIntegerFilter(String column, String stringParameter) {
        return this.getIntegerFilter(column, stringParameter, true);
    }

    protected String getIntegerFilter(String column, String stringParameter, boolean useAnd) {
        StringBuffer buffer = new StringBuffer(100);
        if (stringParameter.indexOf("%") < 0) {
            buffer.append(" ");
            if (useAnd) {
                buffer.append("and ");
            }
            buffer.append(column);
            if (stringParameter.indexOf(",") > 0) {
                String[] ids = stringParameter.split(",");
                buffer.append(" in (");
                int n = 0;
                while (n < ids.length) {
                    if (n > 0) {
                        buffer.append(", ");
                    }
                    buffer.append(ids[n]);
                    ++n;
                }
                buffer.append(")");
            } else {
                buffer.append(" = ").append(stringParameter);
            }
        }
        return buffer.toString();
    }

    public Object[][] executeQuery(List<IModel> allDeployedModels, Connection connection, Object[] parameterValues) throws ProcessDatabaseQueryException {
        this.connection = connection;
        LogUtils.enterInternal(log, "executeQuery(" + connection + ")");
        Statement ps = null;
        ResultSet rs = null;
        try {
            if (this.isCumulated()) {
                this.determineGroupByNecessity(allDeployedModels, connection, parameterValues);
            }
            String internalQueryString = this.getQueryString(allDeployedModels, parameterValues);
            ps = connection.prepareStatement(internalQueryString);
            if (log.isDebugEnabled()) {
                log.debug("Executing query: " + internalQueryString);
            }
            rs = SqlUtils.performQuery((PreparedStatement)ps, internalQueryString);
            Object[][] objectArray = this.evaluateResultSet(allDeployedModels, rs, parameterValues);
            return objectArray;
        }
        catch (Exception e) {
            log.error(e.getMessage(), e);
            throw new ProcessDatabaseQueryException(e);
        }
        finally {
            if (rs != null) {
                try {
                    rs.close();
                }
                catch (SQLException e) {
                    log.error(e);
                }
            }
            if (ps != null) {
                try {
                    ps.close();
                }
                catch (SQLException e) {
                    log.error(e);
                }
            }
            LogUtils.exitInternal(log, "executeQuery(" + connection + ")");
        }
    }

    public Object[][] postProcessResults(Object[][] results, Connection connection, Object[] parameterValues) {
        return results;
    }

    protected boolean filterID(String filterString, String elementID) {
        if (ViewUtils.isSelectAllWildcard(filterString)) {
            return true;
        }
        if (filterString.indexOf(",") > 0) {
            String[] filters = filterString.split(",");
            int n = 0;
            while (n < filters.length) {
                if (filters[n].trim().equals(elementID)) {
                    return true;
                }
                ++n;
            }
            return false;
        }
        return filterString.equals(elementID);
    }

    protected static IModel findModelByOID(List<IModel> deployedModels, long oid) {
        for (IModel model : deployedModels) {
            if ((long)model.getModelOID() != oid) continue;
            return model;
        }
        return null;
    }

    public List getColumnProvider() {
        return Collections.unmodifiableList(this.columnProviderList);
    }

    public List getOptionalColumnProvider() {
        return Collections.unmodifiableList(this.optionalColumnProviderList);
    }

    public boolean canAddTotalActiveTimeColumn() {
        return false;
    }

    public boolean isAddingTotalActiveTimeColumn() {
        return false;
    }

    public void setAddingTotalActiveTimeColumn(boolean addTotalActiveTimeColumn) {
    }

    public boolean canUseExpressionBuilder() {
        return false;
    }

    public void setUseExpressionBuilder(boolean useExpressionBuilder) {
        this.useExpressionBuilder = useExpressionBuilder;
    }

    public boolean isUsingExpressionBuilder() {
        if (this.canUseExpressionBuilder()) {
            return this.useExpressionBuilder;
        }
        return false;
    }

    public String getExpression() {
        return this.expression != null ? this.expression : "";
    }

    public void setExpression(String expression) {
        this.expression = expression;
    }

    public String getDefaultSchemaName() {
        return this.defaultSchemaName;
    }

    public void setDefaultSchemaName(String defaultSchemaName) {
        this.defaultSchemaName = defaultSchemaName;
    }

    public PartitionInfo getPartitionInfo() {
        return this.partitionInfo;
    }

    public void setPartitionInfo(PartitionInfo partitionInfo) {
        this.partitionInfo = partitionInfo;
    }

    public TableQualifier getTableQualifier() {
        final View thisView = this;
        return new TableQualifier(){

            @Override
            public String getQualifiedTableName(String tableName) {
                return thisView.getQualifiedTableName(tableName);
            }
        };
    }

    protected String getCurrentPartitionSqlFragment(DbTable table) {
        PartitionInfo partitionInfo = this.getPartitionInfo();
        String schemaName = this.getDefaultSchemaName();
        return DbUtils.getPartitionSqlFragment(schemaName, partitionInfo, table);
    }

    protected String getCurrentPartitionSqlFragment(String tableName, String tableAlias) {
        return this.getCurrentPartitionSqlFragment(tableName, tableAlias, "model");
    }

    protected String getCurrentPartitionSqlFragment(String tableName, String tableAlias, String modelColumnName) {
        return DbUtils.getPartitionSqlFragment(this.getPartitionInfo(), this.getDefaultSchemaName(), tableName, tableAlias, modelColumnName);
    }

    public boolean isGroupingHandlingNecessary() {
        return this.isGroupingHandlingNecessary;
    }

    public String getQualifiedTableName(String tableName) {
        return DbUtils.getQualifiedTableName(this.getDefaultSchemaName(), tableName);
    }

    public DataColumnAliasRegistry getAliasRegistry() {
        return this.aliasRegistry;
    }

    protected String qualifiedField(String tableAlias, String fieldName) {
        StringBuffer buffer = new StringBuffer(50);
        if (!StringUtils.isEmpty((String)tableAlias)) {
            buffer.append(tableAlias).append('.');
        }
        return buffer.append(fieldName).toString();
    }

    protected String piField(String fieldName) {
        return this.qualifiedField("pi", fieldName);
    }

    protected String aiField(String fieldName) {
        return this.qualifiedField("ai", fieldName);
    }

    protected String pihField(String fieldName) {
        return this.qualifiedField(PIH_ALIAS, fieldName);
    }

    protected String aihField(String fieldName) {
        return this.qualifiedField(AIH_ALIAS, fieldName);
    }

    protected String sdField(String fieldName) {
        return this.qualifiedField("sd", fieldName);
    }

    protected String sdvField(String fieldName) {
        return this.qualifiedField("sdv", fieldName);
    }

    protected Iterator getCumulationKeyIterator() {
        return this.isGroupingHandlingNecessary() ? new CumulationKeyGenerator(this.groupByDomains) : Collections.singleton(AbstractCumulationAspect.NULL_GROUP_VALUE).iterator();
    }

    protected void determineGroupByNecessity(List<IModel> allDeployedModels, Connection connection, Object[] parameterValues) throws SQLException {
        List dataColumns = Collections.EMPTY_LIST;
        Map<IDataColumn, List<DataInfo>> dataInfoMap = this.getDataInfos(dataColumns);
        Map<IDataColumn, List<DataJoinInfo>> joinInfoMap = SqlUtils.getJoinInfo(allDeployedModels, dataColumns, dataInfoMap);
        this.dataMapper = new Data2ClusterMapper(this, dataColumns, parameterValues, false, joinInfoMap);
        PreparedStatement ps = null;
        ResultSet rs = null;
        List[] valuesLists = new List[this.getGroupByGroupColumns().size()];
        String parameterFilter = null;
        String distinct = this.isProvidingEmptyGroupValues() ? "distinct " : "";
        int n = 0;
        while (n < this.getGroupByGroupColumns().size()) {
            StringBuffer buffer;
            GroupColumn groupByColumn = (GroupColumn)this.getGroupByGroupColumns().get(n);
            valuesLists[n] = new ArrayList();
            if (groupByColumn instanceof DataColumn) {
                DataColumn dataGroupByColumn = (DataColumn)groupByColumn;
                buffer = new StringBuffer();
                String dataAlias = dataGroupByColumn.getAlias();
                boolean useAnd = true;
                buffer.append("select ").append(distinct);
                if (this.dataMapper != null && this.dataMapper.foundClusterConfig() && this.dataMapper.getClusterInfo(dataGroupByColumn) != null) {
                    ClusterInfo clusterInfo = this.dataMapper.getClusterInfo(dataGroupByColumn);
                    String selectFragment = this.dataMapper.getSelectFragment(dataGroupByColumn);
                    selectFragment = StringUtils.replace((String)selectFragment, (String)clusterInfo.getAlias(), (String)dataAlias);
                    buffer.append(selectFragment).append(" from ").append(this.getCurrentPartitionSqlFragment(this.getQualifiedTableName("process_definition"), "p")).append(" inner join ").append(this.getQualifiedTableName("process_instance")).append(' ').append("pi").append(" on(pi.").append("PROCESSDEFINITION = p.oid and ").append("pi").append(".model = p.model)").append(" inner join ").append(this.getQualifiedTableName(clusterInfo.getCluster().getTableName())).append(" ").append(dataAlias).append(" on(").append(dataAlias).append(".").append(clusterInfo.getCluster().getProcessInstanceColumn()).append(" = pi.oid)").append(" where ");
                    parameterFilter = this.dataMapper.getDataValueFilter(dataGroupByColumn);
                    if (StringUtils.isEmpty((String)parameterFilter)) {
                        StringBuffer paramBuffer = new StringBuffer();
                        paramBuffer.append(this.dataMapper.getAliasedColumn(dataGroupByColumn)).append(" ").append(Operator.IS_NOT_NULL);
                        parameterFilter = paramBuffer.toString();
                    }
                    parameterFilter = StringUtils.replace((String)parameterFilter, (String)clusterInfo.getAlias().toLowerCase(), (String)dataAlias);
                    useAnd = false;
                } else {
                    String dataId = dataGroupByColumn.getDataId();
                    buffer.append(dataAlias).append(".type_key, ").append(dataAlias).append(".string_value, ").append(dataAlias).append(".number_value ").append(" from ").append(this.getCurrentPartitionSqlFragment(this.getQualifiedTableName(DATA_TABLE_NAME), "d")).append(" inner join ").append(this.getQualifiedTableName(DV_TABLE_NAME)).append(' ').append(dataAlias).append(" on(").append(dataAlias).append(".data = d.oid and ").append(dataAlias).append(".model = d.model)").append(" where d.id = '").append(dataId).append("'");
                    parameterFilter = dataGroupByColumn.getDataValueFilter(parameterValues);
                }
                if (!StringUtils.isEmpty((String)parameterFilter)) {
                    if (useAnd) {
                        buffer.append(" and ");
                    }
                    buffer.append(parameterFilter);
                }
                ps = connection.prepareStatement(buffer.toString());
                if (log.isDebugEnabled()) {
                    log.debug("Executing query: " + buffer);
                }
                if (this.flagReturnAndInitializeValuesList(rs = SqlUtils.performQuery(ps, buffer.toString()), valuesLists[n], new ResultSetValueExtractor(){

                    @Override
                    public Object getCurrentValue(ResultSet resultSet) throws SQLException {
                        return DataColumn.determineObjectValue(resultSet.getInt(1), resultSet.getString(2), resultSet.getLong(3));
                    }
                })) {
                    return;
                }
                if (!valuesLists[n].contains(null)) {
                    valuesLists[n].add(null);
                }
            } else if (groupByColumn instanceof ForeignDataColumn) {
                ForeignDataColumn foreignDataGroupByColumn = (ForeignDataColumn)groupByColumn;
                ForeignDataDescriptor foreignDataDescriptor = (ForeignDataDescriptor)foreignDataGroupByColumn.getColumnProvider();
                StringBuffer buffer2 = new StringBuffer();
                buffer2.append("select ").append(distinct);
                buffer2.append(foreignDataDescriptor.getName());
                buffer2.append(".");
                buffer2.append(foreignDataGroupByColumn.getForeignColumnName());
                buffer2.append(" from ");
                buffer2.append(foreignDataDescriptor.getQualifiedTableName());
                buffer2.append(" ");
                buffer2.append(foreignDataDescriptor.getName());
                parameterFilter = foreignDataGroupByColumn.getDataValueFilter(parameterValues);
                if (!StringUtils.isEmpty((String)parameterFilter)) {
                    buffer2.append(" where ");
                    buffer2.append(parameterFilter);
                }
                ps = connection.prepareStatement(buffer2.toString());
                if (log.isDebugEnabled()) {
                    log.debug("Executing query: " + buffer2);
                }
                if (this.flagReturnAndInitializeValuesList(rs = SqlUtils.performQuery(ps, buffer2.toString()), valuesLists[n], new ResultSetValueExtractor(){

                    @Override
                    public Object getCurrentValue(ResultSet resultSet) throws SQLException {
                        return resultSet.getObject(1);
                    }
                })) {
                    return;
                }
                if (!valuesLists[n].contains(null)) {
                    valuesLists[n].add(null);
                }
            } else if (groupByColumn instanceof GroupColumn && groupByColumn.isPredefined()) {
                DbColumnRef dbColumn = groupByColumn.getDbColumnRef();
                if (dbColumn != null) {
                    Class type;
                    buffer = new StringBuffer();
                    buffer.append("select ").append(distinct).append(" tab.").append(dbColumn.getColumnName()).append(" from ").append(this.getCurrentPartitionSqlFragment(this.getQualifiedTableName(dbColumn.getTableName()), "tab"));
                    ps = connection.prepareStatement(buffer.toString());
                    if (log.isDebugEnabled()) {
                        log.debug("Executing query: " + buffer);
                    }
                    if (this.flagReturnAndInitializeValuesList(rs = SqlUtils.performQuery(ps, buffer.toString()), valuesLists[n], new ResultSetValueExtractor(type = groupByColumn.getType()){
                        private final /* synthetic */ Class val$type;
                        {
                            this.val$type = clazz;
                        }

                        @Override
                        public Object getCurrentValue(ResultSet resultSet) throws SQLException {
                            if (Double.class.isAssignableFrom(this.val$type)) {
                                return new Double(resultSet.getDouble(1));
                            }
                            if (Integer.class.isAssignableFrom(this.val$type)) {
                                return new Integer(resultSet.getInt(1));
                            }
                            if (Long.class.isAssignableFrom(this.val$type)) {
                                return new Long(resultSet.getLong(1));
                            }
                            if (String.class.isAssignableFrom(this.val$type)) {
                                return resultSet.getString(1);
                            }
                            throw new UnsupportedOperationException(NLS.bind((String)ReportingCommon_Messages.TypeNotSupportedAsGroupColumn, (Object)this.val$type));
                        }
                    })) {
                        return;
                    }
                } else {
                    throw new UnsupportedOperationException(NLS.bind((String)ReportingCommon_Messages.ColumnNotSupportedAsGroupColumn, (Object)groupByColumn.getName()));
                }
            }
            ++n;
        }
        this.groupByDomains = valuesLists;
    }

    protected GroupColumn createPredefinedColumn(String name, String label, Class type, boolean cumulatable) {
        return this.createPredefinedColumn(name, label, type, cumulatable, null);
    }

    protected GroupColumn createPredefinedColumn(String name, String label, Class type, boolean cumulatable, DbColumnRef dbColumn) {
        GroupColumn groupColumn = new GroupColumn(this, name, label, type, true, cumulatable);
        groupColumn.setDbColumnRef(dbColumn);
        return groupColumn;
    }

    /*
     * Unable to fully structure code
     */
    private boolean flagReturnAndInitializeValuesList(ResultSet resultSet, List valuesList, ResultSetValueExtractor extractor) throws SQLException {
        block5: {
            flagReturn = false;
            if (this.isProvidingEmptyGroupValues()) ** GOTO lbl9
            if (!resultSet.next()) break block5;
            this.isGroupingHandlingNecessary = true;
            flagReturn = true;
            break block5;
lbl-1000:
            // 1 sources

            {
                valuesList.add(extractor.getCurrentValue(resultSet));
lbl9:
                // 2 sources

                ** while (resultSet.next())
            }
lbl10:
            // 1 sources

            if (!valuesList.isEmpty()) {
                this.isGroupingHandlingNecessary = true;
            }
        }
        return flagReturn;
    }

    private static class ClassNameComparator
    implements Comparator<Class<? extends View>> {
        private ClassNameComparator() {
        }

        @Override
        public int compare(Class<? extends View> o1, Class<? extends View> o2) {
            return o1.getName().compareTo(o2.getName());
        }
    }

    private class ExpressionUsageFilterEvaluator
    implements ParametersFilterEvaluator {
        private ParametersFilterEvaluator nestedFilter;
        private Set identifiers = Collections.EMPTY_SET;

        public ExpressionUsageFilterEvaluator(ParametersFilterEvaluator nestedFilter) {
            this.nestedFilter = nestedFilter;
            View.this.isUsingExpressionBuilder();
        }

        @Override
        public boolean applyFilter(Parameter parameter) {
            boolean passedNestedFilter = true;
            if (this.nestedFilter != null) {
                passedNestedFilter = this.nestedFilter.applyFilter(parameter);
            }
            boolean passedFilter = false;
            if (!(!passedNestedFilter || View.this.isUsingExpressionBuilder() && this.identifiers.contains(parameter.getName()))) {
                passedFilter = true;
            }
            return passedFilter;
        }
    }

    private final class IntegerComparator
    implements Comparator {
        private IntegerComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (this.validInteger(o1) && this.validInteger(o2)) {
                int number2;
                int number1 = (Integer)o1;
                if (number1 < (number2 = ((Integer)o2).intValue())) {
                    return 1;
                }
                if (number1 > number2) {
                    return -1;
                }
                return 0;
            }
            throw new RuntimeException(ReportingCommon_Messages.ExceptionComparedObjectsHaveToBeInstancesOfNumber);
        }

        private boolean validInteger(Object value) {
            return value != null && value instanceof Integer;
        }
    }

    protected static interface ParametersFilterEvaluator {
        public boolean applyFilter(Parameter var1);
    }

    protected static class ReportingTimestampRange {
        private Calendar start;
        private Calendar end;

        public ReportingTimestampRange() {
            Calendar tmp = Calendar.getInstance();
            tmp.set(2, 0);
            tmp.set(5, 1);
            tmp.set(11, 0);
            tmp.set(12, 0);
            tmp.set(13, 0);
            tmp.set(14, 0);
            this.start = tmp;
            tmp = Calendar.getInstance();
            tmp.set(13, 0);
            tmp.set(14, 0);
            tmp.add(12, 1);
            this.end = tmp;
        }

        private long getStartTimestamp() {
            return this.start.getTimeInMillis();
        }

        private long getEndTimestamp() {
            return this.end.getTimeInMillis();
        }

        public Timestamp getSqlStartTimestamp() {
            return new Timestamp(this.getStartTimestamp());
        }

        public Timestamp getSqlEndTimestamp() {
            return new Timestamp(this.getEndTimestamp());
        }
    }

    private static interface ResultSetValueExtractor {
        public Object getCurrentValue(ResultSet var1) throws SQLException;
    }

    public static interface TableQualifier {
        public String getQualifiedTableName(String var1);
    }
}

