/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.stardust.engine.api.model.IModel;
import org.eclipse.stardust.reporting.common.DbAwareGroupColumn;
import org.eclipse.stardust.reporting.common.Parameter;
import org.eclipse.stardust.reporting.common.ProcessDatabaseQueryException;
import org.eclipse.stardust.reporting.common.ReportingCommon_Messages;
import org.eclipse.stardust.reporting.common.View;
import org.eclipse.stardust.reporting.common.metadata.columns.DbColumn;
import org.eclipse.stardust.reporting.common.metadata.columns.DbTable;
import org.eclipse.stardust.reporting.common.utils.sql.DbUtils;

public class WorkflowUserView
extends View {
    public static final String WU_VIEW_REPORT_TYPE = "WorkflowUserView";
    private static final String WORKFLOW_USER_TABLE_ALIAS = "wu";
    private List<DbAwareGroupColumn> reportColumns;
    private DbAwareGroupColumn oidColumn;
    private DbAwareGroupColumn accountColumn;
    private DbAwareGroupColumn firstNameColumn;
    private DbAwareGroupColumn lastNameColumn;
    private DbAwareGroupColumn descriptionColumn;

    public WorkflowUserView() {
        super(WU_VIEW_REPORT_TYPE);
        this.addParameter("ModelID", String.class, false, Parameter.STRING_DEFAULT_VALUE, null);
        this.addParameter("ModelOID", String.class, false, Parameter.STRING_DEFAULT_VALUE, null);
    }

    @Override
    protected void createDefaultFields() {
        this.reportColumns = new ArrayList<DbAwareGroupColumn>();
        this.oidColumn = new DbAwareGroupColumn(this, "Oid", ReportingCommon_Messages.Oid, String.class);
        this.accountColumn = new DbAwareGroupColumn(this, "Account", ReportingCommon_Messages.Account, String.class);
        this.firstNameColumn = new DbAwareGroupColumn(this, "FirstName", ReportingCommon_Messages.FirstName, String.class);
        this.lastNameColumn = new DbAwareGroupColumn(this, "LastName", ReportingCommon_Messages.LastName, String.class);
        this.descriptionColumn = new DbAwareGroupColumn(this, "Description", ReportingCommon_Messages.DescriptionAttribute, String.class);
        this.reportColumns.add(this.oidColumn);
        this.reportColumns.add(this.accountColumn);
        this.reportColumns.add(this.firstNameColumn);
        this.reportColumns.add(this.lastNameColumn);
        this.reportColumns.add(this.descriptionColumn);
        this.addGroupColumns(this.reportColumns);
    }

    @Override
    public String getQueryString(List<IModel> allDeployedModels, Object[] parameters) throws ProcessDatabaseQueryException {
        DbTable workflowUserTable = new DbTable(this.getDefaultSchemaName(), "workflowuser", WORKFLOW_USER_TABLE_ALIAS);
        DbColumn workflowUserTableOidColumn = workflowUserTable.getColumn("oid");
        DbColumn workflowUserTableAccountColumn = workflowUserTable.getColumn("account");
        DbColumn workflowUserTableFirstNameColumn = workflowUserTable.getColumn("firstName");
        DbColumn workflowUserTableLastNameColumn = workflowUserTable.getColumn("lastName");
        DbColumn workflowUserTableDescriptionColumn = workflowUserTable.getColumn("description");
        ArrayList<DbColumn> selectedDbColumns = new ArrayList<DbColumn>();
        selectedDbColumns.add(workflowUserTableOidColumn);
        selectedDbColumns.add(workflowUserTableAccountColumn);
        selectedDbColumns.add(workflowUserTableFirstNameColumn);
        selectedDbColumns.add(workflowUserTableLastNameColumn);
        selectedDbColumns.add(workflowUserTableDescriptionColumn);
        DbUtils.indexColumns(selectedDbColumns);
        this.oidColumn.setDbColumn(workflowUserTableOidColumn);
        this.accountColumn.setDbColumn(workflowUserTableAccountColumn);
        this.firstNameColumn.setDbColumn(workflowUserTableFirstNameColumn);
        this.lastNameColumn.setDbColumn(workflowUserTableLastNameColumn);
        this.descriptionColumn.setDbColumn(workflowUserTableDescriptionColumn);
        StringBuffer buffer = new StringBuffer();
        String selectedColumns = DbUtils.getColumnList(selectedDbColumns);
        buffer.append("select ");
        buffer.append(selectedColumns);
        buffer.append(" from ").append(workflowUserTable);
        return buffer.toString();
    }

    @Override
    public String getWhereString(Object[] parameters) {
        StringBuffer buffer = new StringBuffer(500);
        return buffer.toString();
    }

    @Override
    public String getReportType() {
        return WU_VIEW_REPORT_TYPE;
    }
}

