/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common.beans;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.HashMap;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.config.Parameters;
import org.eclipse.stardust.common.config.ParametersFacade;
import org.eclipse.stardust.common.config.PropertyLayer;
import org.eclipse.stardust.common.error.ConcurrencyException;
import org.eclipse.stardust.common.error.PublicException;
import org.eclipse.stardust.engine.core.persistence.PersistenceController;
import org.eclipse.stardust.engine.core.persistence.Session;
import org.eclipse.stardust.engine.core.runtime.beans.BpmRuntimeEnvironment;
import org.eclipse.stardust.engine.core.runtime.beans.IAuditTrailPartition;
import org.eclipse.stardust.engine.core.runtime.beans.IUser;
import org.eclipse.stardust.engine.core.runtime.beans.IUserRealm;
import org.eclipse.stardust.engine.core.runtime.beans.ModelManagerFactory;
import org.eclipse.stardust.engine.core.runtime.beans.ModelManagerLoader;
import org.eclipse.stardust.engine.core.runtime.beans.NullWatcher;
import org.eclipse.stardust.engine.core.runtime.beans.SynchronizationService;
import org.eclipse.stardust.engine.core.runtime.beans.UserBean;
import org.eclipse.stardust.engine.core.runtime.beans.UserRealmBean;
import org.eclipse.stardust.engine.core.runtime.beans.UserSessionBean;
import org.eclipse.stardust.engine.core.runtime.beans.interceptors.PropertyLayerProviderInterceptor;
import org.eclipse.stardust.engine.core.runtime.beans.removethis.ItemDescription;
import org.eclipse.stardust.engine.core.runtime.beans.removethis.ItemLoader;
import org.eclipse.stardust.engine.core.runtime.beans.removethis.ItemLocatorUtils;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;
import org.eclipse.stardust.reporting.common.PartitionInfo;
import org.eclipse.stardust.reporting.common.ReportingCommon_Messages;
import org.eclipse.stardust.reporting.common.ReportingSession;
import org.eclipse.stardust.reporting.common.beans.cache.EngineCacheManager;
import org.eclipse.stardust.reporting.common.utils.ViewUtils;
import org.eclipse.stardust.reporting.common.utils.sql.DbUtils;

public class EngineContext {
    private final Connection connection;
    private final PartitionInfo partitionInfo;
    private final String databaseDefaultSchema;
    private static final Logger log = LogUtils.getLogger(EngineContext.class);

    public EngineContext(Connection connection, PartitionInfo partitionInfo, String databaseDefaultSchema) {
        this.connection = connection;
        this.partitionInfo = partitionInfo;
        this.databaseDefaultSchema = databaseDefaultSchema;
    }

    public void startupEngine() {
        Parameters parameters = Parameters.instance();
        HashMap<String, Object> props = new HashMap<String, Object>();
        props.put("ag.carnot.db.jdbc.dbdescriptor.AuditTrail", DbUtils.getDbDescriptor(this.connection));
        props.put("AuditTrail.AssertReadCommitted", Boolean.FALSE);
        props.put(SynchronizationService.PRP_DISABLE_SYNCHRONIZATION, true);
        PropertyLayer propertyLayer = ParametersFacade.pushLayer(props);
        ReportingSession session = new ReportingSession(this.databaseDefaultSchema, this.connection);
        propertyLayer.setProperty("AuditTrail.Session", (Object)session);
        propertyLayer.setProperty("Current.Partition", (Object)new IAuditTrailPartition(){

            public short getOID() {
                return (short)EngineContext.this.partitionInfo.getPartitionOid();
            }

            public String getId() {
                return EngineContext.this.partitionInfo.getPartitionId();
            }

            public void setPersistenceController(PersistenceController PersistenceController2) {
                throw new UnsupportedOperationException();
            }

            public void markModified(String fieldName) {
                throw new UnsupportedOperationException();
            }

            public void markModified() {
                throw new UnsupportedOperationException();
            }

            public void markCreated() {
                throw new UnsupportedOperationException();
            }

            public PersistenceController getPersistenceController() {
                throw new UnsupportedOperationException();
            }

            public void fetch() {
                throw new UnsupportedOperationException();
            }

            public void disconnectPersistenceController() {
                throw new UnsupportedOperationException();
            }

            public void delete(boolean writeThrough) {
                throw new UnsupportedOperationException();
            }

            public void delete() {
                throw new UnsupportedOperationException();
            }

            public void setOID(short oid) {
                throw new UnsupportedOperationException();
            }

            public void setId(String id) {
                throw new UnsupportedOperationException();
            }

            public void setDescription(String description) {
                throw new UnsupportedOperationException();
            }

            public void lock() throws ConcurrencyException {
                throw new UnsupportedOperationException();
            }

            public String getDescription() {
                throw new UnsupportedOperationException();
            }
        });
        BpmRuntimeEnvironment currentEnv = PropertyLayerProviderInterceptor.getCurrent();
        BpmRuntimeEnvironment newEnv = new BpmRuntimeEnvironment((PropertyLayer)currentEnv);
        PropertyLayerProviderInterceptor.setCurrent((BpmRuntimeEnvironment)newEnv);
        newEnv.setAuditTrailSession((Session)session);
        if (!ModelManagerFactory.isAvailable()) {
            Parameters params = Parameters.instance();
            ItemLocatorUtils.registerDescription((String)"model.manager", (ItemDescription)new ItemDescription((ItemLoader)new ModelManagerLoader(), params.getString("Model.Watcher", NullWatcher.class.getName())));
        }
        if (ViewUtils.isAuthentificationRequired()) {
            IUser user = null;
            String workflowUserSessionId = ViewUtils.getWorkflowUserSessionId();
            if (!StringUtils.isEmpty((String)workflowUserSessionId)) {
                user = this.getUserFromWorkflowSession(workflowUserSessionId);
            } else {
                String userId = parameters.getString("user");
                String realmId = parameters.getString("Security.Realm");
                user = this.getUserFromCredentials(userId, realmId);
            }
            if (user == null) {
                this.throwNotAuthentificatedException();
            }
            propertyLayer.setProperty("Current.User", (Object)user);
        }
        EngineCacheManager ecm = EngineCacheManager.getInstance();
        ecm.updateCachesIfNecessary(this.connection, this.partitionInfo, this.databaseDefaultSchema);
    }

    public void shutdownEngine() {
        ParametersFacade.popLayer();
        BpmRuntimeEnvironment currentEnv = PropertyLayerProviderInterceptor.getCurrent();
        PropertyLayerProviderInterceptor.setCurrent((BpmRuntimeEnvironment)((BpmRuntimeEnvironment)currentEnv.getPredecessor()));
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
            }
        }
        catch (SQLException e) {
            log.error(e);
        }
    }

    private void throwNotAuthentificatedException() {
        throw new PublicException(ReportingCommon_Messages.AuthentificationRequired);
    }

    private IUser getUserFromCredentials(String userId, String realmId) {
        try {
            UserRealmBean realm = UserRealmBean.findById((String)realmId, (short)((short)this.partitionInfo.getPartitionOid()));
            return UserBean.findByAccount((String)userId, (IUserRealm)realm);
        }
        catch (Exception exception) {
            return null;
        }
    }

    private IUser getUserFromWorkflowSession(String workflowUserSessionId) {
        long sessionOid = -1L;
        try {
            sessionOid = Long.decode("0x" + workflowUserSessionId);
            UserSessionBean sessionBean = UserSessionBean.findByOid((long)sessionOid);
            return sessionBean.getUser();
        }
        catch (Exception exception) {
            return null;
        }
    }
}

