/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common.beans;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.ejb.CreateException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.error.PublicException;
import org.eclipse.stardust.engine.api.model.IModel;
import org.eclipse.stardust.engine.core.model.beans.DefaultConfigurationVariablesProvider;
import org.eclipse.stardust.engine.core.model.beans.DefaultXMLReader;
import org.eclipse.stardust.engine.core.model.beans.IConfigurationVariablesProvider;
import org.eclipse.stardust.engine.core.model.xpdl.XpdlUtils;
import org.eclipse.stardust.reporting.common.Column;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;
import org.eclipse.stardust.reporting.common.ProcessDatabaseQueryException;
import org.eclipse.stardust.reporting.common.ProcessDatabaseQueryService;
import org.eclipse.stardust.reporting.common.ProcessModelQueryService;
import org.eclipse.stardust.reporting.common.QueryServiceFactory;
import org.eclipse.stardust.reporting.common.ReportingCommon_Messages;
import org.eclipse.stardust.reporting.common.ResultSetMetaData;
import org.eclipse.stardust.reporting.common.View;
import org.eclipse.stardust.reporting.common.beans.EngineContext;
import org.eclipse.stardust.reporting.common.i18n.LocalizationUtils;
import org.eclipse.stardust.reporting.common.utils.Tokenizer;
import org.eclipse.stardust.reporting.common.utils.ViewUtils;

public class ProcessModelQueryServiceEJB
implements ProcessModelQueryService {
    public static final int DEFAULT_MAX_ROWS = 1000;
    private static final String NAME_LITERAL = "NAME";
    private static final String TYPE_LITERAL = "TYPE";
    private static final Logger log = LogUtils.getLogger(ProcessModelQueryServiceEJB.class);
    private ProcessDatabaseQueryService dbQueryService;
    private IModel modelFromFile = null;
    private static Map<String, String> columnNameLocalizationMap = new HashMap<String, String>();

    static {
        columnNameLocalizationMap.put("OID", ReportingCommon_Messages.OIDColumn);
        columnNameLocalizationMap.put("ID", ReportingCommon_Messages.IDColumn);
        columnNameLocalizationMap.put("Description", ReportingCommon_Messages.DescriptionColumn);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ProcessModelQueryServiceEJB(String modelFilePath) {
        log.debug("Opening model file: " + modelFilePath);
        if (!StringUtils.isEmpty((String)modelFilePath) && modelFilePath.startsWith("java:")) {
            String jndiName = null;
            String databasePartitionId = null;
            String databaseDefaultSchema = null;
            String schemaPatterns = null;
            String worktimeCalculatorClassName = null;
            Tokenizer tokenizer = new Tokenizer(modelFilePath, "\\|");
            jndiName = tokenizer.getToken(0);
            databaseDefaultSchema = tokenizer.getToken(1);
            schemaPatterns = tokenizer.getToken(2);
            worktimeCalculatorClassName = tokenizer.getToken(3);
            databasePartitionId = tokenizer.getToken(4);
            try {
                this.dbQueryService = QueryServiceFactory.getInstance().createProcessDatabaseQueryService(jndiName, null, null, null, null, databasePartitionId, databaseDefaultSchema, schemaPatterns, worktimeCalculatorClassName);
            }
            catch (CreateException e) {
                e.printStackTrace();
            }
        } else {
            try {
                File modelFile = new File(modelFilePath);
                if (!modelFile.exists()) {
                    throw new FileNotFoundException(modelFilePath);
                }
                Class<ProcessModelQueryServiceEJB> clazz = ProcessModelQueryServiceEJB.class;
                synchronized (ProcessModelQueryServiceEJB.class) {
                    this.modelFromFile = this.loadModel(modelFile);
                    // ** MonitorExit[var3_6] (shouldn't be in output)
                }
            }
            catch (FileNotFoundException e) {
                log.error(e);
                throw new RuntimeException(e.getLocalizedMessage());
            }
        }
        {
            log.info("Model initialized.");
            return;
        }
    }

    @Override
    public List<IModel> getActiveModels() {
        List<IModel> activeModels = new ArrayList<IModel>();
        if (this.dbQueryService != null) {
            activeModels = this.dbQueryService.getActiveModels();
        }
        return activeModels;
    }

    @Override
    public IModel getModel(Object[] parameterValues) {
        IModel found = null;
        if (this.dbQueryService != null) {
            String modelOidParam = (String)parameterValues[1];
            String modelIdParam = (String)parameterValues[0];
            long oid = ViewUtils.determineModelOid(modelOidParam, modelIdParam);
            found = this.dbQueryService.getModelByOid(oid);
            if (found == null) {
                String errorMessage = ReportingCommon_Messages.ModelNotFound;
                throw new PublicException(NLS.bind((String)errorMessage, (Object)modelIdParam, (Object)modelOidParam));
            }
        } else {
            found = this.modelFromFile;
        }
        return found;
    }

    @Override
    public ResultSetMetaData getMetaData(View view) throws ProcessDatabaseQueryException {
        if (log.isDebugEnabled()) {
            log.debug("=> getMetaData(" + view + ")");
        }
        ResultSetMetaData resultSetMetaData = this.prepareMetaData(view);
        return resultSetMetaData;
    }

    private String[] discoverActualColumnMetaData(View view, String metaDataType) throws ProcessDatabaseQueryException {
        String[] metaData = new String[view.getLeafFields().size()];
        int n = 0;
        while (n < view.getLeafFields().size()) {
            Column column = (Column)view.getLeafFields().get(n);
            if (metaDataType.equalsIgnoreCase(NAME_LITERAL)) {
                metaData[n] = column.getFullName();
            } else if (metaDataType.equalsIgnoreCase(TYPE_LITERAL)) {
                metaData[n] = column.getType().getName();
            }
            ++n;
        }
        return metaData;
    }

    private ResultSetMetaData prepareMetaData(View view) throws ProcessDatabaseQueryException {
        String[] allColumnNames = this.discoverActualColumnMetaData(view, NAME_LITERAL);
        String[] allColumnTypes = this.discoverActualColumnMetaData(view, TYPE_LITERAL);
        String[] queryColumnNames = null;
        String[] queryColumnTypes = null;
        queryColumnNames = allColumnNames;
        queryColumnTypes = allColumnTypes;
        return new ResultSetMetaData(view.getName(), queryColumnNames, queryColumnTypes, this.getColumnLabels(view));
    }

    private String[] getColumnLabels(View view) {
        String[] labels = new String[view.getLeafFields().size()];
        int n = 0;
        while (n < view.getLeafFields().size()) {
            String columnLabel;
            Column column = (Column)view.getLeafFields().get(n);
            labels[n] = columnLabel = LocalizationUtils.getLabel(columnNameLocalizationMap, column.getName());
            ++n;
        }
        return labels;
    }

    private IModel loadModel(File modelFile) throws FileNotFoundException {
        IModel model = null;
        DefaultConfigurationVariablesProvider confVarProvider = new DefaultConfigurationVariablesProvider();
        model = modelFile.getName().endsWith("xpdl") ? XpdlUtils.loadXpdlModel((File)modelFile, (IConfigurationVariablesProvider)confVarProvider) : new DefaultXMLReader(true, (IConfigurationVariablesProvider)confVarProvider).importFromXML((InputStream)new FileInputStream(modelFile));
        return model;
    }

    @Override
    public EngineContext getEngineContext() throws ProcessDatabaseQueryException {
        if (this.dbQueryService != null) {
            return this.dbQueryService.getEngineContext();
        }
        return null;
    }
}

