/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common.beans.cache;

import java.io.Serializable;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.stardust.common.Action;
import org.eclipse.stardust.engine.core.persistence.jdbc.DBDescriptor;
import org.eclipse.stardust.engine.core.runtime.beans.ModelManager;
import org.eclipse.stardust.engine.core.runtime.beans.ModelManagerBean;
import org.eclipse.stardust.engine.core.runtime.beans.ModelManagerFactory;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;
import org.eclipse.stardust.reporting.common.PartitionInfo;
import org.eclipse.stardust.reporting.common.beans.IModelInfo;
import org.eclipse.stardust.reporting.common.beans.IModelInfoImpl;
import org.eclipse.stardust.reporting.common.metadata.columns.DbColumn;
import org.eclipse.stardust.reporting.common.metadata.columns.IDbColumn;
import org.eclipse.stardust.reporting.common.utils.SqlUtils;
import org.eclipse.stardust.reporting.common.utils.sql.DbUtils;

public final class EngineCacheManager {
    private static final Logger log = LogUtils.getLogger(EngineCacheManager.class);
    private static Map<Long, IModelInfo> deployedModelsInfo = new HashMap<Long, IModelInfo>();
    private static EngineCacheManager instance = null;

    private EngineCacheManager() {
    }

    public static EngineCacheManager getInstance() {
        if (instance == null) {
            instance = new EngineCacheManager();
        }
        return instance;
    }

    public synchronized void updateCachesIfNecessary(Connection connection, PartitionInfo partitionInfo, String schemaName) {
        Map<Long, IModelInfo> oldDeployedModelsInfo = deployedModelsInfo;
        Map<Long, IModelInfo> newDeployedModelsInfo = this.getDeployedModelsInfo(connection, partitionInfo, schemaName);
        boolean modelsChanged = this.modelsChanged(oldDeployedModelsInfo, newDeployedModelsInfo);
        deployedModelsInfo = newDeployedModelsInfo;
        if (modelsChanged) {
            new FlushModelManagerAction(ModelManagerFactory.getCurrent()).execute();
            ModelManagerFactory.getCurrent().findActiveModel();
        }
    }

    private boolean modelsChanged(Map<Long, IModelInfo> oldModelsInfo, Map<Long, IModelInfo> newModelsInfo) {
        if (oldModelsInfo.size() != newModelsInfo.size()) {
            return true;
        }
        for (long modelKey : oldModelsInfo.keySet()) {
            IModelInfo oldModelInfo = oldModelsInfo.get(modelKey);
            IModelInfo newModelInfo = newModelsInfo.get(modelKey);
            if (newModelInfo != null && oldModelInfo.getDeploymentStamp() == newModelInfo.getDeploymentStamp()) continue;
            return true;
        }
        return false;
    }

    private Map<Long, IModelInfo> getDeployedModelsInfo(Connection connection, PartitionInfo partitionInfo, String schemaName) {
        HashMap<Long, IModelInfo> modelIdMap = new HashMap<Long, IModelInfo>();
        PreparedStatement ps = null;
        ResultSet rs = null;
        try {
            try {
                StringBuffer buffer = new StringBuffer(100);
                DBDescriptor dbDescriptor = DbUtils.getDbDescriptor(connection);
                DbColumn modelTable = new DbColumn("model", schemaName, "m");
                DbColumn disabledColumnName = new DbColumn("disabled", "m");
                DbColumn modelPartionColumnName = new DbColumn("partition", "m");
                int partitionOid = partitionInfo.getPartitionOid();
                String selectList = DbUtils.getColumnList(dbDescriptor, new IDbColumn[]{new DbColumn("oid", "m"), new DbColumn("id", "m"), new DbColumn("version", "m"), new DbColumn("validFrom", "m"), new DbColumn("validTo", "m"), new DbColumn("deploymentStamp", "m")});
                buffer.append("select ").append(selectList).append(" from ").append(modelTable.getQualifiedNameWithAlias()).append(" where ").append(modelPartionColumnName).append(" = ?").append(" and ").append(disabledColumnName).append(" = ?");
                ps = connection.prepareStatement(buffer.toString());
                ps.setInt(1, partitionOid);
                ps.setBoolean(2, false);
                rs = SqlUtils.performQuery(ps, buffer.toString());
                while (rs.next()) {
                    long modelOID = rs.getLong("oid");
                    String modelId = rs.getString("id");
                    String version = rs.getString("version");
                    long validFrom = rs.getLong("validFrom");
                    long validTo = rs.getLong("validTo");
                    long deploymentStamp = rs.getLong("deploymentStamp");
                    IModelInfoImpl deployedModel = new IModelInfoImpl();
                    deployedModel.setOid(modelOID);
                    deployedModel.setId(modelId);
                    deployedModel.setVersion(version);
                    deployedModel.setValidFrom(validFrom);
                    deployedModel.setValidUntil(validTo);
                    deployedModel.setDeploymentStamp(deploymentStamp);
                    modelIdMap.put(modelOID, deployedModel);
                }
            }
            catch (Exception e) {
                log.error(e);
                throw new RuntimeException(e);
            }
        }
        catch (Throwable throwable) {
            SqlUtils.closeQuery(ps, rs);
            throw throwable;
        }
        SqlUtils.closeQuery(ps, rs);
        return modelIdMap;
    }

    private static final class FlushModelManagerAction
    implements Action<Object>,
    Serializable {
        private static final long serialVersionUID = 1L;
        private final ModelManager partitionLocalModelManager;

        public FlushModelManagerAction(ModelManager modelManager) {
            this.partitionLocalModelManager = modelManager instanceof ModelManagerBean.ModelManagerPartition ? modelManager : (modelManager instanceof ModelManagerBean ? ((ModelManagerBean)modelManager).getModelManagerPartition() : null);
        }

        public Object execute() {
            if (this.partitionLocalModelManager != null) {
                ((ModelManagerBean.ModelManagerPartition)this.partitionLocalModelManager).release();
            }
            return null;
        }
    }
}

