/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common.beans.security;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.engine.api.query.ActivityInstanceQuery;
import org.eclipse.stardust.engine.api.query.DataPrefetchHint;
import org.eclipse.stardust.engine.api.query.FilterAndTerm;
import org.eclipse.stardust.engine.api.query.Query;
import org.eclipse.stardust.engine.api.runtime.QueryService;
import org.eclipse.stardust.engine.core.runtime.utils.AbstractAuthorization2Predicate;
import org.eclipse.stardust.engine.core.runtime.utils.AuthorizationContext;
import org.eclipse.stardust.reporting.common.DataPrefetchColumn;
import org.eclipse.stardust.reporting.common.IDataPrefetchColumn;
import org.eclipse.stardust.reporting.common.StructDataDescriptor;
import org.eclipse.stardust.reporting.common.StructDataPrefetchColumn;
import org.eclipse.stardust.reporting.common.View;
import org.eclipse.stardust.reporting.common.beans.security.AuthorizationManager;
import org.eclipse.stardust.reporting.common.beans.security.DummyAuthorizationManager;
import org.eclipse.stardust.reporting.common.utils.ViewUtils;

public class AuthorizationManagerFactory {
    public static AuthorizationManager getInstance(AuthorizationType type, View view) {
        if (ViewUtils.isAuthentificationRequired() && type.equals((Object)AuthorizationType.READ_ACTIVITY_INSTANCE_DATA)) {
            return AuthorizationManagerFactory.forReadActivityInstanceData(view);
        }
        return new DummyAuthorizationManager();
    }

    public static AuthorizationManager forReadActivityInstanceData(View view) {
        AuthorizationContext authorizationContext = AuthorizationContext.create(QueryService.class, (String)"getAllActivityInstances", (Class[])new Class[]{ActivityInstanceQuery.class});
        AbstractAuthorization2Predicate authorizationPredicate = new AbstractAuthorization2Predicate(authorizationContext){};
        ActivityInstanceQuery activityInstanceQuery = ActivityInstanceQuery.findAll();
        authorizationPredicate.addPrefetchDataHints((Query)activityInstanceQuery);
        List<IDataPrefetchColumn> dataPrefetchColumns = AuthorizationManagerFactory.getDataPrefetchColumns(view, (Query)activityInstanceQuery);
        ArrayList<Object> fieldRefs = new ArrayList<Object>();
        fieldRefs.add(null);
        authorizationPredicate.setSelectionExtension(dataPrefetchColumns.size() * -2, fieldRefs);
        AuthorizationManager manager = new AuthorizationManager(authorizationContext, authorizationPredicate);
        manager.setDataPrefetchColumns(dataPrefetchColumns);
        return manager;
    }

    private static List<IDataPrefetchColumn> getDataPrefetchColumns(View view, Query query) {
        ArrayList<IDataPrefetchColumn> dataPrefetchColumns = new ArrayList<IDataPrefetchColumn>();
        FilterAndTerm filters = query.getFilter();
        for (Object filter : filters.getParts()) {
            if (!(filter instanceof DataPrefetchHint)) continue;
            DataPrefetchHint dataPrefetchHint = (DataPrefetchHint)filter;
            if (StringUtils.isNotEmpty((String)dataPrefetchHint.getAttributeName())) {
                StructDataPrefetchColumn dataColumn = new StructDataPrefetchColumn(view, null, null, String.class, dataPrefetchHint.getAttributeName());
                dataColumn.setColumnProvider(new StructDataDescriptor(view, dataPrefetchHint));
                dataPrefetchColumns.add(dataColumn);
                continue;
            }
            dataPrefetchColumns.add(new DataPrefetchColumn(view, dataPrefetchHint));
        }
        return dataPrefetchColumns;
    }

    public static enum AuthorizationType {
        READ_ACTIVITY_INSTANCE_DATA;

    }
}

