/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common.cluster;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.xml.namespace.QName;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stardust.common.Pair;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.config.Parameters;
import org.eclipse.stardust.engine.core.persistence.Operator;
import org.eclipse.stardust.engine.core.runtime.setup.DataCluster;
import org.eclipse.stardust.engine.core.runtime.setup.DataSlot;
import org.eclipse.stardust.engine.core.runtime.setup.RuntimeSetup;
import org.eclipse.stardust.reporting.common.DataColumn;
import org.eclipse.stardust.reporting.common.DataJoinInfo;
import org.eclipse.stardust.reporting.common.GroupColumn;
import org.eclipse.stardust.reporting.common.IDataColumn;
import org.eclipse.stardust.reporting.common.IDataPrefetchColumn;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;
import org.eclipse.stardust.reporting.common.ReportingCommon_Messages;
import org.eclipse.stardust.reporting.common.View;
import org.eclipse.stardust.reporting.common.cluster.ClusterInfo;
import org.eclipse.stardust.reporting.common.cluster.IData2ClusterMapper;
import org.eclipse.stardust.reporting.common.utils.ViewUtils;

public class Data2ClusterMapper
implements IData2ClusterMapper {
    private static Logger log = LogUtils.getLogger(Data2ClusterMapper.class);
    private static final String CLUSTER_TAB_ALIAS_PREFIX = "PR_DVCL";
    private final View view;
    private final Object[] parameters;
    private final boolean useOuterJoins;
    private final List dataColumns;
    private final DataCluster[] dataClusterSetup;
    private final Map dataColumn2ClusterSlot = new HashMap();
    private final Map<Pair<DataColumn, Boolean>, String> dataColumn2SelectFragment = new HashMap<Pair<DataColumn, Boolean>, String>();
    private final Map<IDataColumn, String> dataColumn2JoinFragment = new HashMap<IDataColumn, String>();
    private final Map<Pair<DataColumn, Boolean>, String> dataColumn2WhereFragment = new HashMap<Pair<DataColumn, Boolean>, String>();
    private final Map dataColumn2AliasedColumn = new HashMap();
    private final Map dataCluster2TableAlias = new HashMap();
    private final Set markedAsUsed = new HashSet();
    private List<String> clusterJoins = new ArrayList<String>();
    private final Map<IDataColumn, List<DataJoinInfo>> joinInfoMap;

    public Data2ClusterMapper(View view, List dataColumns, Object[] parameters, boolean useOuterJoins, Map<IDataColumn, List<DataJoinInfo>> joinInfoMap) {
        this.view = view;
        this.parameters = parameters;
        this.useOuterJoins = useOuterJoins;
        this.joinInfoMap = joinInfoMap;
        this.dataColumns = Collections.unmodifiableList(new ArrayList(dataColumns));
        this.dataClusterSetup = RuntimeSetup.instance().getDataClusterSetup();
        Parameters.instance().set("org.eclipse.stardust.engine.core.runtime.setup", null);
        this.initDataClusterTableAliases();
        this.initDataColumnClusterSlotMapping();
        this.initLookUpMaps();
    }

    @Override
    public boolean foundClusterConfig() {
        return this.dataClusterSetup != null && this.dataClusterSetup.length != 0;
    }

    @Override
    public String getAnsiJoinFragment(IDataColumn dataColumn) {
        return this.dataColumn2JoinFragment.get(dataColumn);
    }

    @Override
    public String getSelectFragment(IDataColumn dataColumn) {
        return this.dataColumn2SelectFragment.get(new Pair((Object)dataColumn, (Object)(dataColumn instanceof IDataPrefetchColumn)));
    }

    @Override
    public String getAliasedColumn(IDataColumn dataColumn) {
        return (String)this.dataColumn2AliasedColumn.get(dataColumn);
    }

    @Override
    public String getDataValueFilter(IDataColumn dataColumn) {
        return this.dataColumn2WhereFragment.get(new Pair((Object)dataColumn, (Object)(dataColumn instanceof IDataPrefetchColumn)));
    }

    @Override
    public ClusterInfo getClusterInfo(IDataColumn dataColumn) {
        ClusterInfo info = null;
        Pair clusterSlot = (Pair)this.dataColumn2ClusterSlot.get(dataColumn);
        if (clusterSlot != null) {
            DataCluster cluster = (DataCluster)clusterSlot.getFirst();
            DataSlot slot = (DataSlot)clusterSlot.getSecond();
            String alias = (String)this.dataCluster2TableAlias.get(cluster);
            info = new ClusterInfo(cluster, slot, alias);
        }
        return info;
    }

    private void initDataClusterTableAliases() {
        if (this.foundClusterConfig()) {
            int idx = 0;
            while (idx < this.dataClusterSetup.length) {
                this.dataCluster2TableAlias.put(this.dataClusterSetup[idx], CLUSTER_TAB_ALIAS_PREFIX + (idx + 1));
                ++idx;
            }
        }
    }

    private void initDataColumnClusterSlotMapping() {
        if (this.foundClusterConfig()) {
            HashSet<DataCluster> availableClusters = new HashSet<DataCluster>();
            int idx = 0;
            while (idx < this.dataClusterSetup.length) {
                availableClusters.add(this.dataClusterSetup[idx]);
                ++idx;
            }
            HashSet<DataInfo> availableDatas = new HashSet<DataInfo>();
            for (IDataColumn dataColumn : this.dataColumns) {
                availableDatas.add(new DataInfo(dataColumn));
            }
            DataCluster bestMatch = Data2ClusterMapper.findBestClusterMatch(availableClusters, availableDatas);
            while (bestMatch != null) {
                HashSet<DataInfo> coveredDatas = new HashSet<DataInfo>(availableDatas);
                coveredDatas.retainAll(Data2ClusterMapper.getCoveredDatas(bestMatch));
                for (DataInfo dataInfo : coveredDatas) {
                    String fullDataId = this.getFullDataId(dataInfo);
                    DataSlot slot = bestMatch.getSlot(fullDataId, dataInfo.attributeName);
                    if (slot == null) {
                        log.error(MessageFormat.format("Cluster table {0} is found as best match for data {1} but there could not be found a matching dataSlot. Cluster will not be used for this data.", bestMatch.getTableName(), dataInfo));
                        break;
                    }
                    IDataColumn dataColumn = this.findDataColumn(dataInfo);
                    if (dataColumn == null) {
                        log.error(MessageFormat.format("No DataColumn found for data {0}. Cluster will not be used for this data.", dataInfo));
                        break;
                    }
                    this.dataColumn2ClusterSlot.put(dataColumn, new Pair((Object)bestMatch, (Object)slot));
                }
                availableClusters.remove(bestMatch);
                availableDatas.removeAll(coveredDatas);
                bestMatch = Data2ClusterMapper.findBestClusterMatch(availableClusters, availableDatas);
            }
        }
    }

    @Override
    public List<String> getClusterJoins() {
        return this.clusterJoins;
    }

    private void buildClusterJoins() {
        HashSet<DataCluster> dataClusterToJoin = new HashSet<DataCluster>();
        for (IDataColumn dataColumn : this.dataColumns) {
            Pair clusterSlot = (Pair)this.dataColumn2ClusterSlot.get(dataColumn);
            if (clusterSlot == null) continue;
            DataCluster cluster = (DataCluster)clusterSlot.getFirst();
            dataClusterToJoin.add(cluster);
        }
        for (DataCluster cluster : dataClusterToJoin) {
            String clusterJoin = this.buildClusterJoin(cluster);
            this.clusterJoins.add(clusterJoin);
        }
    }

    private String buildClusterJoin(DataCluster cluster) {
        String clusterAlias = (String)this.dataCluster2TableAlias.get(cluster);
        clusterAlias = clusterAlias.toLowerCase();
        StringBuffer buffer = new StringBuffer();
        buffer.append(" inner join ").append(this.view.getQualifiedTableName(cluster.getTableName())).append(' ').append(clusterAlias);
        buffer.append(" on (pi.scopeprocessinstance = ").append(clusterAlias).append('.').append(cluster.getProcessInstanceColumn()).append(") ");
        return buffer.toString();
    }

    private void initLookUpMaps() {
        this.buildClusterJoins();
        for (IDataColumn dataColumn : this.dataColumns) {
            Pair clusterSlot = (Pair)this.dataColumn2ClusterSlot.get(dataColumn);
            if (clusterSlot != null) {
                this.dataColumn2SelectFragment.put((Pair<DataColumn, Boolean>)new Pair((Object)dataColumn, (Object)(dataColumn instanceof IDataPrefetchColumn)), this.buildSelectFragment(dataColumn, clusterSlot));
                this.dataColumn2AliasedColumn.put(dataColumn, this.buildAliasedColumn(dataColumn, clusterSlot));
                this.dataColumn2WhereFragment.put((Pair<DataColumn, Boolean>)new Pair((Object)dataColumn, (Object)(dataColumn instanceof IDataPrefetchColumn)), this.buildDataValueFilter(dataColumn, clusterSlot));
                continue;
            }
            this.dataColumn2SelectFragment.put((Pair<DataColumn, Boolean>)new Pair((Object)dataColumn, (Object)(dataColumn instanceof IDataPrefetchColumn)), dataColumn.getSelectFragment());
            List<DataJoinInfo> joinInfoForColumn = this.joinInfoMap.get(dataColumn);
            this.dataColumn2JoinFragment.put(dataColumn, dataColumn.getAnsiJoin(joinInfoForColumn, this.useOuterJoins));
            this.dataColumn2AliasedColumn.put(dataColumn, dataColumn.getAliasedColumn());
            this.dataColumn2WhereFragment.put((Pair<DataColumn, Boolean>)new Pair((Object)dataColumn, (Object)(dataColumn instanceof IDataPrefetchColumn)), dataColumn.getDataValueFilter(this.parameters));
        }
    }

    private String buildSelectFragment(IDataColumn dataColumn, Pair clusterSlot) {
        if (clusterSlot == null) {
            return null;
        }
        DataCluster cluster = (DataCluster)clusterSlot.getFirst();
        DataSlot slot = (DataSlot)clusterSlot.getSecond();
        String clusterAlias = (String)this.dataCluster2TableAlias.get(cluster);
        String alias = clusterAlias.toLowerCase();
        StringBuffer buffer = new StringBuffer();
        buffer.append(alias).append('.');
        buffer.append(slot.getTypeColumn());
        buffer.append(", ");
        String sValueColumn = slot.getSValueColumn();
        if (StringUtils.isEmpty((String)sValueColumn)) {
            buffer.append("''");
        } else {
            buffer.append(alias).append('.');
            buffer.append(sValueColumn);
        }
        if (!(dataColumn instanceof IDataPrefetchColumn)) {
            buffer.append(", ");
            String nValueColumn = slot.getNValueColumn();
            if (StringUtils.isEmpty((String)nValueColumn)) {
                buffer.append("0");
            } else {
                buffer.append(alias).append('.');
                buffer.append(nValueColumn);
            }
        }
        buffer.append(", ");
        buffer.append(alias).append('.').append(slot.getOidColumn());
        return buffer.toString();
    }

    private String buildDataValueFilter(IDataColumn dataColumn, Pair joinSlot) {
        StringBuffer buffer = new StringBuffer();
        if (dataColumn.getValueFilterParameter() != null) {
            String stringifiedParameterValue = this.parameters[dataColumn.getValueFilterParameter().getIndex() - 1].toString();
            String[] parameterParts = stringifiedParameterValue.split(",");
            ArrayList<Object> inFilterCandidates = new ArrayList<Object>(parameterParts.length);
            ArrayList<String> likeFilterCandidates = new ArrayList<String>(parameterParts.length);
            int n = 0;
            while (n < parameterParts.length) {
                stringifiedParameterValue = parameterParts[n].trim();
                if (dataColumn.isNumeric()) {
                    if (StringUtils.isNotEmpty((String)stringifiedParameterValue) && !ViewUtils.isSelectAllWildcard(stringifiedParameterValue)) {
                        inFilterCandidates.add(Long.valueOf(stringifiedParameterValue));
                    }
                } else if (stringifiedParameterValue.length() != 0 && !stringifiedParameterValue.equals("%")) {
                    if (stringifiedParameterValue.indexOf("%") == -1) {
                        inFilterCandidates.add(stringifiedParameterValue);
                    } else {
                        likeFilterCandidates.add(stringifiedParameterValue);
                    }
                }
                ++n;
            }
            String aliasedColumn = (String)this.dataColumn2AliasedColumn.get(dataColumn);
            ArrayList<String> filterTerms = new ArrayList<String>();
            if (!inFilterCandidates.isEmpty()) {
                if (inFilterCandidates.size() == 1) {
                    filterTerms.add(Data2ClusterMapper.concatDataFilter(aliasedColumn, (Operator)Operator.IS_EQUAL, inFilterCandidates.get(0)));
                } else {
                    filterTerms.add(Data2ClusterMapper.concatDataFilter(aliasedColumn, (Operator)Operator.IN, inFilterCandidates));
                }
            }
            Iterator iterator = likeFilterCandidates.iterator();
            while (iterator.hasNext()) {
                filterTerms.add(Data2ClusterMapper.concatDataFilter(aliasedColumn, (Operator)Operator.LIKE, iterator.next()));
            }
            if (!this.useOuterJoins && filterTerms.isEmpty()) {
                filterTerms.add(Data2ClusterMapper.concatDataFilter(aliasedColumn, (Operator)Operator.IS_NOT_NULL, null));
            }
            if (!filterTerms.isEmpty()) {
                buffer.append(StringUtils.join(filterTerms.iterator(), (String)" OR "));
                if (filterTerms.size() > 1) {
                    buffer.insert(0, '(');
                    buffer.append(')');
                }
            }
        }
        return buffer.toString();
    }

    private String buildAliasedColumn(IDataColumn dataColumn, Pair clusterSlot) {
        StringBuffer buffer = new StringBuffer();
        DataCluster cluster = (DataCluster)clusterSlot.getFirst();
        DataSlot slot = (DataSlot)clusterSlot.getSecond();
        String clusterAlias = (String)this.dataCluster2TableAlias.get(cluster);
        clusterAlias = clusterAlias.toLowerCase();
        buffer.append(clusterAlias).append('.');
        if (dataColumn.isNumeric()) {
            buffer.append(slot.getNValueColumn());
        } else {
            buffer.append(slot.getSValueColumn());
        }
        return buffer.toString();
    }

    private static String formatedValues(Object values) {
        StringBuffer buffer = new StringBuffer();
        if (values instanceof String) {
            buffer.append("'").append(values).append("'");
        } else if (values instanceof Number) {
            buffer.append(values);
        } else if (values instanceof List) {
            String delimiter = "";
            List valuesList = (List)values;
            for (Object value : valuesList) {
                buffer.append(delimiter);
                buffer.append(Data2ClusterMapper.formatedValues(value));
                delimiter = ",";
            }
        }
        return buffer.toString();
    }

    private static String concatDataFilter(String aliasedColumn, Operator operator, Object values) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(aliasedColumn);
        buffer.append(' ').append(operator.getId()).append(' ');
        if (Operator.IN == operator) {
            buffer.append('(');
            buffer.append(Data2ClusterMapper.formatedValues(values));
            buffer.append(')');
        } else if (Operator.IS_EQUAL == operator) {
            buffer.append(Data2ClusterMapper.formatedValues(values));
        } else if (Operator.LIKE == operator) {
            buffer.append(Data2ClusterMapper.formatedValues(values));
        } else if (Operator.IS_NOT_NULL != operator) {
            throw new RuntimeException(NLS.bind((String)ReportingCommon_Messages.OperatorNotSupported, (Object)operator.getName()));
        }
        return buffer.toString();
    }

    private static DataCluster findBestClusterMatch(Set<DataCluster> clusters, Set<DataInfo> datas) {
        DataCluster bestMatchingCluster = null;
        int bestMatchingSize = 0;
        for (DataCluster cluster : clusters) {
            Set<DataInfo> matchingDatas = Data2ClusterMapper.getCoveredDatas(cluster);
            matchingDatas.retainAll(datas);
            int matchingSize = matchingDatas.size();
            if (matchingSize <= bestMatchingSize) continue;
            bestMatchingSize = matchingSize;
            bestMatchingCluster = cluster;
        }
        return bestMatchingCluster;
    }

    private static Set<DataInfo> getCoveredDatas(DataCluster cluster) {
        HashSet<DataInfo> dataIds = new HashSet<DataInfo>();
        for (DataSlot slot : cluster.getAllSlots()) {
            dataIds.add(new DataInfo(slot));
        }
        return dataIds;
    }

    private IDataColumn findDataColumn(DataInfo dataInfo) {
        for (GroupColumn rawColumn : this.view.getGroupColumns()) {
            IDataColumn dataColumn;
            DataInfo columnDataInfo;
            if (!(rawColumn instanceof IDataColumn) || !(columnDataInfo = new DataInfo(dataColumn = (IDataColumn)((Object)rawColumn))).equals(dataInfo)) continue;
            return dataColumn;
        }
        return null;
    }

    private String getFullDataId(DataInfo info) {
        QName fqn = new QName(info.modelId, info.dataId);
        return fqn.toString();
    }

    private static class DataInfo {
        public String modelId;
        public String dataId;
        public String attributeName;

        public DataInfo(IDataColumn column) {
            this(column.getModelId(), column.getDataId(), column.getAttributeName());
        }

        public DataInfo(DataSlot slot) {
            this(slot.getModelId(), slot.getDataId(), slot.getAttributeName());
        }

        public DataInfo(String modelId, String dataId, String attributeName) {
            this.modelId = modelId;
            this.dataId = dataId;
            this.attributeName = attributeName;
        }

        public int hashCode() {
            int result = 1;
            result = 31 * result + (this.attributeName == null ? 0 : this.attributeName.hashCode());
            result = 31 * result + (this.dataId == null ? 0 : this.dataId.hashCode());
            result = 31 * result + (this.modelId == null ? 0 : this.modelId.hashCode());
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            DataInfo other = (DataInfo)obj;
            if (this.attributeName == null ? other.attributeName != null : !this.attributeName.equals(other.attributeName)) {
                return false;
            }
            if (this.dataId == null ? other.dataId != null : !this.dataId.equals(other.dataId)) {
                return false;
            }
            return !(this.modelId == null ? other.modelId != null : !this.modelId.equals(other.modelId));
        }

        public String toString() {
            return "(" + this.modelId + "," + this.dataId + "," + this.attributeName + ")";
        }
    }
}

