/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.stardust.reporting.common.ProcessDatabaseQueryService;
import org.eclipse.stardust.reporting.common.metadata.ColumnDefinition;
import org.eclipse.stardust.reporting.common.metadata.TableDefinition;

public class DatabaseDefinition
implements Serializable {
    private List tableDefinitions = new ArrayList();
    private ProcessDatabaseQueryService queryService;

    public DatabaseDefinition(ProcessDatabaseQueryService queryService) {
        this.queryService = queryService;
    }

    public TableDefinition addTableDefinition(String schema, String name, String type) {
        TableDefinition tableDefinition = new TableDefinition(this, schema, name, type);
        this.tableDefinitions.add(tableDefinition);
        return tableDefinition;
    }

    public List getTableDefinitions() {
        return this.tableDefinitions;
    }

    public TableDefinition findTableDefinitionByQualifiedName(String qualifiedName) {
        String[] names = qualifiedName.toLowerCase().split("\\.");
        int n = 0;
        while (n < this.getTableDefinitions().size()) {
            TableDefinition tableDefinition = (TableDefinition)this.getTableDefinitions().get(n);
            if (tableDefinition.getSchema().equals(names[0]) && tableDefinition.getName().equals(names[1])) {
                return tableDefinition;
            }
            ++n;
        }
        return null;
    }

    public ColumnDefinition findColumnDefinitionByQualifiedName(String qualifiedName) {
        String[] names = qualifiedName.split("\\.");
        TableDefinition tableDefinition = this.findTableDefinitionByQualifiedName(String.valueOf(names[0]) + "." + names[1]);
        if (tableDefinition != null) {
            return tableDefinition.findColumnDefinitionByName(names[2]);
        }
        return null;
    }

    public ProcessDatabaseQueryService getQueryService() {
        return this.queryService;
    }
}

