/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common.metadata;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;
import org.eclipse.stardust.reporting.common.ProcessDatabaseQueryException;
import org.eclipse.stardust.reporting.common.metadata.ColumnDefinition;
import org.eclipse.stardust.reporting.common.metadata.DatabaseDefinition;

public class TableDefinition
implements Serializable {
    private static final Logger log = LogUtils.getLogger(TableDefinition.class);
    String schema;
    String name;
    String type;
    DatabaseDefinition databaseDefinition;
    boolean columnsFetched;
    List columns;

    public TableDefinition(DatabaseDefinition databaseDefinition, String schema, String name, String type) {
        this.databaseDefinition = databaseDefinition;
        this.schema = schema.toLowerCase();
        this.name = name.toLowerCase();
        this.type = type;
        this.columnsFetched = false;
        this.columns = new ArrayList();
    }

    public ColumnDefinition addColumnDefinition(String name, String type, int cardinality, int precision, boolean nullable) {
        ColumnDefinition columnDefinition = new ColumnDefinition(this, name, type, cardinality, precision, nullable);
        this.columns.add(columnDefinition);
        return columnDefinition;
    }

    public List getColumnDefinitions() {
        if (!this.columnsFetched) {
            try {
                this.databaseDefinition.getQueryService().updateTableDefinition(this);
                this.columnsFetched = true;
            }
            catch (ProcessDatabaseQueryException e) {
                log.error(e);
            }
        }
        return this.columns;
    }

    public String getName() {
        return this.name;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getType() {
        return this.type;
    }

    public String getDefinitionString() {
        return String.valueOf(this.getSchema()) + "." + this.getName() + ": " + this.getType();
    }

    public ColumnDefinition findColumnDefinitionByName(String name) {
        for (ColumnDefinition columnDefinition : this.getColumnDefinitions()) {
            if (!columnDefinition.getName().equals(name)) continue;
            return columnDefinition;
        }
        return null;
    }
}

