/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common.metamodel;

import java.io.Serializable;
import java.lang.reflect.Method;
import java.util.Map;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stardust.common.reflect.Reflect;
import org.eclipse.stardust.engine.api.model.IActivity;
import org.eclipse.stardust.engine.api.model.IApplication;
import org.eclipse.stardust.engine.api.model.IApplicationContext;
import org.eclipse.stardust.engine.api.model.IData;
import org.eclipse.stardust.engine.api.model.IModel;
import org.eclipse.stardust.engine.core.model.utils.IdentifiableElement;
import org.eclipse.stardust.engine.core.pojo.data.Type;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;
import org.eclipse.stardust.reporting.common.ReportingCommon_Messages;
import org.eclipse.stardust.reporting.common.metamodel.Node;
import org.eclipse.stardust.reporting.common.utils.Localizer;

public class Attribute {
    private static Logger log = LogUtils.getLogger(Attribute.class);
    private static Map<String, String> localizationMap;
    Node node;
    String id;
    String label;
    Class type;

    public Attribute(Node node, String id, String label, Class type) {
        this.node = node;
        this.id = id;
        this.type = type;
        this.label = label;
    }

    public String getID() {
        return this.id;
    }

    public String getLabel() {
        return this.label;
    }

    public Class getType() {
        return this.type;
    }

    public Node getNode() {
        return this.node;
    }

    public Object getValueForObject(Object object, IModel model) {
        Method propertyAccessMethod;
        block44: {
            if (object instanceof IData) {
                try {
                    IData data = (IData)object;
                    if ("type".equals(this.getID())) {
                        String result = null;
                        if (data.getType() != null) {
                            result = data.getType().getId();
                        } else if (data.getAttribute("carnot:engine:typeHint") != null) {
                            result = "primitive";
                        }
                        return result != null ? result : "-";
                    }
                    if ("class".equals(this.getID())) {
                        Object result = null;
                        if (data.getType() != null) {
                            if ("primitive".equals(data.getType().getId())) {
                                Class clazz;
                                Type type = (Type)data.getAttribute("carnot:engine:type");
                                if (type != null && (clazz = Reflect.getClassFromAbbreviatedName((String)type.getName())) != null) {
                                    result = clazz.getName();
                                }
                            } else {
                                result = "entity".equals(data.getType().getId()) ? data.getAttribute("carnot:engine:remoteInterface") : data.getAttribute("carnot:engine:className");
                            }
                        } else {
                            Object typeHint = data.getAttribute("carnot:engine:typeHint");
                            if ("text".equals(typeHint)) {
                                result = String.class.getName();
                            } else if ("numeric".equals(typeHint)) {
                                result = Double.class.getName();
                            } else if ("complex".equals(typeHint)) {
                                result = Serializable.class.getName();
                            }
                        }
                        return result != null ? result : "-";
                    }
                    break block44;
                }
                catch (Exception exception) {
                    return "-";
                }
            }
            if (object instanceof IApplication) {
                IApplication application = (IApplication)object;
                if (this.getID().equals("type")) {
                    if (application.getType() != null) {
                        return application.getType().getId();
                    }
                    return "-";
                }
            } else if (object instanceof IApplicationContext) {
                IApplicationContext applicationContext = (IApplicationContext)object;
                if (this.getID().equals("type")) {
                    if (applicationContext.getType() != null) {
                        return applicationContext.getType().getId();
                    }
                    return "-";
                }
            } else if (object instanceof IActivity) {
                IActivity activity = (IActivity)object;
                if (this.getID().equals("type")) {
                    if (activity.getImplementationType() != null) {
                        return activity.getImplementationType().getId();
                    }
                    return "-";
                }
                if (this.getID().equals("splitType")) {
                    if (activity.getSplitType() != null) {
                        return activity.getSplitType().getId();
                    }
                    return "-";
                }
                if (this.getID().equals("joinType")) {
                    if (activity.getJoinType() != null) {
                        return activity.getJoinType().getId();
                    }
                    return "-";
                }
                if (this.getID().equals("loopType")) {
                    if (activity.getLoopType() != null) {
                        return activity.getLoopType().getId();
                    }
                    return "-";
                }
                if (this.getID().equals("loopCondition")) {
                    if (activity.getLoopCondition() != null) {
                        return activity.getLoopCondition();
                    }
                    return "-";
                }
            }
        }
        if ((propertyAccessMethod = this.getMethod(object)) != null) {
            String methodName = propertyAccessMethod.getName();
            try {
                Object value = propertyAccessMethod.invoke(object, new Object[0]);
                if (object instanceof IdentifiableElement && value instanceof String) {
                    String valueToLocalize = (String)value;
                    IdentifiableElement element = (IdentifiableElement)object;
                    String localeKey = null;
                    if (methodName.startsWith("getName")) {
                        localeKey = Localizer.getLocaleKey(Localizer.KeyType.NAME, element);
                    }
                    if (methodName.startsWith("getDescription")) {
                        localeKey = Localizer.getLocaleKey(Localizer.KeyType.DESCRIPTION, element);
                    }
                    if (localeKey != null && model != null) {
                        value = Localizer.localize(model, localeKey, valueToLocalize);
                    }
                }
                return value;
            }
            catch (Exception e) {
                log.error(e);
            }
        }
        return null;
    }

    private Method getMethod(Object baseObject) {
        Class<?> baseClass = baseObject.getClass();
        String attributeId = this.getID();
        String firstBaseNameLetter = attributeId.substring(0, 1).toUpperCase();
        String remainingBaseNameLetters = attributeId.substring(1);
        String methodSuffix = String.valueOf(firstBaseNameLetter) + remainingBaseNameLetters;
        String commonGetterName = "get" + methodSuffix;
        String booleanGetterName = "is" + methodSuffix;
        try {
            return baseClass.getMethod(commonGetterName, new Class[0]);
        }
        catch (NoSuchMethodException noSuchMethodException) {
            try {
                return baseClass.getMethod(booleanGetterName, new Class[0]);
            }
            catch (NoSuchMethodException noSuchMethodException2) {
                String errorMessage = ReportingCommon_Messages.AttributeMethodNotFound;
                Object[] errorArgs = new Object[]{this.getID(), commonGetterName, booleanGetterName};
                log.error(NLS.bind((String)errorMessage, (Object[])errorArgs));
                return null;
            }
        }
    }
}

