/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common.metamodel;

import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import org.eclipse.stardust.common.Attribute;
import org.eclipse.stardust.common.AttributeHolder;

public class AttributeCategory {
    private String id;
    private AttributeCategory parent;
    private AttributeHolder target;

    public AttributeCategory(AttributeHolder target, String id, AttributeCategory parent) {
        this.target = target;
        this.id = id;
        this.parent = parent;
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getFullId() {
        return this.parent == null || this.parent.getFullId() == null ? this.id : String.valueOf(this.parent.getFullId()) + ":" + this.id;
    }

    public List getAttributes() {
        ArrayList<Attribute> attributes = new ArrayList<Attribute>();
        String prefix = this.getFullId();
        if (prefix != null) {
            prefix = String.valueOf(prefix) + ":";
        }
        for (String name : this.target.getAllAttributes().keySet()) {
            if ((prefix != null || name.indexOf(":") >= 0) && (name == null || !name.startsWith(prefix) || name.indexOf(58, prefix.length()) >= 0)) continue;
            attributes.add(this.newAttribute(name));
        }
        return attributes;
    }

    private Attribute newAttribute(final String name) {
        return new Attribute(){

            public String getName() {
                return name;
            }

            public String getId() {
                return name;
            }

            public String getStringifiedValue() {
                Object value = this.getValue();
                return value == null ? null : value.toString();
            }

            public Object getValue() {
                return AttributeCategory.this.target.getAttribute(name);
            }

            public void setValue(Object value) {
                AttributeCategory.this.target.setAttribute(name, value);
            }

            public Date getLastModificationTime() {
                return new Date(0L);
            }
        };
    }

    public List getAttributeCategories() {
        ArrayList<AttributeCategory> attributeCategories = new ArrayList<AttributeCategory>();
        HashSet<String> ids = new HashSet<String>();
        String prefix = this.getFullId();
        if (prefix != null) {
            prefix = String.valueOf(prefix) + ":";
            for (String name : this.target.getAllAttributes().keySet()) {
                String[] categoryIds;
                if (name == null || !name.startsWith(prefix) || name.indexOf(58, prefix.length()) <= 0 || (categoryIds = name.substring(prefix.length()).split(":")).length <= 1 || ids.contains(categoryIds[0])) continue;
                ids.add(categoryIds[0]);
                attributeCategories.add(new AttributeCategory(this.target, categoryIds[0], this));
            }
        }
        return attributeCategories;
    }

    public void removeAttribute(String attributeId) {
        this.target.removeAttribute(attributeId);
    }

    public void removeAttributeCategory(String categoryId) {
        ArrayList<String> toRemove = new ArrayList<String>();
        if (this.getFullId() != null) {
            String prefix = String.valueOf(this.getFullId()) + ":" + categoryId + ":";
            for (String attribute : this.target.getAllAttributes().keySet()) {
                if (!attribute.startsWith(prefix)) continue;
                toRemove.add(attribute);
            }
        }
        Iterator iter = toRemove.iterator();
        while (iter.hasNext()) {
            this.target.removeAttribute((String)iter.next());
        }
    }

    public Attribute getAttribute(String attributeId) {
        return this.target.getAttribute(attributeId) == null ? null : this.newAttribute(attributeId);
    }

    public AttributeCategory getAttributeCategory(String categoryId) {
        if (this.getFullId() != null) {
            String prefix = String.valueOf(this.getFullId()) + ":" + categoryId + ":";
            for (String attribute : this.target.getAllAttributes().keySet()) {
                if (!attribute.startsWith(prefix)) continue;
                return new AttributeCategory(this.target, categoryId, this);
            }
        }
        return null;
    }

    public Attribute createAttribute(String attributeId) {
        if (this.getFullId() != null) {
            String attName = String.valueOf(this.getFullId()) + ":" + attributeId;
            if (this.target.getAttribute(attName) != null) {
                throw new IllegalArgumentException(MessageFormat.format("MSG_AttributeExists", attName));
            }
            return this.newAttribute(attributeId);
        }
        return null;
    }

    public AttributeCategory createAttributeCategory(String categoryId) {
        if (this.getFullId() != null) {
            String prefix = String.valueOf(this.getFullId()) + ":" + categoryId;
            for (String attribute : this.target.getAllAttributes().keySet()) {
                if (!attribute.startsWith(prefix)) continue;
                throw new IllegalArgumentException(MessageFormat.format("MSG_AttributeCategoryExists", prefix));
            }
            return new AttributeCategory(this.target, categoryId, this);
        }
        return null;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AttributeCategory)) {
            return false;
        }
        AttributeCategory attributeCategory = (AttributeCategory)o;
        if (this.id != null ? !this.id.equals(attributeCategory.id) : attributeCategory.id != null) {
            return false;
        }
        if (this.parent != null ? !this.parent.equals(attributeCategory.parent) : attributeCategory.parent != null) {
            return false;
        }
        return !(this.target != null ? !this.target.equals(attributeCategory.target) : attributeCategory.target != null);
    }

    public int hashCode() {
        int result = this.id != null ? this.id.hashCode() : 0;
        result = 29 * result + (this.parent != null ? this.parent.hashCode() : 0);
        result = 29 * result + (this.target != null ? this.target.hashCode() : 0);
        return result;
    }
}

