/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common.metamodel;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;
import org.eclipse.stardust.reporting.common.metamodel.Attribute;
import org.eclipse.stardust.reporting.common.metamodel.Link;
import org.eclipse.stardust.reporting.common.utils.Tokenizer;

public class Node {
    private static Logger log = LogUtils.getLogger(Node.class);
    private String name;
    private String label;
    private String iconPath;
    private List outgoingLinks;
    private List incomingLinks;
    private List attributes;

    public Node(String name, String label, String iconPath) {
        this.name = name;
        this.label = label;
        this.iconPath = iconPath;
        this.outgoingLinks = new ArrayList();
        this.incomingLinks = new ArrayList();
        this.attributes = new ArrayList();
    }

    public boolean equals(Object arg0) {
        if (arg0 == null) {
            return false;
        }
        if (arg0 instanceof Node) {
            return this.getName().equals(((Node)arg0).getName());
        }
        return false;
    }

    public String getName() {
        return this.name;
    }

    public String getLabel() {
        return this.label;
    }

    public String getIconPath() {
        return this.iconPath;
    }

    protected void addToIncomingLinks(Link link) {
        this.incomingLinks.add(link);
    }

    protected void addToOutgoingLinks(Link link) {
        this.outgoingLinks.add(link);
    }

    public List getIncomingLinks() {
        return this.incomingLinks;
    }

    public Link getIncomingLinkByName(String name) {
        for (Link link : this.incomingLinks) {
            if (!link.getName().equals(name)) continue;
            return link;
        }
        return null;
    }

    public Link getOutgoingLinkById(String fullId) {
        Link returnValue = null;
        Tokenizer tokenizer = new Tokenizer(fullId);
        String fromNodeName = tokenizer.getToken(0);
        String linkName = tokenizer.getToken(1);
        String toNodeName = tokenizer.getToken(2);
        for (Link link : this.outgoingLinks) {
            Node fromNode = link.getFromNode();
            Node toNode = link.getToNode();
            if (!link.getName().equals(linkName) || !fromNode.getName().equals(fromNodeName) || !toNode.getName().equals(toNodeName)) continue;
            return link;
        }
        return returnValue;
    }

    public Link getOutgoingLinkByName(String name) {
        for (Link link : this.outgoingLinks) {
            if (!link.getName().equals(name)) continue;
            return link;
        }
        return null;
    }

    public List getOutgoingLinks() {
        return this.outgoingLinks;
    }

    public void addAttribute(String id, String label, Class type) {
        this.attributes.add(new Attribute(this, id, label, type));
    }

    public List getAttributes() {
        return this.attributes;
    }

    public Attribute getAttributeByID(String id) {
        int n = 0;
        while (n < this.attributes.size()) {
            if (((Attribute)this.attributes.get(n)).equals(id)) {
                return (Attribute)this.attributes.get(n);
            }
            ++n;
        }
        return null;
    }
}

