/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common.monitoring;

import org.eclipse.stardust.common.config.Parameters;
import org.eclipse.stardust.common.reflect.Reflect;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;

public class Monitoring {
    private static final String CAT_ROOT = Monitoring.getRootCategory();
    public static final Logger SQL = LogUtils.getLogger(String.valueOf(CAT_ROOT) + ".SQL");
    public static final Logger PERFORMANCE = LogUtils.getLogger(String.valueOf(CAT_ROOT) + ".Performance");
    public static final Logger SECURITY = LogUtils.getLogger(String.valueOf(CAT_ROOT) + ".Security");

    public static void traceSql(String sql) {
        if (SQL.isInfoEnabled()) {
            SQL.info("Executing SQL: " + sql);
        }
    }

    public static void traceSlowSql(long tStart, long tStop, String sqlString) {
        if (tStop - tStart >= Parameters.instance().getLong("Carnot.Engine.Tuning.DB.slowStatementTracingThreshold", Long.MAX_VALUE)) {
            PERFORMANCE.warn("Slow SQL: " + (tStop - tStart) + "ms\n" + sqlString);
        }
    }

    private static final String getRootCategory() {
        String fqName = Reflect.getHumanReadableClassName(Monitoring.class, (boolean)true);
        int lastDot = fqName.lastIndexOf(46);
        return -1 != lastDot ? fqName.substring(0, lastDot) : fqName;
    }
}

