/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common.parser;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.antlr.runtime.CharStream;
import org.antlr.runtime.CommonTokenStream;
import org.antlr.runtime.RecognitionException;
import org.antlr.runtime.TokenSource;
import org.antlr.runtime.TokenStream;
import org.antlr.runtime.tree.CommonTree;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stardust.reporting.common.GroupColumn;
import org.eclipse.stardust.reporting.common.Parameter;
import org.eclipse.stardust.reporting.common.ReportingCommon_Messages;
import org.eclipse.stardust.reporting.common.View;
import org.eclipse.stardust.reporting.common.parser.DefaultErrorHandler;
import org.eclipse.stardust.reporting.common.parser.LowerCaseTransformingStream;
import org.eclipse.stardust.reporting.common.parser.ParsedExpression;
import org.eclipse.stardust.reporting.common.parser.generated.ExpressionGrammarLexer;
import org.eclipse.stardust.reporting.common.parser.generated.ExpressionGrammarParser;
import org.eclipse.stardust.reporting.common.utils.ViewUtils;

public class ExpressionUtil {
    public static ExpressionGrammarParser getParserForExpression(String expression, boolean failOnError) throws IOException {
        LowerCaseTransformingStream lowerCaseTransformingStream = new LowerCaseTransformingStream(expression);
        ExpressionGrammarLexer lexer = new ExpressionGrammarLexer((CharStream)lowerCaseTransformingStream);
        CommonTokenStream tokens = new CommonTokenStream((TokenSource)lexer);
        ExpressionGrammarParser parser = new ExpressionGrammarParser((TokenStream)tokens);
        DefaultErrorHandler errorHandler = new DefaultErrorHandler();
        errorHandler.setFailOnError(failOnError);
        parser.setErrorHandler(errorHandler);
        return parser;
    }

    public static void validateExpression(CommonTree tree, View view) throws RecognitionException {
        List<ParsedExpression> columnNames = ExpressionUtil.getColumnNames(tree);
        List<ParsedExpression> parameterReferences = ExpressionUtil.getParameterReferences(tree);
        for (ParsedExpression columnName : columnNames) {
            GroupColumn column = ViewUtils.findColumnByName(view, columnName.getText());
            if (column != null) continue;
            throw new RuntimeException(NLS.bind((String)ReportingCommon_Messages.UnknownColumnReferenceByExpression, (Object)columnName.getText()));
        }
        for (ParsedExpression parameterReference : parameterReferences) {
            String parameterName = ExpressionUtil.getParameterName(parameterReference.getText());
            Parameter parameter = ViewUtils.findParameterByName(view, parameterName);
            if (parameter != null) continue;
            throw new RuntimeException(NLS.bind((String)ReportingCommon_Messages.UnknownParameterReferencedByExpression, (Object)parameterReference.getText()));
        }
    }

    public static void validateExpression(String expression, View view) throws RecognitionException, IOException, RecognitionException {
        ExpressionGrammarParser parser = ExpressionUtil.getParserForExpression(expression, true);
        CommonTree tree = (CommonTree)parser.parseExpression().getTree();
        ExpressionUtil.validateExpression(tree, view);
    }

    public static List<ParsedExpression> findEntries(CommonTree tree, int type) {
        ArrayList<ParsedExpression> parsedExpressions = new ArrayList<ParsedExpression>();
        List childs = tree.getChildren();
        if (childs != null) {
            int i = 0;
            while (i < childs.size()) {
                CommonTree child = (CommonTree)childs.get(i);
                if (child.getType() == type) {
                    parsedExpressions.add(new ParsedExpression(child));
                }
                ++i;
            }
        }
        return parsedExpressions;
    }

    public static List<ParsedExpression> getColumnNames(CommonTree tree) {
        return ExpressionUtil.findEntries(tree, 9);
    }

    public static List<ParsedExpression> getParameterReferences(CommonTree tree) {
        return ExpressionUtil.findEntries(tree, 10);
    }

    public static String getParameterName(String parameterReference) {
        String parameterName = parameterReference;
        parameterName = parameterName.replaceAll("\\$\\{DataSetParameter\\.", "");
        parameterName = parameterName.replaceAll("\\}", "");
        return parameterName;
    }

    public static String replace(String expression, Map<ParsedExpression, GroupColumn> columns, Map<ParsedExpression, Parameter> parameterReferences) {
        StringBuffer replacedExpression = new StringBuffer();
        ArrayList<ParsedExpression> allParsedExpressions = new ArrayList<ParsedExpression>();
        allParsedExpressions.addAll(columns.keySet());
        allParsedExpressions.addAll(parameterReferences.keySet());
        Collections.sort(allParsedExpressions);
        int lastIndex = 0;
        for (ParsedExpression pe : allParsedExpressions) {
            int startIndex = pe.getStartIndex();
            int endIndex = startIndex + pe.getText().length();
            if (startIndex != 0) {
                String s = expression.substring(lastIndex, startIndex);
                replacedExpression.append(s);
            }
            String replacementValue = ExpressionUtil.getReplacementValue(pe, columns, parameterReferences);
            replacedExpression.append(replacementValue);
            lastIndex = endIndex;
        }
        if (lastIndex < expression.length()) {
            String s = expression.substring(lastIndex);
            replacedExpression.append(s);
        }
        return replacedExpression.toString();
    }

    private static String getReplacementValue(ParsedExpression key, Map<ParsedExpression, GroupColumn> columns, Map<ParsedExpression, Parameter> parameterReferences) {
        String replacementValue = null;
        if (columns.containsKey(key)) {
            replacementValue = columns.get(key).getDbColumnRef().getTableAliasedColumnId();
        } else if (parameterReferences.containsKey(key)) {
            replacementValue = parameterReferences.get(key).getCurrentValue();
        }
        return replacementValue;
    }
}

