/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common.utils;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;

public class DateUtils {
    private static Logger log = LogUtils.getLogger(DateUtils.class);
    private static final String YEARS_REGEXP = "[1-9]{1}[0-9]{3}";
    private static final String MONTHS_REGEXP = "([0]{0,1}[1-9]|10|11|12)";
    private static final String DAYS_REGEXP = "(([0-2]{0,1}[0-9])|([3][0-1]))";
    private static final String TIME12H_REGEXP = "(([1][0-2])|([0]{0,1}[0-9]{1})):([0-5]{1}[0-9]{1})[\\s]{0,1}(a|p)m";
    private static final String TIME24H_REGEXP = "(([2][0-3])|([0-1]{0,1}[0-9]{0,1})):([0-5]{0,1}[0-9]{0,1}){0,1}";
    private static final String TIME12H_SEC_REGEXP = "(([1][0-2])|([0]{0,1}[0-9]{1})):([0-5]{1}[0-9]{1}):[0-5]{0,1}[0-9]{0,1}[\\s]{0,1}(a|p)m";
    private static final String TIME24H_SEC_REGEXP = "(([2][0-3])|([0-1]{0,1}[0-9]{0,1})):([0-5]{0,1}[0-9]{0,1}):[0-5]{0,1}[0-9]{0,1}";
    private static final String DATE_TIME12H_FORMAT_REGEXP = "^([1-9]{1}[0-9]{3}\\-([0]{0,1}[1-9]|10|11|12)\\-(([0-2]{0,1}[0-9])|([3][0-1]))[\\s](([1][0-2])|([0]{0,1}[0-9]{1})):([0-5]{1}[0-9]{1})[\\s]{0,1}(a|p)m){1}$";
    private static final String DATE_TIME24H_FORMAT_REGEXP = "^([1-9]{1}[0-9]{3}\\-([0]{0,1}[1-9]|10|11|12)\\-(([0-2]{0,1}[0-9])|([3][0-1]))[\\s](([2][0-3])|([0-1]{0,1}[0-9]{0,1})):([0-5]{0,1}[0-9]{0,1}){0,1}){1}$";
    private static final String DATE_TIME12H_SEC_FORMAT_REGEXP = "^([1-9]{1}[0-9]{3}\\-([0]{0,1}[1-9]|10|11|12)\\-(([0-2]{0,1}[0-9])|([3][0-1]))[\\s](([1][0-2])|([0]{0,1}[0-9]{1})):([0-5]{1}[0-9]{1}):[0-5]{0,1}[0-9]{0,1}[\\s]{0,1}(a|p)m){1}$";
    private static final String DATE_TIME24H_SEC_FORMAT_REGEXP = "^([1-9]{1}[0-9]{3}\\-([0]{0,1}[1-9]|10|11|12)\\-(([0-2]{0,1}[0-9])|([3][0-1]))[\\s](([2][0-3])|([0-1]{0,1}[0-9]{0,1})):([0-5]{0,1}[0-9]{0,1}):[0-5]{0,1}[0-9]{0,1}){1}$";
    private static final String DATE_FORMAT_REGEXP = "^([1-9]{1}[0-9]{3}\\-([0]{0,1}[1-9]|10|11|12)\\-(([0-2]{0,1}[0-9])|([3][0-1]))){1}$";
    private static final String TIME12H_FORMAT_REGEXP = "^((([1][0-2])|([0]{0,1}[0-9]{1})):([0-5]{1}[0-9]{1})[\\s]{0,1}(a|p)m){1}$";
    private static final String TIME24H_FORMAT_REGEXP = "^((([2][0-3])|([0-1]{0,1}[0-9]{0,1})):([0-5]{0,1}[0-9]{0,1}){0,1}){1}$";
    private static final Pattern TIME12H_PATTERN = Pattern.compile("^((([1][0-2])|([0]{0,1}[0-9]{1})):([0-5]{1}[0-9]{1})[\\s]{0,1}(a|p)m){1}$", 2);
    private static final Pattern TIME24H_PATTERN = Pattern.compile("^((([2][0-3])|([0-1]{0,1}[0-9]{0,1})):([0-5]{0,1}[0-9]{0,1}){0,1}){1}$", 2);
    private static final String TIME12H_SEC_FORMAT_REGEXP = "^((([1][0-2])|([0]{0,1}[0-9]{1})):([0-5]{1}[0-9]{1}):[0-5]{0,1}[0-9]{0,1}[\\s]{0,1}(a|p)m){1}$";
    private static final String TIME24H_SEC_FORMAT_REGEXP = "^((([2][0-3])|([0-1]{0,1}[0-9]{0,1})):([0-5]{0,1}[0-9]{0,1}):[0-5]{0,1}[0-9]{0,1}){1}$";
    private static final Pattern TIME12H_SEC_PATTERN = Pattern.compile("^((([1][0-2])|([0]{0,1}[0-9]{1})):([0-5]{1}[0-9]{1}):[0-5]{0,1}[0-9]{0,1}[\\s]{0,1}(a|p)m){1}$", 2);
    private static final Pattern TIME24H_SEC_PATTERN = Pattern.compile("^((([2][0-3])|([0-1]{0,1}[0-9]{0,1})):([0-5]{0,1}[0-9]{0,1}):[0-5]{0,1}[0-9]{0,1}){1}$", 2);
    private static final Pattern DATE_PATTERN = Pattern.compile("^([1-9]{1}[0-9]{3}\\-([0]{0,1}[1-9]|10|11|12)\\-(([0-2]{0,1}[0-9])|([3][0-1]))){1}$", 2);
    private static final Pattern DATE_TIME12H_PATTERN = Pattern.compile("^([1-9]{1}[0-9]{3}\\-([0]{0,1}[1-9]|10|11|12)\\-(([0-2]{0,1}[0-9])|([3][0-1]))[\\s](([1][0-2])|([0]{0,1}[0-9]{1})):([0-5]{1}[0-9]{1})[\\s]{0,1}(a|p)m){1}$", 2);
    private static final Pattern DATE_TIME24H_PATTERN = Pattern.compile("^([1-9]{1}[0-9]{3}\\-([0]{0,1}[1-9]|10|11|12)\\-(([0-2]{0,1}[0-9])|([3][0-1]))[\\s](([2][0-3])|([0-1]{0,1}[0-9]{0,1})):([0-5]{0,1}[0-9]{0,1}){0,1}){1}$", 2);
    private static final Pattern DATE_TIME12H_SEC_PATTERN = Pattern.compile("^([1-9]{1}[0-9]{3}\\-([0]{0,1}[1-9]|10|11|12)\\-(([0-2]{0,1}[0-9])|([3][0-1]))[\\s](([1][0-2])|([0]{0,1}[0-9]{1})):([0-5]{1}[0-9]{1}):[0-5]{0,1}[0-9]{0,1}[\\s]{0,1}(a|p)m){1}$", 2);
    private static final Pattern DATE_TIME24H_SEC_PATTERN = Pattern.compile("^([1-9]{1}[0-9]{3}\\-([0]{0,1}[1-9]|10|11|12)\\-(([0-2]{0,1}[0-9])|([3][0-1]))[\\s](([2][0-3])|([0-1]{0,1}[0-9]{0,1})):([0-5]{0,1}[0-9]{0,1}):[0-5]{0,1}[0-9]{0,1}){1}$", 2);

    private static boolean isTime12HFormat(String date) {
        Matcher dateMatcher = TIME12H_PATTERN.matcher(date);
        return date != null ? dateMatcher.find() : false;
    }

    private static boolean isTime24HFormat(String date) {
        Matcher dateMatcher = TIME24H_PATTERN.matcher(date);
        return date != null ? dateMatcher.find() : false;
    }

    private static boolean isTime12HSecFormat(String date) {
        Matcher dateMatcher = TIME12H_SEC_PATTERN.matcher(date);
        return date != null ? dateMatcher.find() : false;
    }

    private static boolean isTime24HSecFormat(String date) {
        Matcher dateMatcher = TIME24H_SEC_PATTERN.matcher(date);
        return date != null ? dateMatcher.find() : false;
    }

    private static boolean isDateFormat(String date) {
        Matcher dateMatcher = DATE_PATTERN.matcher(date);
        return date != null ? dateMatcher.find() : false;
    }

    private static boolean isDateTime12HFormat(String date) {
        Matcher dateMatcher = DATE_TIME12H_PATTERN.matcher(date);
        return date != null ? dateMatcher.find() : false;
    }

    private static boolean isDateTime24HFormat(String date) {
        Matcher dateMatcher = DATE_TIME24H_PATTERN.matcher(date);
        return date != null ? dateMatcher.find() : false;
    }

    private static boolean isDateTime12HSecFormat(String date) {
        Matcher dateMatcher = DATE_TIME12H_SEC_PATTERN.matcher(date);
        return date != null ? dateMatcher.find() : false;
    }

    private static boolean isDateTime24HSecFormat(String date) {
        Matcher dateMatcher = DATE_TIME24H_SEC_PATTERN.matcher(date);
        return date != null ? dateMatcher.find() : false;
    }

    public static String getDateFormat(String date) {
        String format = null;
        if (DateUtils.isDateTime24HFormat(date)) {
            format = "yyyy-MM-dd HH:mm";
        } else if (DateUtils.isDateTime12HFormat(date)) {
            format = "yyyy-MM-dd hh:mm a";
        }
        if (DateUtils.isDateTime24HSecFormat(date)) {
            format = "yyyy-MM-dd HH:mm:ss";
        } else if (DateUtils.isDateTime12HSecFormat(date)) {
            format = "yyyy-MM-dd hh:mm:ss a";
        } else if (DateUtils.isDateFormat(date)) {
            format = "yyyy-MM-dd";
        } else if (DateUtils.isTime24HFormat(date)) {
            format = "HH:mm";
        } else if (DateUtils.isTime12HFormat(date)) {
            format = "hh:mm a";
        } else if (DateUtils.isTime24HSecFormat(date)) {
            format = "HH:mm:ss";
        } else if (DateUtils.isTime12HSecFormat(date)) {
            format = "hh:mm:ss a";
        }
        return format;
    }

    public static long getTimeInMillis(String date) {
        String dateFormat = DateUtils.getDateFormat(date);
        long timeInMillis = 0L;
        if (StringUtils.isNotEmpty((String)dateFormat)) {
            try {
                SimpleDateFormat format = new SimpleDateFormat(dateFormat);
                Date parsedDate = format.parse(date);
                Calendar cal = Calendar.getInstance();
                cal.setTime(parsedDate);
                timeInMillis = cal.getTimeInMillis();
            }
            catch (ParseException e) {
                log.error(e);
            }
        }
        return timeInMillis;
    }

    public static boolean isDate(String date) {
        boolean isDate = false;
        String dateFormat = DateUtils.getDateFormat(date);
        if (StringUtils.isNotEmpty((String)dateFormat)) {
            isDate = true;
        }
        return isDate;
    }
}

