/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common.utils;

import java.lang.reflect.Method;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.eclipse.core.runtime.Platform;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.error.InternalException;
import org.eclipse.stardust.engine.api.model.IActivity;
import org.eclipse.stardust.engine.api.model.IApplication;
import org.eclipse.stardust.engine.api.model.IConditionalPerformer;
import org.eclipse.stardust.engine.api.model.IData;
import org.eclipse.stardust.engine.api.model.IDataMapping;
import org.eclipse.stardust.engine.api.model.IDataPath;
import org.eclipse.stardust.engine.api.model.IEventHandler;
import org.eclipse.stardust.engine.api.model.IModel;
import org.eclipse.stardust.engine.api.model.IOrganization;
import org.eclipse.stardust.engine.api.model.IProcessDefinition;
import org.eclipse.stardust.engine.api.model.IRole;
import org.eclipse.stardust.engine.api.model.ITrigger;
import org.eclipse.stardust.engine.core.compatibility.diagram.Diagram;
import org.eclipse.stardust.engine.core.model.utils.IdentifiableElement;
import org.eclipse.stardust.engine.core.model.utils.ModelElement;
import org.eclipse.stardust.reporting.common.ReportingCommon_Messages;

public class Localizer {
    public static final String CARNOT_MODEL_RESOURCE_BUNDLE = "carnot:model:resourceBundle";
    public static final String LOCAL_PARAM = "locale_param";
    private List<IModel> allDeployedModels = new ArrayList<IModel>();

    public Localizer(IModel model) {
        ArrayList<IModel> models = new ArrayList<IModel>();
        models.add(model);
        this.allDeployedModels = models;
    }

    public Localizer(List<IModel> allDeployedModels) {
        this.allDeployedModels = allDeployedModels;
    }

    public static String getLocaleKey(KeyType type, IdentifiableElement element) {
        IDataPath dataPath;
        ModelElement me;
        String processId;
        String prefix = null;
        String localeKey = null;
        if (element instanceof IModel) {
            return "Model." + (Object)((Object)type);
        }
        if (element instanceof IActivity) {
            IActivity ia = (IActivity)element;
            processId = ia.getProcessDefinition().getId();
            prefix = "Activity." + processId;
        }
        if (element instanceof IProcessDefinition) {
            prefix = "Process";
        }
        if (element instanceof IData) {
            prefix = "Data";
        }
        if (element instanceof IRole) {
            prefix = "Role";
        }
        if (element instanceof IOrganization) {
            prefix = "Organization";
        }
        if (element instanceof IConditionalPerformer) {
            prefix = "CondPerformer";
        }
        if (element instanceof IApplication) {
            prefix = "Application";
        }
        if (element instanceof Diagram) {
            prefix = "Diagram";
        }
        if (element instanceof ITrigger) {
            prefix = "Trigger";
        }
        if (element instanceof IDataPath && (me = (dataPath = (IDataPath)element).getParent()) instanceof IProcessDefinition) {
            IProcessDefinition definition = (IProcessDefinition)me;
            String processId2 = definition.getId();
            StringBuffer prefixBuffer = new StringBuffer(dataPath.getDirection().getId());
            prefixBuffer.append("DataPath.");
            prefixBuffer.append(processId2);
            prefix = prefixBuffer.toString();
        }
        if (element instanceof IDataMapping) {
            IDataMapping dataMapping = (IDataMapping)element;
            processId = dataMapping.getActivity().getProcessDefinition().getId();
            String activityId = dataMapping.getActivity().getId();
            StringBuffer prefixBuffer = new StringBuffer(dataMapping.getDirection().getId());
            prefixBuffer.append("DataMapping.");
            prefixBuffer.append(processId).append('.');
            prefixBuffer.append(activityId).append('.');
            prefixBuffer.append(dataMapping.getContext());
            prefix = prefixBuffer.toString();
        }
        if (element instanceof IEventHandler) {
            StringBuffer prefixBuffer = new StringBuffer();
            IEventHandler eventHandler = (IEventHandler)element;
            ModelElement parent = eventHandler.getParent();
            if (parent instanceof IProcessDefinition) {
                IProcessDefinition processDefinition = (IProcessDefinition)parent;
                prefixBuffer.append("ProcessEH.");
                prefixBuffer.append(processDefinition.getId());
            }
            if (parent instanceof IActivity) {
                IActivity activity = (IActivity)parent;
                IProcessDefinition processDefinition = activity.getProcessDefinition();
                prefixBuffer.append("ActivityEH.");
                prefixBuffer.append(processDefinition.getId());
                prefixBuffer.append(".").append(activity.getId());
            }
            prefix = prefixBuffer.toString();
        }
        if (StringUtils.isNotEmpty((String)prefix)) {
            String extension = "." + element.getId() + "." + (Object)((Object)type);
            localeKey = String.valueOf(prefix) + extension;
        }
        return localeKey;
    }

    public String localize(long modelOid, String key, String defaultValue) {
        return this.getMessage(modelOid, key, defaultValue);
    }

    public static Object localize(IModel model, String key, String defaultValue) {
        return Localizer.getMessage(model, key, defaultValue);
    }

    public String localizeQualityAssuranceCode(long modelOid, String codeKey, String defaultValue) {
        StringBuffer key = new StringBuffer();
        key.append("QualityAssuranceCode");
        key.append(".");
        key.append(codeKey);
        key.append(".");
        key.append((Object)KeyType.DESCRIPTION);
        return this.getMessage(modelOid, key.toString(), defaultValue);
    }

    public String localizeRoleName(long modelOid, String roleId, String defaultValue) {
        String key = "Role." + roleId + "." + (Object)((Object)KeyType.NAME);
        return this.getMessage(modelOid, key, defaultValue);
    }

    public String localizeRoleDescription(long modelOid, String roleId, String defaultValue) {
        String key = "Role." + roleId + "." + (Object)((Object)KeyType.DESCRIPTION);
        return this.getMessage(modelOid, key, defaultValue);
    }

    public String localizeDataName(long modelOid, String dataId, String defaultValue) {
        String key = "Data." + dataId + "." + (Object)((Object)KeyType.NAME);
        return this.getMessage(modelOid, key, defaultValue);
    }

    public String localizeDataDescription(long modelOid, String dataId, String defaultValue) {
        String key = "Data." + dataId + "." + (Object)((Object)KeyType.DESCRIPTION);
        return this.getMessage(modelOid, key, defaultValue);
    }

    public String localizeModelName(long modelOid, String defaultValue) {
        String key = "Model." + (Object)((Object)KeyType.NAME);
        return this.getMessage(modelOid, key, defaultValue);
    }

    public String localizeModelDescription(long modelOid, String defaultValue) {
        String key = "Model." + (Object)((Object)KeyType.DESCRIPTION);
        return this.getMessage(modelOid, key, defaultValue);
    }

    public String localizeActivityName(long modelOid, String processId, String activityId, String defaultValue) {
        String key = "Activity." + processId + "." + activityId + "." + (Object)((Object)KeyType.NAME);
        return this.getMessage(modelOid, key, defaultValue);
    }

    public String localizeActivityDescription(long modelOid, String processId, String activityId, String defaultValue) {
        String key = "Activity." + processId + "." + activityId + "." + (Object)((Object)KeyType.DESCRIPTION);
        return this.getMessage(modelOid, key, defaultValue);
    }

    public String localizeProcessName(long modelOid, String processId, String defaultValue) {
        String key = "Process." + processId + "." + (Object)((Object)KeyType.NAME);
        return this.getMessage(modelOid, key, defaultValue);
    }

    public String localizeProcessDescription(long modelOid, String processId, String defaultValue) {
        String key = "Process." + processId + "." + (Object)((Object)KeyType.DESCRIPTION);
        return this.getMessage(modelOid, key, defaultValue);
    }

    public static String localizeDate(Date d) {
        Locale locale = Localizer.getLocale();
        DateFormat localeFormat = DateFormat.getDateTimeInstance(2, 2, locale);
        return localeFormat.format(d);
    }

    public static String localizeBoolean(boolean value) {
        String localizedValue = value ? ReportingCommon_Messages.True : ReportingCommon_Messages.False;
        if (StringUtils.isEmpty((String)localizedValue)) {
            localizedValue = "<" + value + ">";
        }
        return localizedValue;
    }

    public String localizeStateString(int state) {
        String localizedValue;
        switch (state) {
            case 0: {
                localizedValue = ReportingCommon_Messages.CreatedState;
                break;
            }
            case 1: {
                localizedValue = ReportingCommon_Messages.ApplicationState;
                break;
            }
            case 2: {
                localizedValue = ReportingCommon_Messages.CompletedState;
                break;
            }
            case 4: {
                localizedValue = ReportingCommon_Messages.InterruptedState;
                break;
            }
            case 5: {
                localizedValue = ReportingCommon_Messages.SuspendedState;
                break;
            }
            case 6: {
                localizedValue = ReportingCommon_Messages.AbortedState;
                break;
            }
            case 7: {
                localizedValue = ReportingCommon_Messages.HibernatedState;
                break;
            }
            case 8: {
                localizedValue = ReportingCommon_Messages.AbortingState;
                break;
            }
            default: {
                localizedValue = "<" + state + ">";
            }
        }
        return localizedValue;
    }

    public static Locale getLocale() {
        Locale found = null;
        if (Platform.isRunning()) {
            try {
                Class<?> locatorClass = Class.forName("org.eclipse.stardust.reporting.common.utils.BirtDesignerLocaleLocator");
                Method getLocaleMethod = locatorClass.getMethod("getLocale", null);
                found = (Locale)getLocaleMethod.invoke(null, null);
            }
            catch (Exception e) {
                throw new InternalException(ReportingCommon_Messages.ErrorGettingLocaleFromViewerPlugin, (Throwable)e);
            }
        } else {
            found = Locale.getDefault();
        }
        return found;
    }

    private static String getMessage(IModel model, String key, String defaultValue) {
        String message = null;
        Locale locale = Localizer.getLocale();
        String modelBundleName = Localizer.getBundleName(model);
        try {
            ResourceBundle bundle;
            if (StringUtils.isNotEmpty((String)modelBundleName) && StringUtils.isNotEmpty((String)key) && locale != null && (bundle = Localizer.getMessageBundle(locale, modelBundleName)) != null) {
                message = bundle.getString(key);
            }
        }
        catch (MissingResourceException missingResourceException) {}
        if (StringUtils.isEmpty(message)) {
            message = defaultValue;
        }
        return message;
    }

    private String getMessage(long modelOid, String key, String defaultValue) {
        String message = null;
        Locale locale = Localizer.getLocale();
        String modelBundleName = this.getBundleName(modelOid);
        try {
            ResourceBundle bundle;
            if (StringUtils.isNotEmpty((String)modelBundleName) && StringUtils.isNotEmpty((String)key) && locale != null && (bundle = Localizer.getMessageBundle(locale, modelBundleName)) != null) {
                message = bundle.getString(key);
            }
        }
        catch (MissingResourceException missingResourceException) {}
        if (StringUtils.isEmpty(message)) {
            message = defaultValue;
        }
        return message;
    }

    private String getBundleName(long modelOid) {
        for (IModel model : this.allDeployedModels) {
            if ((long)model.getModelOID() != modelOid) continue;
            return Localizer.getBundleName(model);
        }
        return null;
    }

    public static String getBundleName(IModel model) {
        String bundleName = (String)model.getAttribute(CARNOT_MODEL_RESOURCE_BUNDLE);
        return bundleName;
    }

    private static ResourceBundle getMessageBundle(Locale locale, String basename) {
        try {
            return ResourceBundle.getBundle(basename, locale, Localizer.getCurrentClassLoader());
        }
        catch (MissingResourceException missingResourceException) {
            return null;
        }
    }

    private static ClassLoader getCurrentClassLoader() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        if (loader == null) {
            loader = Localizer.class.getClassLoader();
        }
        return loader;
    }

    public static enum KeyType {
        NAME("Name"),
        DESCRIPTION("Description");

        private final String name;

        private KeyType(String name) {
            this.name = name;
        }

        public String toString() {
            return this.name;
        }
    }
}

