/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common.utils;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.eclipse.stardust.reporting.common.utils.LargeStringResolver;

public class StringDataSubstitutionTable {
    private Map<Long, SubstitutionColumn> columnLookupMap = new LinkedHashMap<Long, SubstitutionColumn>();
    private String filterDataType;

    public StringDataSubstitutionTable() {
    }

    public StringDataSubstitutionTable(String filterDataType) {
        this.filterDataType = filterDataType;
    }

    public void addColumn(int rowIndex, int rowColumnIndex, long objectOid) {
        SubstitutionColumn substitutionColumn = this.columnLookupMap.get(objectOid);
        if (substitutionColumn == null) {
            substitutionColumn = new SubstitutionColumn(rowIndex, rowColumnIndex, objectOid);
            this.columnLookupMap.put(new Long(objectOid), substitutionColumn);
        } else {
            substitutionColumn.addRowIndex(rowIndex);
        }
    }

    protected SubstitutionColumn getColumn(String key) {
        return this.columnLookupMap.get(key);
    }

    protected Collection<SubstitutionColumn> getAllColumns() {
        return this.columnLookupMap.values();
    }

    public boolean isEmpty() {
        return this.columnLookupMap.isEmpty();
    }

    public void clear() {
        this.columnLookupMap.clear();
        this.columnLookupMap.clear();
    }

    public Object[][] substitute(Object[][] results, Connection connection, String schemaName, Object[] parameters) throws SQLException {
        if (this.isEmpty()) {
            return results;
        }
        Set<Long> objectOidsToResolve = this.getObjectOidsToResolve();
        LargeStringResolver resolver = new LargeStringResolver(objectOidsToResolve, this.filterDataType);
        Map<Long, String> resolvedStrings = resolver.resolve(connection, schemaName);
        for (SubstitutionColumn column : this.getAllColumns()) {
            int columnIndex = column.getColumnIndex();
            Long objectOid = column.getOid();
            String resolvedValue = resolvedStrings.get(objectOid);
            Set<Integer> rowIndices = column.getRowIndices();
            for (Integer rowIndex : rowIndices) {
                results = this.substitute(results, rowIndex, columnIndex, resolvedValue);
            }
        }
        return results;
    }

    protected Object[][] substitute(Object[][] results, int rowIndex, int columnIndex, String resolvedValue) {
        results[rowIndex][columnIndex] = resolvedValue;
        return results;
    }

    private Set<Long> getObjectOidsToResolve() {
        HashSet<Long> oids = new HashSet<Long>();
        for (SubstitutionColumn column : this.getAllColumns()) {
            oids.add(column.getOid());
        }
        return oids;
    }

    private class SubstitutionColumn {
        private int columnIndex;
        private Set<Integer> rowIndices = new LinkedHashSet<Integer>();
        private long oid;

        public SubstitutionColumn(int rowIndex, int columnIndex, long oid) {
            this.columnIndex = columnIndex;
            this.oid = oid;
            this.rowIndices.add(rowIndex);
        }

        public void addRowIndex(int rowIndex) {
            this.rowIndices.add(rowIndex);
        }

        public int getColumnIndex() {
            return this.columnIndex;
        }

        public Set<Integer> getRowIndices() {
            return this.rowIndices;
        }

        public long getOid() {
            return this.oid;
        }
    }
}

