/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common.utils;

import com.infinity.bpm.thirdparty.xsd.XSDNamedComponent;
import com.infinity.bpm.thirdparty.xsd.XSDSchema;
import com.infinity.bpm.thirdparty.xsd.XSDSimpleTypeDefinition;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.List;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stardust.common.FilteringIterator;
import org.eclipse.stardust.common.Pair;
import org.eclipse.stardust.common.Predicate;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.common.config.Parameters;
import org.eclipse.stardust.common.reflect.Reflect;
import org.eclipse.stardust.engine.api.model.IData;
import org.eclipse.stardust.engine.api.model.IDataType;
import org.eclipse.stardust.engine.api.model.IModel;
import org.eclipse.stardust.engine.api.model.ITypeDeclaration;
import org.eclipse.stardust.engine.api.model.PredefinedConstants;
import org.eclipse.stardust.engine.core.model.utils.ModelElementList;
import org.eclipse.stardust.engine.core.pojo.data.Type;
import org.eclipse.stardust.engine.core.struct.StructuredTypeRtUtils;
import org.eclipse.stardust.engine.core.struct.TypedXPath;
import org.eclipse.stardust.engine.core.struct.Utils;
import org.eclipse.stardust.reporting.common.GroupColumn;
import org.eclipse.stardust.reporting.common.IDataColumn;
import org.eclipse.stardust.reporting.common.Parameter;
import org.eclipse.stardust.reporting.common.ReportingCommon_Messages;
import org.eclipse.stardust.reporting.common.View;
import org.eclipse.stardust.reporting.common.utils.DateUtils;
import org.eclipse.stardust.reporting.common.worktime.CalendarBasedWorktimeCalculator;
import org.eclipse.stardust.reporting.common.worktime.IWorktimeCalculator;

public class ViewUtils {
    public static final String DB_WILDCARD_PCT = "%";
    public static final String[] SELECT_ALL_WILDCARDS_LIST = new String[]{"%", "*", ".*"};
    public static final String WORKFLOW_USER_SESSION_ID = "workflowUserSessionId";
    public static final String PORTAL_AUTHENTIFICATION = "portal_authentification";
    public static final String AUTHENTIFICATION_REQUIRED = "Reporting.AuthentificationRequired";

    public static boolean isAuthentificationRequired() {
        boolean authentificationRequired = Parameters.instance().getBoolean(AUTHENTIFICATION_REQUIRED, true);
        if (!authentificationRequired) {
            return false;
        }
        return ViewUtils.isPortalAuthentification();
    }

    private static boolean isPortalAuthentification() {
        boolean portalAuthentification = false;
        String portalAuthentificationParam = Parameters.instance().getString(PORTAL_AUTHENTIFICATION);
        if (StringUtils.isNotEmpty((String)portalAuthentificationParam)) {
            portalAuthentification = true;
        }
        return portalAuthentification;
    }

    public static String getWorkflowUserSessionId() {
        return Parameters.instance().getString(WORKFLOW_USER_SESSION_ID);
    }

    public static long converToLong(String s) {
        long returnValue = -1L;
        try {
            returnValue = Long.parseLong(s);
        }
        catch (Exception exception) {}
        return returnValue;
    }

    public static boolean isParameterSet(String parameter) {
        boolean parameterSet = false;
        if (StringUtils.isNotEmpty((String)parameter) && !ViewUtils.isSelectAllWildcard(parameter)) {
            parameterSet = true;
        }
        return parameterSet;
    }

    public static long determineModelOid(String modelOidParam, String modelIdParam) {
        long modelOid = -1L;
        if (ViewUtils.isParameterSet(modelOidParam)) {
            try {
                modelOid = Long.parseLong(modelOidParam);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return modelOid;
    }

    public static boolean isSelectAllWildcard(String parameter) {
        if (parameter != null) {
            String[] stringArray = SELECT_ALL_WILDCARDS_LIST;
            int n = SELECT_ALL_WILDCARDS_LIST.length;
            int n2 = 0;
            while (n2 < n) {
                String s = stringArray[n2];
                if (parameter.equals(s)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }

    public static Pair<Long, Long> getStartAndEnd(String startDateParam, String endDateParam) {
        Calendar endTimeCalendar = Calendar.getInstance();
        Calendar startTimeCalendar = Calendar.getInstance();
        if (StringUtils.isNotEmpty((String)startDateParam)) {
            Timestamp startTimeStamp = Timestamp.valueOf(startDateParam);
            startTimeCalendar.setTime(startTimeStamp);
        }
        if (StringUtils.isNotEmpty((String)endDateParam)) {
            Timestamp endTimeStamp = Timestamp.valueOf(endDateParam);
            endTimeCalendar.setTime(endTimeStamp);
        }
        if (endDateParam == null) {
            endTimeCalendar.setTime(startTimeCalendar.getTime());
            ViewUtils.setToYearEnd(endTimeCalendar);
        }
        if (startDateParam == null) {
            startTimeCalendar.setTime(endTimeCalendar.getTime());
            ViewUtils.setToYearStart(startTimeCalendar);
        }
        ViewUtils.setToDayStart(startTimeCalendar);
        ViewUtils.setToDayEnd(endTimeCalendar);
        Pair startEndPair = new Pair((Object)startTimeCalendar.getTimeInMillis(), (Object)endTimeCalendar.getTimeInMillis());
        return startEndPair;
    }

    private static void setToYearEnd(Calendar toModify) {
        int lastMonth = toModify.getActualMaximum(2);
        toModify.set(2, lastMonth);
        int lastDayOfMonth = toModify.getActualMaximum(5);
        toModify.set(5, lastDayOfMonth);
    }

    private static void setToYearStart(Calendar toModify) {
        toModify.set(2, 0);
        toModify.set(5, 1);
    }

    private static void setToDayStart(Calendar toModify) {
        toModify.set(11, 0);
        toModify.set(12, 0);
        toModify.set(13, 0);
        toModify.set(14, 0);
    }

    private static void setToDayEnd(Calendar toModify) {
        toModify.set(11, 23);
        toModify.set(12, 59);
        toModify.set(13, 59);
        toModify.set(14, 999);
    }

    private static String addTimeValue(String dateValue, String timeValue) {
        StringBuffer buffer = new StringBuffer(dateValue.trim());
        buffer.append(' ').append(timeValue.trim());
        return buffer.toString();
    }

    public static Parameter findParameterByName(View view, String parameterName) {
        return view.getParameterByName(parameterName);
    }

    public static GroupColumn findColumnByName(View view, String columnName) {
        return view.findGroupColumnByName(columnName);
    }

    public static Pair validateParameterExpression(View view, String parameterExpression) {
        Parameter parameter;
        String trimmedExpression = parameterExpression.substring(2, parameterExpression.length() - 1);
        if (!trimmedExpression.startsWith("DataSetParameter.")) {
            throw new RuntimeException(NLS.bind((String)ReportingCommon_Messages.UnknownExpression, (Object)parameterExpression));
        }
        String currentParameter = trimmedExpression.substring("DataSetParameter.".length());
        String method = "";
        int indexOf = currentParameter.lastIndexOf(".");
        if (-1 != indexOf) {
            method = currentParameter.substring(indexOf + 1);
            currentParameter = currentParameter.substring(0, indexOf);
        }
        if ((parameter = view.getParameterByName(currentParameter)) == null) {
            throw new RuntimeException(NLS.bind((String)ReportingCommon_Messages.UnknownParameterReferencedByExpression, (Object)parameterExpression));
        }
        if (Timestamp.class == parameter.getType()) {
            if (!"toString()".equals(method) && !"getTime()".equals(method)) {
                throw new RuntimeException(NLS.bind((String)ReportingCommon_Messages.CurrentlyParametersOfTypeHaveToGetCalledMethodsOrOnIt, (Object)parameter.getType(), (Object)parameterExpression));
            }
        } else if (!StringUtils.isEmpty((String)method)) {
            throw new RuntimeException(NLS.bind((String)ReportingCommon_Messages.CurrentlyNoMethodCallsAreSupportedForParametersOfType, (Object)parameter.getType(), (Object)parameterExpression));
        }
        return new Pair((Object)parameter, (Object)method);
    }

    public static List getDataColumns(View view) {
        ArrayList dataColumns = new ArrayList();
        FilteringIterator dataColumnsIter = new FilteringIterator(view.getGroupColumns().iterator(), new Predicate(){

            public boolean accept(Object o) {
                GroupColumn groupColumn = (GroupColumn)o;
                return !groupColumn.isPredefined() && groupColumn instanceof IDataColumn;
            }
        });
        while (dataColumnsIter.hasNext()) {
            dataColumns.add(dataColumnsIter.next());
        }
        return dataColumns;
    }

    private ViewUtils() {
    }

    public static String replaceDateWithTimeInMillis(String expressionString) {
        if (DateUtils.isDate(expressionString)) {
            expressionString = "" + DateUtils.getTimeInMillis(expressionString);
        } else {
            String[] expressionStrings = null;
            if (expressionString.indexOf("'") >= 0) {
                expressionStrings = expressionString.split("'");
            } else if (expressionString.indexOf("\"") >= 0) {
                expressionStrings = expressionString.split("\"");
            }
            if (expressionStrings != null) {
                String[] stringArray = expressionStrings;
                int n = expressionStrings.length;
                int n2 = 0;
                while (n2 < n) {
                    String rawExpression = stringArray[n2];
                    String expression = rawExpression;
                    if (expression.indexOf("'") >= 0) {
                        expression = expression.replaceAll("'", "");
                    } else if (expression.indexOf("\"") >= 0) {
                        expression = expression.replaceAll("\"", "");
                    } else {
                        rawExpression = "'" + rawExpression + "'";
                    }
                    if (DateUtils.isDate(expression)) {
                        expressionString = StringUtils.replace((String)expressionString, (String)rawExpression, (String)String.valueOf(DateUtils.getTimeInMillis(expression)));
                    }
                    ++n2;
                }
            }
        }
        return expressionString;
    }

    public static Class<? extends IWorktimeCalculator> getWorktimeCalculatorClass(String className) {
        Class<Object> calculatorClass = null;
        try {
            calculatorClass = Class.forName(className);
        }
        catch (Exception exception) {
            calculatorClass = CalendarBasedWorktimeCalculator.class;
        }
        return calculatorClass;
    }

    public static void checkParameterRange(int parameterIndex, Object[] parameterValues) throws OdaException {
        int index = parameterIndex - 1;
        if (index < 0 || index > parameterValues.length) {
            Object[] msgArgs = new Object[]{index, parameterValues.length};
            String errorMsg = NLS.bind((String)ReportingCommon_Messages.ParameterAtIndexIsOutOfBounds, (Object[])msgArgs);
            throw new OdaException(errorMsg);
        }
    }

    public static boolean isPrimitiveData(IData data) {
        return "primitive".equals(data.getType().getId());
    }

    public static boolean isStructuredData(IData data) {
        return StructuredTypeRtUtils.isStructuredType((String)data.getType().getId());
    }

    public static boolean isStructuredEnumData(IData selectedData) {
        IModel model = (IModel)selectedData.getModel();
        IDataType dataType = (IDataType)selectedData.getType();
        if (StructuredTypeRtUtils.isStructuredType((String)dataType.getId())) {
            String typeDeclarationId = (String)selectedData.getAttribute("carnot:engine:dataType");
            IModel m = (IModel)selectedData.getModel();
            ModelElementList typeDeclarations = m.getTypeDeclarations();
            int i = 0;
            while (i < typeDeclarations.size()) {
                XSDSchema xsdSchema;
                XSDNamedComponent typeDeclarationElement;
                ITypeDeclaration tmpTypeDeclaration = (ITypeDeclaration)typeDeclarations.get(i);
                if (tmpTypeDeclaration.getId().equals(typeDeclarationId) && (typeDeclarationElement = StructuredTypeRtUtils.findElementOrTypeDeclaration((XSDSchema)(xsdSchema = StructuredTypeRtUtils.getXSDSchema((IModel)model, (ITypeDeclaration)tmpTypeDeclaration)), (String)typeDeclarationId, (boolean)false)) instanceof XSDSimpleTypeDefinition) {
                    return true;
                }
                ++i;
            }
        }
        return false;
    }

    public static boolean isPredefinedData(IData data) {
        List predefinedDataTypes = PredefinedConstants.META_DATA_IDS;
        for (Object o : predefinedDataTypes) {
            if (!data.getId().equals(o.toString())) continue;
            return true;
        }
        return false;
    }

    public static Class getJavaType(TypedXPath typedXPath) {
        Class clazz = Utils.getJavaTypeForTypedXPath((TypedXPath)typedXPath);
        String xsdTypeName = typedXPath.getXsdTypeName();
        if ("date".equals(xsdTypeName)) {
            clazz = Date.class;
        } else if ("dateTime".equals(xsdTypeName)) {
            clazz = Timestamp.class;
        } else if ("time".equals(xsdTypeName)) {
            clazz = Time.class;
        }
        return clazz;
    }

    public static Class getJavaType(IData data) {
        Class javaType = null;
        if (ViewUtils.isStructuredData(data) && !ViewUtils.isStructuredEnumData(data)) {
            throw new RuntimeException("Getting sql type for structured data without xpath is not valid ");
        }
        if (ViewUtils.isStructuredEnumData(data)) {
            javaType = String.class;
        } else {
            Type dataType = (Type)data.getAttribute("carnot:engine:type");
            String dataTypeName = dataType.getName();
            javaType = Reflect.getClassFromAbbreviatedName((String)dataTypeName);
        }
        if (javaType == null) {
            throw new RuntimeException("Could not find javatype for: " + data);
        }
        return javaType;
    }
}

