/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common.utils.sql;

import java.util.ArrayList;
import java.util.List;
import org.eclipse.stardust.reporting.common.utils.sql.AbstractCondition;
import org.eclipse.stardust.reporting.common.utils.sql.AbstractSqlExpression;
import org.eclipse.stardust.reporting.common.utils.sql.CompareOperator;
import org.eclipse.stardust.reporting.common.utils.sql.DbUtils;
import org.eclipse.stardust.reporting.common.utils.sql.LogicalOperator;
import org.eclipse.stardust.reporting.common.utils.sql.SimpleCondition;

public abstract class ConditionAwareSqlExpression
extends AbstractSqlExpression {
    private List<AbstractCondition> conditions = new ArrayList<AbstractCondition>();

    public ConditionAwareSqlExpression AND(Object value1, CompareOperator operator, Object value2) {
        return this.addCondition(LogicalOperator.AND, value1, operator, value2);
    }

    public ConditionAwareSqlExpression OR(Object value1, CompareOperator operator, Object value2) {
        return this.addCondition(LogicalOperator.OR, value1, operator, value2);
    }

    public ConditionAwareSqlExpression addCondition(AbstractCondition condition) {
        this.conditions.add(condition);
        return this;
    }

    protected ConditionAwareSqlExpression addCondition(LogicalOperator logicalOperator, Object value1, CompareOperator compareOperator, Object value2) {
        String predicate = DbUtils.buildPredicate(value1, compareOperator, value2);
        SimpleCondition condition = new SimpleCondition(logicalOperator, predicate);
        this.conditions.add(condition);
        return this;
    }

    protected String getConditionString() {
        StringBuffer buffer = new StringBuffer();
        for (AbstractCondition condition : this.conditions) {
            buffer.append(condition);
        }
        String sqlString = buffer.toString();
        int index = sqlString.indexOf("(");
        sqlString = sqlString.substring(index);
        return sqlString;
    }

    @Override
    public abstract String getSql();
}

