/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common.utils.sql;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.eclipse.stardust.reporting.common.metadata.columns.DbColumn;
import org.eclipse.stardust.reporting.common.utils.sql.AbstractSqlExpression;

public class SortExpression
extends AbstractSqlExpression {
    private final SortType sortType;
    private List<DbColumn> columnsToSort = new ArrayList<DbColumn>();

    public SortExpression() {
        this.sortType = SortType.ASCENDING;
    }

    public SortExpression(SortType sortType) {
        this.sortType = sortType;
    }

    public void addColumnToSort(DbColumn column) {
        this.columnsToSort.add(column);
    }

    @Override
    public String getSql() {
        StringBuffer buffer = new StringBuffer();
        if (!this.columnsToSort.isEmpty()) {
            buffer.append(" ORDER BY ");
            Iterator<DbColumn> columnsIterator = this.columnsToSort.iterator();
            while (columnsIterator.hasNext()) {
                DbColumn column = columnsIterator.next();
                buffer.append(column);
                if (!columnsIterator.hasNext()) continue;
                buffer.append(", ");
            }
            buffer.append(" ");
            buffer.append((Object)this.sortType);
            buffer.append(" ");
        }
        return buffer.toString();
    }

    public static enum SortType {
        ASCENDING("ASC"),
        DESCENDING("DESC");

        private final String value;

        private SortType(String value) {
            this.value = value;
        }

        public String toString() {
            return this.value;
        }
    }
}

