/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.common.worktime;

import java.util.Calendar;
import java.util.Date;
import java.util.GregorianCalendar;
import org.eclipse.stardust.reporting.common.worktime.IWorktimeCalculator;

public abstract class AbstractCalendarBasedWorktimeCalculator
implements IWorktimeCalculator {
    private int workBeginHour;
    private int workEndHour;
    private String region;

    protected AbstractCalendarBasedWorktimeCalculator(int workBeginHour, int workEndHour) {
        this(workBeginHour, workEndHour, null);
    }

    protected AbstractCalendarBasedWorktimeCalculator(int workBeginHour, int workEndHour, String region) {
        this.workBeginHour = workBeginHour;
        this.workEndHour = workEndHour;
        this.region = region;
    }

    public String getRegion() {
        return this.region;
    }

    public int getWorkBeginHour() {
        return this.workBeginHour;
    }

    public int getWorkEndHour() {
        return this.workEndHour;
    }

    @Override
    public long calculateWorktime(Date startTimestamp, Date endTimestamp, String performerID) {
        GregorianCalendar startDate = new GregorianCalendar();
        GregorianCalendar currentDate = new GregorianCalendar();
        GregorianCalendar endDate = new GregorianCalendar();
        currentDate.setTime(startTimestamp);
        startDate.setTime(startTimestamp);
        endDate.setTime(endTimestamp);
        if (currentDate.get(1) == endDate.get(1) && currentDate.get(2) == endDate.get(2) && currentDate.get(5) == endDate.get(5)) {
            return (endTimestamp.getTime() - startTimestamp.getTime()) / 1000L;
        }
        int workingSecondsCount = 0;
        GregorianCalendar startDateWorkBegin = startDate;
        GregorianCalendar startDateWorkEnd = startDate;
        GregorianCalendar startDateDayEnd = startDate;
        GregorianCalendar endDateWorkBegin = endDate;
        GregorianCalendar endDateWorkEnd = endDate;
        GregorianCalendar endDateDayEnd = endDate;
        startDateWorkBegin.set(11, this.workBeginHour);
        startDateWorkEnd.set(11, this.workEndHour);
        startDateDayEnd.set(11, 24);
        endDateWorkBegin.set(11, this.workBeginHour);
        endDateWorkEnd.set(11, this.workEndHour);
        endDateDayEnd.set(11, 24);
        workingSecondsCount = this.compare(startDateWorkEnd, startDate) <= 0 ? (int)((long)workingSecondsCount + (startDateDayEnd.getTimeInMillis() - startDate.getTimeInMillis()) / 1000L) : (int)((long)workingSecondsCount + (startDateWorkEnd.getTimeInMillis() - startDate.getTimeInMillis()) / 1000L);
        workingSecondsCount = this.compare(endDateWorkEnd, endDate) <= 0 ? (int)((long)workingSecondsCount + (endDateDayEnd.getTimeInMillis() - endDate.getTimeInMillis()) / 1000L) : (int)((long)workingSecondsCount + (endDateWorkEnd.getTimeInMillis() - endDate.getTimeInMillis()) / 1000L);
        while (this.compare(currentDate, endDate) < 0) {
            currentDate.add(5, 1);
            if (this.isHoliday(currentDate)) continue;
            workingSecondsCount += (this.workEndHour - this.workBeginHour) * 60 * 60;
        }
        return workingSecondsCount;
    }

    protected boolean isWeekend(Calendar calendar) {
        return calendar.get(7) == 7 && calendar.get(7) == 1;
    }

    protected abstract boolean isHoliday(Calendar var1);

    private int compare(Calendar first, Calendar second) {
        long secondMillis;
        long firstMillis = first.getTimeInMillis();
        int result = firstMillis < (secondMillis = second.getTimeInMillis()) ? -1 : (firstMillis > secondMillis ? 1 : 0);
        return result;
    }
}

