/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.oda.common.impl;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.stardust.common.config.Parameters;
import org.eclipse.stardust.reporting.common.utils.ViewUtils;
import org.eclipse.stardust.reporting.oda.common.impl.ResultSetMetaData;

public class ResultSet
implements IResultSet {
    public static final String REALM_ID_KEY = "realmId";
    private int maxRows;
    private int currentRowId;
    private Map<String, String> parameterMapping = null;

    public IResultSetMetaData getMetaData() throws OdaException {
        return new ResultSetMetaData();
    }

    public void setMaxRows(int max) throws OdaException {
        this.maxRows = max;
    }

    protected int getMaxRows() {
        return this.maxRows;
    }

    public boolean next() throws OdaException {
        int maxRows = 1;
        if (this.currentRowId < maxRows) {
            ++this.currentRowId;
            return true;
        }
        return false;
    }

    public void close() throws OdaException {
        this.currentRowId = 0;
    }

    public int getRow() throws OdaException {
        return this.currentRowId;
    }

    public String getString(int index) throws OdaException {
        String modelOid = this.parameterMapping.get("ModelOID");
        String processId = this.parameterMapping.get("processId");
        String piOid = this.parameterMapping.get("processInstanceOid");
        String aiOid = this.parameterMapping.get("activityInstanceOid");
        String partitionId = Parameters.instance().getString("CARNOT_REPORTING_PARTITION");
        String realmId = Parameters.instance().getString(REALM_ID_KEY);
        String baseUrlKey = "INFINITY_REPORTING_DIAGRAM_BASE_URL";
        String defaultBaseUrl = "/eclipse/servlet/DiagramServlet";
        String baseUrl = Parameters.instance().getString(baseUrlKey, defaultBaseUrl);
        StringBuilder urlBuilder = new StringBuilder();
        urlBuilder.append(baseUrl);
        if (ViewUtils.isParameterSet((String)aiOid)) {
            urlBuilder.append("?activityInstanceOid=");
            urlBuilder.append(aiOid);
        } else if (ViewUtils.isParameterSet((String)piOid)) {
            urlBuilder.append("?processInstanceOid=");
            urlBuilder.append(piOid);
        } else {
            urlBuilder.append("?processId=");
            urlBuilder.append(processId);
            urlBuilder.append("&modelOid=");
            urlBuilder.append(modelOid);
        }
        urlBuilder.append("&partitionId=");
        urlBuilder.append(partitionId);
        urlBuilder.append("&").append(REALM_ID_KEY).append("=");
        urlBuilder.append(realmId);
        return urlBuilder.toString();
    }

    public String getString(String columnName) throws OdaException {
        return this.getString(this.findColumn(columnName));
    }

    public int getInt(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public int getInt(String columnName) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public double getDouble(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public double getDouble(String columnName) throws OdaException {
        return this.getDouble(this.findColumn(columnName));
    }

    public BigDecimal getBigDecimal(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public BigDecimal getBigDecimal(String columnName) throws OdaException {
        return this.getBigDecimal(this.findColumn(columnName));
    }

    public Date getDate(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public Date getDate(String columnName) throws OdaException {
        return this.getDate(this.findColumn(columnName));
    }

    public Time getTime(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public Time getTime(String columnName) throws OdaException {
        return this.getTime(this.findColumn(columnName));
    }

    public Timestamp getTimestamp(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public Timestamp getTimestamp(String columnName) throws OdaException {
        return this.getTimestamp(this.findColumn(columnName));
    }

    public IBlob getBlob(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public IBlob getBlob(String columnName) throws OdaException {
        return this.getBlob(this.findColumn(columnName));
    }

    public IClob getClob(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public IClob getClob(String columnName) throws OdaException {
        return this.getClob(this.findColumn(columnName));
    }

    public boolean getBoolean(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public boolean getBoolean(String columnName) throws OdaException {
        return this.getBoolean(this.findColumn(columnName));
    }

    public boolean wasNull() throws OdaException {
        return false;
    }

    public int findColumn(String columnName) throws OdaException {
        int columnId = 1;
        if (columnName == null || columnName.length() == 0) {
            return columnId;
        }
        String lastChar = columnName.substring(columnName.length() - 1, 1);
        try {
            columnId = Integer.parseInt(lastChar);
        }
        catch (NumberFormatException numberFormatException) {}
        return columnId;
    }

    public Object getObject(int index) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public Object getObject(String columnName) throws OdaException {
        throw new UnsupportedOperationException();
    }

    public void setParameterMapping(Map<String, String> parameterMapping) {
        this.parameterMapping = parameterMapping;
    }
}

