/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.oda.jdbc.ui.editors;

import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.datatools.connectivity.oda.IAdvancedQuery;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IParameterMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.datatools.connectivity.oda.design.DataSetDesign;
import org.eclipse.stardust.reporting.oda.jdbc.ui.editors.OdaConnectionProvider;

class MetaDataRetriever {
    private IResultSetMetaData resultMeta;
    private IParameterMetaData paramMeta;
    private IQuery query;
    private static Logger logger = Logger.getLogger(MetaDataRetriever.class.getName());

    MetaDataRetriever(OdaConnectionProvider odaConnectionProvider, DataSetDesign dataSetDesign) {
        try {
            IConnection connection = odaConnectionProvider.openConnection();
            this.query = connection.newQuery(dataSetDesign.getOdaExtensionDataSetId());
            this.query.prepare(dataSetDesign.getQueryText());
            try {
                this.paramMeta = this.query.getParameterMetaData();
            }
            catch (OdaException e) {
                logger.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
            if (!(this.query instanceof IAdvancedQuery)) {
                this.resultMeta = this.query.getMetaData();
            }
        }
        catch (OdaException e) {
            logger.log(Level.WARNING, e.getLocalizedMessage(), e);
        }
    }

    IParameterMetaData getParameterMetaData() {
        return this.paramMeta;
    }

    IResultSetMetaData getResultSetMetaData() {
        return this.resultMeta;
    }

    void close() {
        try {
            try {
                if (this.query != null) {
                    this.query.close();
                }
            }
            catch (OdaException odaException) {
                this.query = null;
            }
        }
        finally {
            this.query = null;
        }
    }
}

