/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.oda.jdbc.ui.model;

import org.eclipse.stardust.reporting.oda.jdbc.ui.JdbcPlugin;
import org.eclipse.stardust.reporting.oda.jdbc.ui.model.ChildrenAllowedNode;
import org.eclipse.stardust.reporting.oda.jdbc.ui.model.FilterConfig;
import org.eclipse.stardust.reporting.oda.jdbc.ui.model.IDBNode;
import org.eclipse.stardust.reporting.oda.jdbc.ui.model.RootNode;
import org.eclipse.swt.widgets.Tree;
import org.eclipse.swt.widgets.TreeItem;

public class DBNodeUtil {
    private DBNodeUtil() {
    }

    public static void createRootTip(Tree tree, RootNode node, String metadataBidiFormatStr) {
        tree.removeAll();
        TreeItem root = new TreeItem(tree, 0);
        root.setText(node.getDisplayName(metadataBidiFormatStr));
        root.setImage(node.getImage());
        root.setData((Object)node);
    }

    public static void createTreeRoot(Tree tree, RootNode node, FilterConfig fc, String metadataBidiFormatStr, long timeout) {
        tree.removeAll();
        TreeItem dummyItem = new TreeItem(tree, 0);
        dummyItem.setText(JdbcPlugin.getResourceString("tablepage.refreshing"));
        if (!node.isChildrenPrepared()) {
            node.prepareChildren(fc, timeout);
        }
        tree.removeAll();
        TreeItem root = new TreeItem(tree, 0);
        root.setText(node.getDisplayName(null));
        root.setImage(node.getImage());
        root.setData((Object)node);
        IDBNode[] children = node.getChildren();
        if (children != null) {
            IDBNode[] iDBNodeArray = children;
            int n = children.length;
            int n2 = 0;
            while (n2 < n) {
                IDBNode child = iDBNodeArray[n2];
                DBNodeUtil.createTreeItem(root, child, metadataBidiFormatStr);
                ++n2;
            }
        }
        root.setExpanded(true);
    }

    public static TreeItem createTreeItem(TreeItem parent, IDBNode node, String metadataBidiFormatStr) {
        TreeItem item = new TreeItem(parent, 0);
        item.setText(node.getDisplayName(metadataBidiFormatStr));
        item.setImage(node.getImage());
        item.setData((Object)node);
        item.setExpanded(false);
        if (node instanceof ChildrenAllowedNode) {
            if (((ChildrenAllowedNode)node).isChildrenPrepared()) {
                IDBNode[] children = ((ChildrenAllowedNode)node).getChildren();
                if (children != null) {
                    IDBNode[] iDBNodeArray = children;
                    int n = children.length;
                    int n2 = 0;
                    while (n2 < n) {
                        IDBNode child = iDBNodeArray[n2];
                        DBNodeUtil.createTreeItem(item, child, metadataBidiFormatStr);
                        ++n2;
                    }
                }
            } else {
                new TreeItem(item, 0);
            }
        }
        return item;
    }
}

