/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.oda.jdbc.ui.model;

import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.eclipse.jface.resource.ImageDescriptor;
import org.eclipse.jface.resource.ImageRegistry;
import org.eclipse.jface.resource.JFaceResources;
import org.eclipse.stardust.reporting.oda.jdbc.ui.JdbcPlugin;
import org.eclipse.stardust.reporting.oda.jdbc.ui.model.ChildrenAllowedNode;
import org.eclipse.stardust.reporting.oda.jdbc.ui.model.FilterConfig;
import org.eclipse.stardust.reporting.oda.jdbc.ui.model.IDBNode;
import org.eclipse.stardust.reporting.oda.jdbc.ui.model.ProcedureNode;
import org.eclipse.stardust.reporting.oda.jdbc.ui.provider.JdbcMetaDataProvider;
import org.eclipse.swt.graphics.Image;

public class ProcedureFlagNode
extends ChildrenAllowedNode {
    private static Logger logger = Logger.getLogger(ProcedureFlagNode.class.getName());
    private static String PROCEDURE_FLAG_ICON = String.valueOf(ProcedureFlagNode.class.getName()) + ".ProcedureFlagIcon";
    private String schemaName;

    static {
        ImageRegistry reg = JFaceResources.getImageRegistry();
        reg.put(PROCEDURE_FLAG_ICON, ImageDescriptor.createFromFile(JdbcPlugin.class, (String)"icons/table.gif"));
    }

    public ProcedureFlagNode(String schemaName) {
        this.schemaName = schemaName;
    }

    @Override
    public String getDisplayName(String metadataBidiFormatStr) {
        return "STORED PROCEDURES";
    }

    @Override
    public Image getImage() {
        return JFaceResources.getImage((String)PROCEDURE_FLAG_ICON);
    }

    @Override
    public String getQualifiedNameInSQL(boolean useIdentifierQuoteString, boolean includeSchema, String metadataBidiFormatStr) {
        return null;
    }

    @Override
    protected IDBNode[] refetchChildren(FilterConfig fc) {
        ResultSet rs = JdbcMetaDataProvider.getInstance().getProcedures(this.schemaName, fc.getNamePattern());
        ArrayList<ProcedureNode> procedures = new ArrayList<ProcedureNode>();
        if (rs != null) {
            try {
                while (rs.next()) {
                    String procedureName = rs.getString("PROCEDURE_NAME");
                    ProcedureNode procedure = new ProcedureNode(this.schemaName, procedureName);
                    procedures.add(procedure);
                }
            }
            catch (SQLException e) {
                logger.log(Level.WARNING, e.getLocalizedMessage(), e);
            }
        }
        return procedures.toArray(new ProcedureNode[0]);
    }
}

