/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.oda.jdbc.ui.util;

import java.sql.Connection;
import java.sql.SQLException;
import java.text.StringCharacterIterator;
import org.eclipse.birt.report.data.bidi.utils.core.BidiTransform;
import org.eclipse.birt.report.data.oda.jdbc.JDBCDriverManager;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.stardust.reporting.oda.jdbc.ui.JdbcPlugin;
import org.eclipse.stardust.reporting.oda.jdbc.ui.util.ExceptionHandler;
import org.eclipse.ui.PlatformUI;

public final class DriverLoader {
    private DriverLoader() {
    }

    public static Connection getConnection(String driverClassName, String connectionString, String userId, String password) throws SQLException, OdaException {
        return JDBCDriverManager.getInstance().getConnection(driverClassName, connectionString, userId, password, null);
    }

    public static Connection getConnectionWithExceptionTip(String driverClassName, String connectionString, String userId, String password) throws SQLException {
        try {
            return JDBCDriverManager.getInstance().getConnection(driverClassName, connectionString, userId, password, null);
        }
        catch (Exception e) {
            ExceptionHandler.showException(PlatformUI.getWorkbench().getDisplay().getActiveShell(), JdbcPlugin.getResourceString("exceptionHandler.title.error"), e.getLocalizedMessage(), e);
            return null;
        }
    }

    static String escapeCharacters(String value) {
        StringCharacterIterator iterator = new StringCharacterIterator(value);
        char character = iterator.current();
        StringBuffer result = new StringBuffer();
        while (character != '\uffff') {
            if (character == '\\') {
                result.append("\\");
            } else {
                result.append(character);
            }
            character = iterator.next();
        }
        return result.toString();
    }

    public static boolean testConnection(String driverClassName, String connectionString, String userId, String password) throws OdaException {
        return DriverLoader.testConnection(driverClassName, connectionString, null, userId, password);
    }

    public static boolean testConnection(String driverClassName, String connectionString, String jndiNameUrl, String userId, String password) throws OdaException {
        return JDBCDriverManager.getInstance().testConnection(driverClassName, connectionString, jndiNameUrl, userId, password);
    }

    public static boolean testConnection(String driverClassName, String connectionString, String jndiNameUrl, String userId, String password, String bidiFormatStr) throws OdaException {
        userId = BidiTransform.transform((String)userId, (String)"ILYNN", (String)bidiFormatStr);
        password = BidiTransform.transform((String)password, (String)"ILYNN", (String)bidiFormatStr);
        connectionString = BidiTransform.transformURL((String)connectionString, (String)"ILYNN", (String)bidiFormatStr);
        return DriverLoader.testConnection(driverClassName, connectionString, jndiNameUrl, userId, password);
    }
}

