/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.oda.model;

import com.ibm.icu.util.ULocale;
import java.util.List;
import java.util.Properties;
import javax.ejb.CreateException;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IDataSetMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.stardust.engine.api.model.IModel;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;
import org.eclipse.stardust.reporting.common.ProcessModelQueryService;
import org.eclipse.stardust.reporting.common.QueryServiceFactory;
import org.eclipse.stardust.reporting.common.utils.Tokenizer;
import org.eclipse.stardust.reporting.oda.model.DataSetMetaData;
import org.eclipse.stardust.reporting.oda.model.Query;

public class Connection
implements IConnection {
    private static Logger log = LogUtils.getLogger(Connection.class);
    private String jndiPath = null;
    private String modelFilePath = null;
    private boolean isOpen = false;
    private ProcessModelQueryService queryService;

    public void open(Properties connProperties) throws OdaException {
        LogUtils.enterApi((Logger)log, (Object)"open()");
        if (connProperties == null) {
            throw new OdaException("Connection.CONNECTION_PROPERTIES_MISSING");
        }
        this.jndiPath = connProperties.getProperty("HOME");
        log.debug((Object)("HOME-Property: " + this.jndiPath));
        Tokenizer tokenizer = new Tokenizer(this.jndiPath);
        this.jndiPath = tokenizer.getToken(0);
        this.modelFilePath = tokenizer.getToken(1);
        log.debug((Object)("JNDI-Path: " + this.jndiPath));
        log.debug((Object)("Model File Path: " + this.modelFilePath));
        try {
            this.queryService = QueryServiceFactory.getInstance().createProcessModelQueryService(this.modelFilePath);
        }
        catch (CreateException e) {
            log.error((Object)e);
            throw new OdaException(e.getLocalizedMessage());
        }
        this.isOpen = true;
        LogUtils.exitApi((Logger)log, (Object)"open()");
    }

    protected IModel getModel(Object[] parameterValues) {
        return this.queryService.getModel(parameterValues);
    }

    protected List<IModel> getActiveModels() {
        return this.queryService.getActiveModels();
    }

    public ProcessModelQueryService getQueryService() {
        return this.queryService;
    }

    public void setAppContext(Object context) throws OdaException {
        log.debug((Object)"setAppContext()");
    }

    public void close() throws OdaException {
        log.debug((Object)"close()");
        this.jndiPath = null;
        this.isOpen = false;
    }

    public boolean isOpen() throws OdaException {
        log.debug((Object)"isOpen()");
        return this.isOpen;
    }

    public IDataSetMetaData getMetaData(String dataSetType) throws OdaException {
        LogUtils.enterApi((Logger)log, (Object)"getMetaData()");
        try {
            DataSetMetaData dataSetMetaData = new DataSetMetaData(this);
            return dataSetMetaData;
        }
        finally {
            LogUtils.exitApi((Logger)log, (Object)"getMetaData()");
        }
    }

    public IQuery newQuery(String dataSourceType) throws OdaException {
        LogUtils.enterApi((Logger)log, (Object)"newQuery()");
        try {
            if (!this.isOpen()) {
                throw new OdaException("Common.CONNECTION_HAS_NOT_OPEN");
            }
            Query query = new Query(this.jndiPath, this);
            return query;
        }
        finally {
            LogUtils.exitApi((Logger)log, (Object)"newQuery()");
        }
    }

    public void commit() throws OdaException {
        log.debug((Object)"commit()");
        throw new UnsupportedOperationException();
    }

    public void rollback() throws OdaException {
        log.debug((Object)"rollback()");
        throw new UnsupportedOperationException();
    }

    public int getMaxQueries() throws OdaException {
        log.debug((Object)"getMaxQueries()");
        return 0;
    }

    public void setLocale(ULocale locale) throws OdaException {
    }
}

