/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.oda.model;

import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.stardust.reporting.common.metamodel.Attribute;
import org.eclipse.stardust.reporting.common.metamodel.Node;
import org.eclipse.stardust.reporting.common.metamodel.Path;
import org.eclipse.stardust.reporting.oda.model.DataTypes;
import org.eclipse.stardust.reporting.oda.model.ProcessModel_Messages;

public class ResultSetMetaData
implements IResultSetMetaData {
    private String[] columnNames = null;
    private String[] columnTypeNames = null;
    private String[] columnLabels = null;

    public ResultSetMetaData(Path path) {
        if (path.getTop() != null) {
            Node topNode = path.getTop().getLink().getToNode();
            int attributesSize = topNode.getAttributes().size();
            this.columnNames = new String[attributesSize];
            this.columnTypeNames = new String[attributesSize];
            this.columnLabels = new String[attributesSize];
            int n = 0;
            while (n < attributesSize) {
                Attribute attribute = (Attribute)topNode.getAttributes().get(n);
                this.columnNames[n] = attribute.getID();
                this.columnTypeNames[n] = attribute.getType().getName();
                this.columnLabels[n] = attribute.getLabel();
                ++n;
            }
        } else {
            this.columnNames = new String[0];
            this.columnTypeNames = new String[0];
            this.columnLabels = new String[0];
        }
    }

    protected String[] getColumnLabels() {
        return this.columnLabels;
    }

    protected String[] getColumnNames() {
        return this.columnNames;
    }

    protected String[] getColumnTypeNames() {
        return this.columnTypeNames;
    }

    public int getColumnCount() throws OdaException {
        return this.columnNames.length;
    }

    public String getColumnName(int index) throws OdaException {
        this.validateColumnIndex(index);
        return this.columnNames[index - 1].trim();
    }

    public String getColumnLabel(int index) throws OdaException {
        this.validateColumnIndex(index);
        if (this.columnLabels == null || this.columnLabels[index - 1].equals("null")) {
            return this.getColumnName(index);
        }
        return this.columnLabels[index - 1].trim();
    }

    public int getColumnType(int index) throws OdaException {
        this.validateColumnIndex(index);
        return this.columnTypeNames == null ? 0 : DataTypes.getTypeCode(this.columnTypeNames[index - 1]);
    }

    public String getColumnTypeName(int index) throws OdaException {
        this.validateColumnIndex(index);
        return this.columnTypeNames == null ? "NULL" : this.columnTypeNames[index - 1].trim();
    }

    public int getColumnDisplayLength(int index) throws OdaException {
        return 32;
    }

    public int getPrecision(int index) throws OdaException {
        return -1;
    }

    public int getScale(int index) throws OdaException {
        return -1;
    }

    public int isNullable(int index) throws OdaException {
        return 2;
    }

    private void validateColumnIndex(int index) throws OdaException {
        if (index > this.getColumnCount() || index < 1) {
            throw new OdaException(String.valueOf(ProcessModel_Messages.InvalidColumnIndex) + index);
        }
    }
}

