/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.oda.processes;

import com.ibm.icu.util.ULocale;
import java.util.Enumeration;
import java.util.Properties;
import javax.ejb.CreateException;
import org.eclipse.datatools.connectivity.oda.IConnection;
import org.eclipse.datatools.connectivity.oda.IDataSetMetaData;
import org.eclipse.datatools.connectivity.oda.IQuery;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.stardust.common.StringUtils;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;
import org.eclipse.stardust.reporting.common.ProcessDatabaseQueryService;
import org.eclipse.stardust.reporting.common.QueryServiceFactory;
import org.eclipse.stardust.reporting.common.utils.EncodingChecker;
import org.eclipse.stardust.reporting.common.utils.Tokenizer;
import org.eclipse.stardust.reporting.oda.processes.DataSetMetaData;
import org.eclipse.stardust.reporting.oda.processes.ProcessDatabase_Messages;
import org.eclipse.stardust.reporting.oda.processes.Query;

public class Connection
implements IConnection {
    private static final Logger log = LogUtils.getLogger(Connection.class);
    private String jndiPath;
    private String modelFilePath;
    private String dataSourceName;
    private String driverClassName;
    private String databaseURL;
    private String databaseAccount;
    private String databasePassword;
    private String databasePartition;
    private String databaseDefaultSchema;
    private String schemaPatterns;
    private String worktimeCalculatorClassName;
    private boolean isOpen = false;
    private ProcessDatabaseQueryService queryService;

    public void open(Properties connProperties) throws OdaException {
        LogUtils.enterApi((Logger)log, (Object)"open()");
        if (connProperties == null) {
            throw new OdaException(ProcessDatabase_Messages.ConnectionPropertiesMissing);
        }
        Enumeration<Object> e = connProperties.keys();
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            log.debug((Object)("Property " + key + ": " + connProperties.getProperty(key)));
        }
        this.jndiPath = connProperties.getProperty("HOME");
        log.debug((Object)("JNDI-Path: " + this.jndiPath));
        Tokenizer tokenizer = new Tokenizer(this.jndiPath);
        this.jndiPath = tokenizer.getToken(0);
        this.modelFilePath = null;
        this.dataSourceName = tokenizer.getToken(2);
        this.driverClassName = tokenizer.getToken(3);
        this.databaseURL = tokenizer.getToken(4);
        this.databaseAccount = tokenizer.getToken(5);
        this.databasePassword = "";
        String checkedPassword = EncodingChecker.instance().checkDecoding(tokenizer.getToken(6));
        if (!StringUtils.isEmpty((String)checkedPassword)) {
            this.databasePassword = checkedPassword;
        }
        this.schemaPatterns = tokenizer.getToken(7);
        this.worktimeCalculatorClassName = tokenizer.getToken(8);
        this.databaseDefaultSchema = tokenizer.getToken(9);
        this.databasePartition = tokenizer.getToken(10);
        log.debug((Object)("JNDI-Path: " + this.jndiPath));
        log.debug((Object)("Model File Path: " + this.modelFilePath));
        log.debug((Object)("Datasource Name: " + this.dataSourceName));
        log.debug((Object)("Driver Class Name: " + this.driverClassName));
        log.debug((Object)("Database URL: " + this.databaseURL));
        log.debug((Object)("Database Account: " + this.databaseAccount));
        log.debug((Object)("Database Partition: " + this.databasePartition));
        log.debug((Object)("Database Default Schema: " + this.databaseDefaultSchema));
        log.debug((Object)("Schema Patterns: " + this.schemaPatterns));
        log.debug((Object)("Worktime Calculator: " + this.worktimeCalculatorClassName));
        log.debug((Object)("Worktime Calculator Class Name: " + this.worktimeCalculatorClassName));
        try {
            this.queryService = QueryServiceFactory.getInstance().createProcessDatabaseQueryService(this.dataSourceName, this.driverClassName, this.databaseURL, this.databaseAccount, this.databasePassword, this.databasePartition, this.databaseDefaultSchema, this.schemaPatterns, this.worktimeCalculatorClassName);
        }
        catch (CreateException x) {
            log.error((Object)x);
            throw new OdaException(x.getLocalizedMessage());
        }
        this.isOpen = true;
        LogUtils.exitApi((Logger)log, (Object)"open()");
    }

    public ProcessDatabaseQueryService getQueryService() {
        log.debug((Object)"getQueryService()");
        return this.queryService;
    }

    public void setAppContext(Object context) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)("setAppContext(" + context + ")"));
        }
    }

    public void close() throws OdaException {
        log.debug((Object)"close()");
        this.jndiPath = null;
        this.isOpen = false;
    }

    public boolean isOpen() throws OdaException {
        log.debug((Object)"isOpen()");
        return this.isOpen;
    }

    public IDataSetMetaData getMetaData(String dataSetType) throws OdaException {
        LogUtils.enterApi((Logger)log, (Object)"getMetaData()");
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("=> getMetaData(" + dataSetType + ")"));
            }
            DataSetMetaData dataSetMetaData = new DataSetMetaData(this);
            return dataSetMetaData;
        }
        finally {
            LogUtils.exitApi((Logger)log, (Object)"getMetaData()");
        }
    }

    public IQuery newQuery(String dataSourceType) throws OdaException {
        LogUtils.enterApi((Logger)log, (Object)"newQuery()");
        try {
            if (log.isDebugEnabled()) {
                log.debug((Object)("newQuery(" + dataSourceType + ")"));
            }
            if (!this.isOpen()) {
                throw new OdaException(ProcessDatabase_Messages.ConnectionNotOpen);
            }
            Query query = new Query(this.jndiPath, this);
            return query;
        }
        finally {
            LogUtils.exitApi((Logger)log, (Object)"getMetaData()");
        }
    }

    public void commit() throws OdaException {
        log.debug((Object)"commit()");
        throw new UnsupportedOperationException();
    }

    public void rollback() throws OdaException {
        log.debug((Object)"rollback()");
        throw new UnsupportedOperationException();
    }

    public int getMaxQueries() throws OdaException {
        log.debug((Object)"getMaxQueries()");
        return 0;
    }

    public void setLocale(ULocale locale) throws OdaException {
    }
}

