/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.oda.processes;

import java.math.BigDecimal;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import java.text.DateFormat;
import java.text.MessageFormat;
import java.text.ParseException;
import java.util.Locale;
import org.eclipse.datatools.connectivity.oda.IBlob;
import org.eclipse.datatools.connectivity.oda.IClob;
import org.eclipse.datatools.connectivity.oda.IResultSet;
import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stardust.reporting.common.LogUtils;
import org.eclipse.stardust.reporting.common.Logger;
import org.eclipse.stardust.reporting.oda.processes.ProcessDatabase_Messages;
import org.eclipse.stardust.reporting.oda.processes.Query;
import org.eclipse.stardust.reporting.oda.processes.ResultSetMetaData;

public class ResultSet
implements IResultSet {
    private static final Logger log = LogUtils.getLogger(Query.class);
    public static final int DEFAULT_MAX_ROWS = 1000;
    private static final int CURSOR_INITIAL_VALUE = -1;
    private static final int CURSOR_RUN_THROUGH = -2;
    private Object[][] sourceData = null;
    private IResultSetMetaData resultSetMetaData = null;
    private int maxRows = 0;
    private int cursor = -1;
    private boolean wasNull = false;

    ResultSet(Object[][] sData) {
        LogUtils.enterInternal((Logger)log, (Object)"ResultSet()");
        if (sData != null && sData.length != 0 && sData[0].length != 0) {
            if (log.isDebugEnabled()) {
                log.debug((Object)("Creating result set from row set [" + sData.length + ", " + sData[0].length + "]"));
            }
        } else {
            log.debug((Object)"Creating result for empty row set.");
        }
        this.sourceData = sData;
        this.resultSetMetaData = null;
        LogUtils.exitInternal((Logger)log, (Object)"ResultSet()");
    }

    protected void setMetaData(ResultSetMetaData metaData) {
        log.debug((Object)"setMetaData()");
        this.resultSetMetaData = metaData;
    }

    public IResultSetMetaData getMetaData() throws OdaException {
        log.debug((Object)"setMetaData()");
        return this.resultSetMetaData;
    }

    public void close() throws OdaException {
        log.debug((Object)"setMetaData()");
        this.cursor = -2;
        this.sourceData = null;
        this.resultSetMetaData = null;
    }

    public void setMaxRows(int max) throws OdaException {
        log.debug((Object)"setMetaData()");
        this.maxRows = max;
    }

    public boolean next() throws OdaException {
        log.debug((Object)"next()");
        if (-2 == this.cursor) {
            return false;
        }
        if (this.maxRows > 0 && this.cursor >= this.maxRows - 1 || this.cursor >= this.sourceData.length - 1) {
            this.cursor = -2;
            return false;
        }
        ++this.cursor;
        return true;
    }

    public int getRow() throws OdaException {
        log.debug((Object)"getRow()");
        this.validateCursorState();
        return this.cursor;
    }

    public boolean getBoolean(int index) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("getBoolean({0})", new Integer(index)));
        }
        return Boolean.parseBoolean(this.getString(index));
    }

    public boolean getBoolean(String columnName) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("getBoolean({0})", columnName));
        }
        return Boolean.parseBoolean(this.getString(columnName));
    }

    public String getString(int index) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("getString({0})", new Integer(index)));
        }
        this.validateCursorState();
        if (this.sourceData[this.cursor].length < index) {
            return null;
        }
        Object result = this.sourceData[this.cursor][index - 1];
        if (result == null || result.toString().length() == 0) {
            this.wasNull = true;
            log.debug((Object)"Value is null.");
            return null;
        }
        this.wasNull = false;
        log.debug((Object)("Value is " + result.toString() + "."));
        return result.toString();
    }

    public String getString(String columnName) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("getString({0})", columnName));
        }
        this.validateCursorState();
        int columnIndex = this.findColumn(columnName);
        return this.getString(columnIndex);
    }

    public int getInt(int index) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("getInt({0})", new Integer(index)));
        }
        return this.stringToInt(this.getString(index));
    }

    public int getInt(String columnName) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("getInt({0})", columnName));
        }
        return this.stringToInt(this.getString(columnName));
    }

    public double getDouble(int index) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("getDouble({0})", new Integer(index)));
        }
        return this.stringToDouble(this.getString(index));
    }

    public double getDouble(String columnName) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("getDouble({0})", columnName));
        }
        return this.stringToDouble(this.getString(columnName));
    }

    public BigDecimal getBigDecimal(int index) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("getBigDecimal({0})", new Integer(index)));
        }
        return this.stringToBigDecimal(this.getString(index));
    }

    public BigDecimal getBigDecimal(String columnName) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("getBigDecimal({0})", columnName));
        }
        return this.stringToBigDecimal(this.getString(columnName));
    }

    public Date getDate(int index) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("getDate({0})", new Integer(index)));
        }
        Date date = null;
        Object result = this.sourceData[this.cursor][index - 1];
        if (log.isDebugEnabled()) {
            log.debug((Object)("Retrieving date: " + result));
        }
        if (result instanceof Date) {
            date = (Date)result;
            this.wasNull = false;
        } else if (result instanceof Long) {
            date = new Date((Long)result);
            this.wasNull = false;
        }
        return date;
    }

    public Date getDate(String columnName) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("getDate({0})", columnName));
        }
        return this.stringToDate(this.getString(columnName));
    }

    public Time getTime(int index) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("getTime({0})", new Integer(index)));
        }
        Time time = null;
        Object result = this.sourceData[this.cursor][index - 1];
        if (result instanceof Long) {
            time = new Time((Long)result);
            this.wasNull = false;
        } else if (result instanceof Timestamp) {
            time = (Time)result;
            this.wasNull = false;
        }
        return time;
    }

    public Time getTime(String columnName) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("getTime({0})", columnName));
        }
        return this.stringToTime(this.getString(columnName));
    }

    public Timestamp getTimestamp(int index) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("getTimestamp({0})", new Integer(index)));
        }
        this.validateCursorState();
        if (this.sourceData[this.cursor].length < index) {
            return null;
        }
        Timestamp timestamp = null;
        Object result = this.sourceData[this.cursor][index - 1];
        if (result instanceof Long) {
            timestamp = new Timestamp((Long)result);
            this.wasNull = false;
        } else if (result instanceof Timestamp) {
            timestamp = (Timestamp)result;
            this.wasNull = false;
        }
        return timestamp;
    }

    public Timestamp getTimestamp(String columnName) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("getTimestamp({0})", columnName));
        }
        return this.stringToTimestamp(this.getString(columnName));
    }

    public Object getObject(int index) throws OdaException {
        if (this.sourceData[this.cursor].length < index) {
            return null;
        }
        Object result = this.sourceData[this.cursor][index - 1];
        return result;
    }

    public Object getObject(String columnName) throws OdaException {
        int columnIndex = this.findColumn(columnName);
        return this.getObject(columnIndex);
    }

    public IBlob getBlob(int index) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("getBlob({0})", new Integer(index)));
        }
        throw new UnsupportedOperationException();
    }

    public IBlob getBlob(String columnName) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("getBlob({0})", columnName));
        }
        throw new UnsupportedOperationException();
    }

    public IClob getClob(int index) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("getClob({0})", new Integer(index)));
        }
        throw new UnsupportedOperationException();
    }

    public IClob getClob(String columnName) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("getClob({0})", columnName));
        }
        throw new UnsupportedOperationException();
    }

    public boolean wasNull() throws OdaException {
        log.debug((Object)"wasNull()");
        return this.wasNull;
    }

    public int findColumn(String columnName) throws OdaException {
        if (log.isDebugEnabled()) {
            log.debug((Object)MessageFormat.format("getString({0})", columnName));
        }
        String trimmedColumnName = columnName.trim();
        int columnCount = this.getMetaData().getColumnCount();
        int i = 1;
        while (i <= columnCount) {
            if (trimmedColumnName.equalsIgnoreCase(this.getMetaData().getColumnName(i))) {
                return i;
            }
            ++i;
        }
        String errorMsg = NLS.bind((String)ProcessDatabase_Messages.ColumnNotFound, (Object)columnName);
        throw new OdaException(errorMsg);
    }

    private void validateCursorState() throws OdaException {
        LogUtils.enterInternal((Logger)log, (Object)"validateCursorState()");
        try {
            if (this.cursor < 0) {
                throw new OdaException(ProcessDatabase_Messages.CursorNotInitialized);
            }
        }
        finally {
            LogUtils.exitInternal((Logger)log, (Object)"validateCursorState()");
        }
    }

    private int stringToInt(String stringValue) {
        if (stringValue != null) {
            try {
                return new Integer(stringValue);
            }
            catch (NumberFormatException numberFormatException) {
                this.wasNull = true;
            }
        }
        return 0;
    }

    private double stringToDouble(String stringValue) {
        log.debug((Object)("=> stringToDouble(" + stringValue + ")"));
        if (stringValue != null) {
            try {
                return new Double(stringValue);
            }
            catch (NumberFormatException numberFormatException) {
                this.wasNull = true;
            }
        }
        return 0.0;
    }

    private BigDecimal stringToBigDecimal(String stringValue) {
        log.debug((Object)("=> stringToBigDecimal(" + stringValue + ")"));
        if (stringValue != null) {
            try {
                return new BigDecimal(stringValue);
            }
            catch (NumberFormatException numberFormatException) {
                this.wasNull = true;
            }
        }
        return null;
    }

    private Date stringToDate(String stringValue) {
        if (stringValue != null) {
            try {
                return Date.valueOf(stringValue);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    return new Date(this.stringToLongDate(stringValue));
                }
                catch (ParseException parseException) {
                    this.wasNull = true;
                }
            }
        }
        return null;
    }

    private Time stringToTime(String stringValue) {
        if (stringValue != null) {
            try {
                return Time.valueOf(stringValue);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                try {
                    return new Time(this.stringToLongDate(stringValue));
                }
                catch (ParseException parseException) {
                    this.wasNull = true;
                }
            }
        }
        return null;
    }

    private Timestamp stringToTimestamp(String stringValue) {
        if (stringValue != null) {
            try {
                return Timestamp.valueOf(stringValue);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                this.wasNull = true;
            }
        }
        return null;
    }

    private long stringToLongDate(String stringValue) throws ParseException {
        DateFormat dateFormat = null;
        java.util.Date resultDate = null;
        try {
            dateFormat = DateFormat.getDateTimeInstance(3, 2);
            resultDate = dateFormat.parse(stringValue);
        }
        catch (ParseException parseException) {
            try {
                dateFormat = DateFormat.getDateTimeInstance(3, 2, Locale.US);
                resultDate = dateFormat.parse(stringValue);
            }
            catch (ParseException parseException2) {}
        }
        if (resultDate == null) {
            try {
                dateFormat = DateFormat.getDateTimeInstance(3, 3);
                resultDate = dateFormat.parse(stringValue);
            }
            catch (ParseException parseException) {
                try {
                    dateFormat = DateFormat.getDateTimeInstance(3, 3, Locale.US);
                    resultDate = dateFormat.parse(stringValue);
                }
                catch (ParseException parseException3) {}
            }
        }
        if (resultDate == null) {
            try {
                dateFormat = DateFormat.getTimeInstance(2);
                resultDate = dateFormat.parse(stringValue);
            }
            catch (ParseException parseException) {}
        }
        if (resultDate == null) {
            try {
                dateFormat = DateFormat.getDateInstance(3);
                resultDate = dateFormat.parse(stringValue);
            }
            catch (ParseException parseException) {
                dateFormat = DateFormat.getDateInstance(3, Locale.US);
                resultDate = dateFormat.parse(stringValue);
            }
        }
        return resultDate.getTime();
    }
}

