/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.stardust.reporting.oda.processes;

import org.eclipse.datatools.connectivity.oda.IResultSetMetaData;
import org.eclipse.datatools.connectivity.oda.OdaException;
import org.eclipse.osgi.util.NLS;
import org.eclipse.stardust.reporting.oda.processes.DataTypes;
import org.eclipse.stardust.reporting.oda.processes.ProcessDatabase_Messages;

public class ResultSetMetaData
implements IResultSetMetaData {
    private String viewName = null;
    private String[] columnNames = null;
    private String[] columnTypeNames = null;
    private String[] columnLabels = null;

    public ResultSetMetaData(String viewName, String[] colNames, String[] colTypes, String[] colLabels) {
        this.viewName = viewName;
        this.columnNames = colNames;
        this.columnTypeNames = colTypes;
        this.columnLabels = colLabels;
    }

    public String getViewName() {
        return this.viewName;
    }

    protected String[] getColumnLabels() {
        return this.columnLabels;
    }

    protected String[] getColumnNames() {
        return this.columnNames;
    }

    protected String[] getColumnTypeNames() {
        return this.columnTypeNames;
    }

    public int getColumnCount() throws OdaException {
        return this.columnNames.length;
    }

    public String getColumnName(int index) throws OdaException {
        this.validateColumnIndex(index);
        return this.columnNames[index - 1].trim();
    }

    public String getColumnLabel(int index) throws OdaException {
        this.validateColumnIndex(index);
        if (this.columnLabels == null || this.columnLabels[index - 1].equals("null")) {
            return this.getColumnName(index);
        }
        return this.columnLabels[index - 1].trim();
    }

    public int getColumnType(int index) throws OdaException {
        this.validateColumnIndex(index);
        return this.columnTypeNames == null ? 0 : DataTypes.getTypeCode(this.columnTypeNames[index - 1]);
    }

    public String getColumnTypeName(int index) throws OdaException {
        this.validateColumnIndex(index);
        return this.columnTypeNames == null ? "NULL" : this.columnTypeNames[index - 1].trim();
    }

    public int getColumnDisplayLength(int index) throws OdaException {
        return 32;
    }

    public int getPrecision(int index) throws OdaException {
        return -1;
    }

    public int getScale(int index) throws OdaException {
        return -1;
    }

    public int isNullable(int index) throws OdaException {
        return 2;
    }

    private void validateColumnIndex(int index) throws OdaException {
        if (index > this.getColumnCount() || index < 1) {
            String errorMsg = NLS.bind((String)ProcessDatabase_Messages.InvalidColumnIndex, (Object)index);
            throw new OdaException(errorMsg);
        }
    }
}

