/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.ImageList;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.widgets.Display;

public class ImageTransfer
extends ByteArrayTransfer {
    private static ImageTransfer _instance = new ImageTransfer();
    private static final String JPEG = "image/jpeg";
    private static final int JPEG_ID = Transfer.registerType("image/jpeg");
    private static final String PNG = "image/png";
    private static final int PNG_ID = Transfer.registerType("image/png");
    private static final String BMP = "image/bmp";
    private static final int BMP_ID = Transfer.registerType("image/bmp");
    private static final String EPS = "image/eps";
    private static final int EPS_ID = Transfer.registerType("image/eps");
    private static final String PCX = "image/pcx";
    private static final int PCX_ID = Transfer.registerType("image/pcx");
    private static final String PPM = "image/ppm";
    private static final int PPM_ID = Transfer.registerType("image/ppm");
    private static final String RGB = "image/ppm";
    private static final int RGB_ID = Transfer.registerType("image/ppm");
    private static final String TGA = "image/tga";
    private static final int TGA_ID = Transfer.registerType("image/tga");
    private static final String XBM = "image/xbm";
    private static final int XBM_ID = Transfer.registerType("image/xbm");
    private static final String XPM = "image/xpm";
    private static final int XPM_ID = Transfer.registerType("image/xpm");
    private static final String XV = "image/xv";
    private static final int XV_ID = Transfer.registerType("image/xv");

    private ImageTransfer() {
    }

    public static ImageTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        Image image;
        int pixbuf;
        ImageData imgData;
        if (!this.checkImage(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        if ((imgData = (ImageData)object) == null) {
            SWT.error(4);
        }
        if ((pixbuf = ImageList.createPixbuf(image = new Image((Device)Display.getCurrent(), imgData))) != 0) {
            String typeStr = "";
            if (transferData.type == JPEG_ID) {
                typeStr = "jpeg";
            } else if (transferData.type == PNG_ID) {
                typeStr = "png";
            } else if (transferData.type == BMP_ID) {
                typeStr = "bmp";
            } else if (transferData.type == EPS_ID) {
                typeStr = "eps";
            } else if (transferData.type == PCX_ID) {
                typeStr = "pcx";
            } else if (transferData.type == PPM_ID) {
                typeStr = "ppm";
            } else if (transferData.type == RGB_ID) {
                typeStr = "rgb";
            } else if (transferData.type == TGA_ID) {
                typeStr = "tga";
            } else if (transferData.type == XBM_ID) {
                typeStr = "xbm";
            } else if (transferData.type == XPM_ID) {
                typeStr = "xpm";
            } else if (transferData.type == XV_ID) {
                typeStr = "xv";
            }
            byte[] type = Converter.wcsToMbcs(null, typeStr, true);
            int[] buffer = new int[1];
            int[] len = new int[1];
            if (type == null) {
                return;
            }
            OS.gdk_pixbuf_save_to_bufferv(pixbuf, buffer, len, type, null, null, null);
            OS.g_object_unref(pixbuf);
            transferData.pValue = buffer[0];
            transferData.length = (len[0] + 3) / 4 * 4;
            transferData.result = 1;
            transferData.format = 32;
        }
        image.dispose();
    }

    public Object nativeToJava(TransferData transferData) {
        ImageData imgData = null;
        if (transferData.length > 0) {
            int loader = OS.gdk_pixbuf_loader_new();
            try {
                OS.gdk_pixbuf_loader_write(loader, transferData.pValue, transferData.length, null);
                OS.gdk_pixbuf_loader_close(loader, null);
                int pixbuf = OS.gdk_pixbuf_loader_get_pixbuf(loader);
                if (pixbuf != 0) {
                    Image img = Image.gtk_new_from_pixbuf(Display.getCurrent(), 0, pixbuf);
                    imgData = img.getImageData();
                    img.dispose();
                }
            }
            finally {
                OS.g_object_unref(loader);
            }
        }
        return imgData;
    }

    protected int[] getTypeIds() {
        return new int[]{PNG_ID, BMP_ID, EPS_ID, JPEG_ID, PCX_ID, PPM_ID, RGB_ID, TGA_ID, XBM_ID, XPM_ID, XV_ID};
    }

    protected String[] getTypeNames() {
        return new String[]{PNG, BMP, EPS, JPEG, PCX, "image/ppm", "image/ppm", TGA, XBM, XPM, XV};
    }

    boolean checkImage(Object object) {
        return object != null && object instanceof ImageData;
    }

    protected boolean validate(Object object) {
        return this.checkImage(object);
    }
}

