/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.dnd.ByteArrayTransfer;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.Transfer;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.C;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;

public class TextTransfer
extends ByteArrayTransfer {
    private static TextTransfer _instance = new TextTransfer();
    private static final String COMPOUND_TEXT = "COMPOUND_TEXT";
    private static final String UTF8_STRING = "UTF8_STRING";
    private static final String STRING = "STRING";
    private static final int COMPOUND_TEXT_ID = Transfer.registerType("COMPOUND_TEXT");
    private static final int UTF8_STRING_ID = Transfer.registerType("UTF8_STRING");
    private static final int STRING_ID = Transfer.registerType("STRING");

    private TextTransfer() {
    }

    public static TextTransfer getInstance() {
        return _instance;
    }

    public void javaToNative(Object object, TransferData transferData) {
        transferData.result = 0;
        if (!this.checkText(object) || !this.isSupportedType(transferData)) {
            DND.error(2003);
        }
        String string = (String)object;
        byte[] utf8 = Converter.wcsToMbcs(null, string, true);
        if (transferData.type == COMPOUND_TEXT_ID) {
            int[] encoding = new int[1];
            int[] format = new int[1];
            int[] ctext = new int[1];
            int[] length = new int[1];
            boolean result = OS.GTK_VERSION >= OS.VERSION(2, 24, 0) ? OS.gdk_x11_display_utf8_to_compound_text(OS.gdk_display_get_default(), utf8, encoding, format, ctext, length) : OS.gdk_utf8_to_compound_text(utf8, encoding, format, ctext, length);
            if (!result) {
                return;
            }
            transferData.type = encoding[0];
            transferData.format = format[0];
            transferData.length = length[0];
            transferData.pValue = ctext[0];
            transferData.result = 1;
        }
        if (transferData.type == UTF8_STRING_ID) {
            int pValue = OS.g_malloc(utf8.length);
            if (pValue == 0) {
                return;
            }
            C.memmove(pValue, utf8, utf8.length);
            transferData.type = UTF8_STRING_ID;
            transferData.format = 8;
            transferData.length = utf8.length - 1;
            transferData.pValue = pValue;
            transferData.result = 1;
        }
        if (transferData.type == STRING_ID) {
            int string_target = OS.gdk_utf8_to_string_target(utf8);
            if (string_target == 0) {
                return;
            }
            transferData.type = STRING_ID;
            transferData.format = 8;
            transferData.length = C.strlen(string_target);
            transferData.pValue = string_target;
            transferData.result = 1;
        }
    }

    public Object nativeToJava(TransferData transferData) {
        if (!this.isSupportedType(transferData) || transferData.pValue == 0) {
            return null;
        }
        int[] list = new int[1];
        int count = OS.gdk_text_property_to_utf8_list_for_display(OS.gdk_display_get_default(), transferData.type, transferData.format, transferData.pValue, transferData.length, list);
        if (count == 0) {
            return null;
        }
        int[] ptr = new int[1];
        C.memmove(ptr, list[0], C.PTR_SIZEOF);
        int length = C.strlen(ptr[0]);
        byte[] utf8 = new byte[length];
        C.memmove(utf8, ptr[0], length);
        OS.g_strfreev(list[0]);
        char[] unicode = Converter.mbcsToWcs(null, utf8);
        String string = new String(unicode);
        int end = string.indexOf(0);
        return end == -1 ? string : string.substring(0, end);
    }

    protected int[] getTypeIds() {
        return new int[]{UTF8_STRING_ID, COMPOUND_TEXT_ID, STRING_ID};
    }

    protected String[] getTypeNames() {
        return new String[]{UTF8_STRING, COMPOUND_TEXT, STRING};
    }

    boolean checkText(Object object) {
        return object != null && object instanceof String && ((String)object).length() > 0;
    }

    protected boolean validate(Object object) {
        return this.checkText(object);
    }
}

