/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.commands;

import org.eclipse.core.runtime.Status;
import org.eclipse.debug.core.IRequest;
import org.eclipse.debug.core.commands.IDebugCommandRequest;
import org.eclipse.debug.core.commands.IDisconnectHandler;
import org.eclipse.debug.core.commands.IEnabledStateRequest;
import org.eclipse.tcf.internal.debug.model.TCFError;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.internal.debug.ui.model.TCFRunnable;

public class DisconnectCommand
implements IDisconnectHandler {
    private final TCFModel model;

    public DisconnectCommand(TCFModel model) {
        this.model = model;
    }

    public void canExecute(final IEnabledStateRequest monitor) {
        new TCFRunnable(this.model, (IRequest)monitor){

            @Override
            public void run() {
                monitor.setEnabled(DisconnectCommand.this.model.getLaunch().canDisconnect());
                monitor.setStatus(Status.OK_STATUS);
                this.done();
            }
        };
    }

    public boolean execute(final IDebugCommandRequest monitor) {
        new TCFRunnable(this.model, (IRequest)monitor){

            @Override
            public void run() {
                try {
                    DisconnectCommand.this.model.getLaunch().closeChannel();
                    monitor.setStatus(Status.OK_STATUS);
                }
                catch (Throwable x) {
                    monitor.setStatus(new TCFError(x).getStatus());
                }
                this.done();
            }
        };
        return false;
    }
}

