/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.internal.debug.ui.model;

import org.eclipse.debug.core.IRequest;
import org.eclipse.tcf.debug.ui.ITCFPresentationProvider;
import org.eclipse.tcf.internal.debug.ui.Activator;
import org.eclipse.tcf.internal.debug.ui.model.TCFModel;
import org.eclipse.tcf.protocol.Protocol;

public abstract class TCFRunnable
implements Runnable {
    private final IRequest request;
    private final Iterable<ITCFPresentationProvider> listeners;
    protected boolean done;

    public TCFRunnable(TCFModel model, IRequest request) {
        this.request = request;
        this.listeners = model.view_request_listeners;
        if (this.listeners == null) {
            Protocol.invokeLater((Runnable)this);
            return;
        }
        Protocol.invokeLater((Runnable)new Runnable(){

            @Override
            public void run() {
                if (!$assertionsDisabled && TCFRunnable.this.done) {
                    throw new AssertionError();
                }
                for (ITCFPresentationProvider l : TCFRunnable.this.listeners) {
                    try {
                        if (l.updateStarted(TCFRunnable.this.request)) continue;
                        return;
                    }
                    catch (Throwable x) {
                        Activator.log("Unhandled exception in a presentation provider", x);
                    }
                }
                TCFRunnable.this.run();
            }
        });
    }

    public void done() {
        assert (!this.done);
        this.done = true;
        if (this.listeners != null) {
            for (ITCFPresentationProvider l : this.listeners) {
                try {
                    if (l.updateComplete(this.request)) continue;
                    return;
                }
                catch (Throwable x) {
                    Activator.log("Unhandled exception in a presentation provider", x);
                }
            }
        }
        this.request.done();
    }
}

