/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.launch.ui.internal.adapters;

import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.te.launch.ui.model.LaunchModel;
import org.eclipse.tcf.te.launch.ui.model.LaunchNode;
import org.eclipse.tcf.te.ui.views.Managers;
import org.eclipse.tcf.te.ui.views.interfaces.ICategory;
import org.eclipse.tcf.te.ui.views.interfaces.categories.ICategorizable;

public class CategorizableAdapter
implements ICategorizable {
    private final LaunchNode node;

    public CategorizableAdapter(LaunchNode node) {
        Assert.isNotNull((Object)((Object)node));
        this.node = node;
    }

    public String getId() {
        return LaunchModel.getCategoryId(this.node.getLaunchConfiguration());
    }

    public boolean isValid(ICategorizable.OPERATION operation, ICategory parentCategory, ICategory category) {
        Assert.isNotNull((Object)operation);
        Assert.isNotNull((Object)category);
        if (ICategorizable.OPERATION.REMOVE.equals((Object)operation) && parentCategory != null && "org.eclipse.tcf.te.ui.views.category.favorites".equals(parentCategory.getId())) {
            return true;
        }
        return ICategorizable.OPERATION.ADD.equals((Object)operation) && category != null && "org.eclipse.tcf.te.ui.views.category.favorites".equals(category.getId());
    }

    public boolean isEnabled(ICategorizable.OPERATION operation, ICategory category) {
        Assert.isNotNull((Object)operation);
        Assert.isNotNull((Object)category);
        if (ICategorizable.OPERATION.REMOVE.equals((Object)operation)) {
            return Managers.getCategoryManager().belongsTo("org.eclipse.tcf.te.ui.views.category.favorites", this.getId());
        }
        if (ICategorizable.OPERATION.ADD.equals((Object)operation)) {
            return !Managers.getCategoryManager().belongsTo("org.eclipse.tcf.te.ui.views.category.favorites", this.getId());
        }
        return false;
    }
}

