/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.runtime.processes;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PipedInputStream;
import java.lang.reflect.Field;
import java.security.AccessController;
import java.security.PrivilegedAction;
import org.eclipse.tcf.te.runtime.activator.CoreBundleActivator;

public class ProcessOutputReaderThread
extends Thread {
    private String prefix;
    private InputStream[] streams;
    private BufferedReader[] reader;
    private StringBuilder lines;
    private String lastLine;
    private boolean finished;
    private boolean waiting;
    private Object waiterSemaphore;

    public ProcessOutputReaderThread(String prefix, InputStream[] streams) {
        super("ProcessOutputReader-" + (prefix == null ? "" : prefix));
        assert (streams != null);
        this.lastLine = "";
        this.finished = false;
        this.waiting = false;
        this.waiterSemaphore = new Object();
        this.prefix = prefix == null ? "" : (!prefix.trim().endsWith(":") ? String.valueOf(prefix.trim()) + ": " : prefix);
        this.streams = streams;
        this.reader = new BufferedReader[streams.length];
        int i = 0;
        while (i < streams.length) {
            this.reader[i] = new BufferedReader(new InputStreamReader(streams[i]));
            ++i;
        }
        this.lines = new StringBuilder();
    }

    public boolean isFinished() {
        return this.finished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void waitForFinish(long timeout) {
        if (!this.finished) {
            this.waiting = true;
            Object object = this.waiterSemaphore;
            synchronized (object) {
                try {
                    this.waiterSemaphore.wait(timeout);
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    public void waitForFinish() {
        this.waitForFinish(0L);
    }

    public synchronized String getOutput() {
        return this.lines.toString();
    }

    public synchronized String getLastLine() {
        return this.lastLine;
    }

    protected synchronized void processLine(String line) {
        if (line != null) {
            StringBuffer buffer = new StringBuffer(line.trim());
            while (buffer.length() > 0 && (buffer.charAt(buffer.length() - 1) == '\r' || buffer.charAt(buffer.length() - 1) == '\n')) {
                buffer.deleteCharAt(buffer.length() - 1);
            }
            this.lastLine = line = buffer.toString();
            this.lines.append(line);
            this.lines.append('\n');
            CoreBundleActivator.getTraceHandler().trace(String.valueOf(this.getPrefix()) + " processLine: " + line, 3, (Object)this);
        }
    }

    protected String getPrefix() {
        return this.prefix;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void finish() {
        this.finished = true;
        if (this.waiting) {
            this.waiting = false;
            Object object = this.waiterSemaphore;
            synchronized (object) {
                this.waiterSemaphore.notifyAll();
            }
        }
    }

    protected synchronized int readAvailableInput(BufferedReader reader) {
        if (reader != null) {
            int bytesRead = 0;
            try {
                while (reader.ready()) {
                    String line = reader.readLine();
                    if (line == null) continue;
                    bytesRead = line.length();
                    this.processLine(line);
                }
            }
            catch (IOException iOException) {
                bytesRead = -1;
            }
            return bytesRead;
        }
        return -1;
    }

    protected void readInputUntilInterrupted() {
        boolean allStreamsEOF = false;
        while (!allStreamsEOF) {
            allStreamsEOF = true;
            int totalBytesRead = 0;
            int i = 0;
            while (i < this.reader.length) {
                if (this.reader[i] != null) {
                    int bytesRead = this.readAvailableInput(this.reader[i]);
                    if (bytesRead == 0 && this.streams[i] instanceof PipedInputStream) {
                        PipedInputStream in = (PipedInputStream)this.streams[i];
                        try {
                            final Field f = in.getClass().getDeclaredField("closedByWriter");
                            AccessController.doPrivileged(new PrivilegedAction<Object>(){

                                @Override
                                public Object run() {
                                    f.setAccessible(true);
                                    return null;
                                }
                            });
                            if (f.getBoolean(in)) {
                                bytesRead = -1;
                            }
                        }
                        catch (Exception exception) {}
                    }
                    if (bytesRead == -1) {
                        try {
                            this.reader[i].close();
                        }
                        catch (IOException iOException) {}
                        this.reader[i] = null;
                    } else {
                        allStreamsEOF = false;
                        if (bytesRead >= 0) {
                            totalBytesRead += bytesRead;
                        }
                    }
                }
                ++i;
            }
            if (allStreamsEOF || totalBytesRead != 0) continue;
            try {
                ProcessOutputReaderThread.sleep(50L);
            }
            catch (InterruptedException interruptedException) {
                CoreBundleActivator.getTraceHandler().trace(String.valueOf(this.getPrefix()) + " received interrupt request", 3, (Object)this);
                allStreamsEOF = true;
            }
        }
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public void run() {
        try {
            CoreBundleActivator.getTraceHandler().trace(String.valueOf(this.getPrefix()) + " begin waiting for input", 3, (Object)this);
            this.readInputUntilInterrupted();
        }
        finally {
            var5_3 = this.reader;
            var4_5 = this.reader.length;
            var3_7 = 0;
            ** while (var3_7 < var4_5)
        }
lbl-1000:
        // 1 sources

        {
            element = var5_3[var3_7];
            if (element != null) {
                this.readAvailableInput(element);
                try {
                    element.close();
                }
                catch (IOException v0) {}
            }
            ++var3_7;
            continue;
        }
lbl20:
        // 1 sources

        this.finish();
        CoreBundleActivator.getTraceHandler().trace(String.valueOf(this.getPrefix()) + " stop waiting for input", 3, (Object)this);
    }
}

