/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.filesystem.core.internal.testers;

import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;

public class TargetPropertyTester
extends PropertyTester {
    public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
        if (receiver instanceof IPeerModel) {
            IPeerModel peerModel = (IPeerModel)receiver;
            if (property.equals("isWindows")) {
                return TargetPropertyTester.isWindows(peerModel);
            }
        }
        return false;
    }

    public static boolean isWindows(IPeerModel peerModel) {
        String osName = TargetPropertyTester.getOSName(peerModel);
        return osName == null ? false : osName.startsWith("Windows");
    }

    public static String getOSName(final IPeerModel peerModel) {
        final String[] osName = new String[1];
        if (Protocol.isDispatchThread()) {
            osName[0] = peerModel.getPeer().getOSName();
        } else {
            Protocol.invokeAndWait((Runnable)new Runnable(){

                @Override
                public void run() {
                    osName[0] = peerModel.getPeer().getOSName();
                }
            });
        }
        return osName[0];
    }
}

