/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.launch.ui.editor;

import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.IAdaptable;
import org.eclipse.core.runtime.Platform;
import org.eclipse.debug.core.DebugPlugin;
import org.eclipse.debug.core.ILaunchConfiguration;
import org.eclipse.debug.core.ILaunchConfigurationListener;
import org.eclipse.debug.core.ILaunchConfigurationWorkingCopy;
import org.eclipse.tcf.te.launch.ui.editor.AbstractLaunchTabContainerEditorPage;
import org.eclipse.tcf.te.runtime.concurrent.util.ExecutorsUtil;
import org.eclipse.tcf.te.runtime.persistence.PersistenceManager;
import org.eclipse.tcf.te.runtime.persistence.interfaces.IPersistenceDelegate;
import org.eclipse.tcf.te.runtime.services.ServiceManager;
import org.eclipse.tcf.te.runtime.services.interfaces.IPropertiesAccessService;
import org.eclipse.tcf.te.tcf.launch.ui.activator.UIPlugin;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;

public abstract class AbstractTcfLaunchTabContainerEditorPage
extends AbstractLaunchTabContainerEditorPage
implements ILaunchConfigurationListener {
    protected ILaunchConfigurationListener launchConfigListener = null;
    protected static final String PROP_LAUNCH_CONFIG_WC = "launchConfigWorkingCopy.transient.silent";
    protected static final String PROP_ORIGINAL_LAUNCH_CONFIG_ATTRIBUTES = "launchConfigAttributes.transient.silent";

    public IPeerModel getPeerModel(Object input) {
        return (IPeerModel)((IAdaptable)input).getAdapter(IPeerModel.class);
    }

    protected boolean hasApplyAction() {
        return !this.isAutoSave();
    }

    private boolean isAutoSave() {
        boolean autoSave = !UIPlugin.getDefault().getPreferenceStore().getBoolean("NoLaunchEditorTabAutoSave");
        return autoSave;
    }

    public static ILaunchConfigurationWorkingCopy getLaunchConfig(IPeerModel peerModel) {
        ILaunchConfigurationWorkingCopy wc = null;
        if (peerModel != null) {
            IPropertiesAccessService service = (IPropertiesAccessService)ServiceManager.getInstance().getService((Object)peerModel, IPropertiesAccessService.class);
            Assert.isNotNull((Object)service);
            if (service.getProperty((Object)peerModel, PROP_LAUNCH_CONFIG_WC) instanceof ILaunchConfigurationWorkingCopy) {
                wc = (ILaunchConfigurationWorkingCopy)service.getProperty((Object)peerModel, PROP_LAUNCH_CONFIG_WC);
            } else {
                wc = (ILaunchConfigurationWorkingCopy)Platform.getAdapterManager().getAdapter((Object)peerModel, ILaunchConfigurationWorkingCopy.class);
                if (wc == null) {
                    wc = (ILaunchConfigurationWorkingCopy)Platform.getAdapterManager().loadAdapter((Object)peerModel, "org.eclipse.debug.core.ILaunchConfigurationWorkingCopy");
                }
                Assert.isNotNull((Object)wc);
                service.setProperty((Object)peerModel, PROP_LAUNCH_CONFIG_WC, (Object)wc);
                IPersistenceDelegate delegate = PersistenceManager.getInstance().getDelegate((Object)wc, String.class);
                String launchConfigAttributes = null;
                try {
                    launchConfigAttributes = delegate != null ? (String)delegate.write((Object)wc, String.class) : null;
                }
                catch (Exception exception) {}
                service.setProperty((Object)peerModel, PROP_ORIGINAL_LAUNCH_CONFIG_ATTRIBUTES, (Object)launchConfigAttributes);
            }
        }
        return wc;
    }

    public boolean setupData(Object input) {
        ILaunchConfigurationWorkingCopy wc = AbstractTcfLaunchTabContainerEditorPage.getLaunchConfig(this.getPeerModel(input));
        if (wc != null) {
            this.getLaunchConfigurationTab().initializeFrom((ILaunchConfiguration)wc);
            this.checkLaunchConfigDirty();
            return true;
        }
        return false;
    }

    public boolean extractData() {
        if (this.isAutoSave()) {
            return false;
        }
        ILaunchConfigurationWorkingCopy wc = AbstractTcfLaunchTabContainerEditorPage.getLaunchConfig(this.getPeerModel(this.getEditorInput()));
        if (wc != null && this.checkLaunchConfigDirty()) {
            this.getLaunchConfigurationTab().performApply(wc);
            try {
                wc.doSave();
                IPeerModel peerModel = this.getPeerModel(this.getEditorInput());
                IPropertiesAccessService service = (IPropertiesAccessService)ServiceManager.getInstance().getService((Object)peerModel, IPropertiesAccessService.class);
                Assert.isNotNull((Object)service);
                service.setProperty((Object)peerModel, PROP_LAUNCH_CONFIG_WC, null);
                this.checkLaunchConfigDirty();
                return true;
            }
            catch (Exception exception) {}
        }
        return false;
    }

    public boolean checkLaunchConfigDirty() {
        boolean dirty = false;
        IPeerModel peerModel = this.getPeerModel(this.getEditorInput());
        IPropertiesAccessService service = (IPropertiesAccessService)ServiceManager.getInstance().getService((Object)peerModel, IPropertiesAccessService.class);
        String oldLaunchConfigAttributes = (String)service.getProperty((Object)peerModel, PROP_ORIGINAL_LAUNCH_CONFIG_ATTRIBUTES);
        IPersistenceDelegate delegate = PersistenceManager.getInstance().getDelegate((Object)AbstractTcfLaunchTabContainerEditorPage.getLaunchConfig(peerModel), String.class);
        String launchConfigAttributes = null;
        try {
            launchConfigAttributes = (String)delegate.write((Object)AbstractTcfLaunchTabContainerEditorPage.getLaunchConfig(peerModel), String.class);
            dirty = !launchConfigAttributes.equals(oldLaunchConfigAttributes);
        }
        catch (Exception exception) {}
        this.setDirty(dirty);
        return dirty;
    }

    public void setDirty(boolean dirty) {
        if (this.isAutoSave()) {
            ILaunchConfigurationWorkingCopy wc = AbstractTcfLaunchTabContainerEditorPage.getLaunchConfig(this.getPeerModel(this.getEditorInput()));
            if (wc != null && dirty) {
                try {
                    wc.doSave();
                    IPeerModel peerModel = this.getPeerModel(this.getEditorInput());
                    IPropertiesAccessService service = (IPropertiesAccessService)ServiceManager.getInstance().getService((Object)peerModel, IPropertiesAccessService.class);
                    service.setProperty((Object)peerModel, PROP_LAUNCH_CONFIG_WC, null);
                }
                catch (Exception exception) {}
            }
        } else {
            super.setDirty(dirty);
            ExecutorsUtil.executeInUI((Runnable)new Runnable(){

                @Override
                public void run() {
                    AbstractTcfLaunchTabContainerEditorPage.this.getManagedForm().dirtyStateChanged();
                }
            });
        }
    }

    public void setActive(boolean active) {
        super.setActive(active);
        if (active && this.launchConfigListener == null) {
            this.launchConfigListener = this;
            DebugPlugin.getDefault().getLaunchManager().addLaunchConfigurationListener((ILaunchConfigurationListener)this);
        }
    }

    public void dispose() {
        super.dispose();
        IPeerModel peerModel = this.getPeerModel(this.getEditorInput());
        IPropertiesAccessService service = (IPropertiesAccessService)ServiceManager.getInstance().getService((Object)peerModel, IPropertiesAccessService.class);
        service.setProperty((Object)peerModel, PROP_ORIGINAL_LAUNCH_CONFIG_ATTRIBUTES, null);
        service.setProperty((Object)peerModel, PROP_LAUNCH_CONFIG_WC, null);
        DebugPlugin.getDefault().getLaunchManager().removeLaunchConfigurationListener((ILaunchConfigurationListener)this);
        this.launchConfigListener = null;
    }

    public void launchConfigurationAdded(ILaunchConfiguration configuration) {
    }

    public void launchConfigurationRemoved(ILaunchConfiguration configuration) {
    }

    public void launchConfigurationChanged(ILaunchConfiguration configuration) {
        if (!(configuration instanceof ILaunchConfigurationWorkingCopy)) {
            IPeerModel peerModel = this.getPeerModel(this.getEditorInput());
            IPropertiesAccessService service = (IPropertiesAccessService)ServiceManager.getInstance().getService((Object)peerModel, IPropertiesAccessService.class);
            ILaunchConfigurationWorkingCopy wc = (ILaunchConfigurationWorkingCopy)service.getProperty((Object)peerModel, PROP_LAUNCH_CONFIG_WC);
            if (wc != null && configuration.getName().equals(wc.getName())) {
                service.setProperty((Object)peerModel, PROP_ORIGINAL_LAUNCH_CONFIG_ATTRIBUTES, null);
                service.setProperty((Object)peerModel, PROP_LAUNCH_CONFIG_WC, null);
                ExecutorsUtil.executeInUI((Runnable)new Runnable(){

                    @Override
                    public void run() {
                        AbstractTcfLaunchTabContainerEditorPage.this.setActive(AbstractTcfLaunchTabContainerEditorPage.this.isActive());
                    }
                });
            }
        }
    }
}

