/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator.internal;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.eclipse.core.expressions.PropertyTester;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.tcf.locator.activator.CoreBundleActivator;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelPeerNodeQueryService;
import org.eclipse.tcf.te.tcf.locator.nodes.PeerRedirector;

public class LocatorModelPropertyTester
extends PropertyTester {
    public boolean test(final Object receiver, final String property, final Object[] args, final Object expectedValue) {
        if (receiver instanceof IPeerModel || receiver instanceof IPeer) {
            final AtomicBoolean result = new AtomicBoolean();
            if ("hasLocalService".equals(property) || "hasRemoteService".equals(property)) {
                if (!Protocol.isDispatchThread()) {
                    result.set(this.testServices((IPeerModel)receiver, property, args, expectedValue));
                }
            } else {
                Runnable runnable = new Runnable(){

                    @Override
                    public void run() {
                        if (receiver instanceof IPeerModel) {
                            result.set(LocatorModelPropertyTester.this.testPeerModel((IPeerModel)receiver, property, args, expectedValue));
                        } else {
                            result.set(LocatorModelPropertyTester.this.testPeer((IPeer)receiver, property, args, expectedValue));
                        }
                    }
                };
                if (Protocol.isDispatchThread()) {
                    runnable.run();
                } else {
                    Protocol.invokeAndWait((Runnable)runnable);
                }
            }
            return result.get();
        }
        return false;
    }

    protected boolean testPeerModel(IPeerModel node, String property, Object[] args, Object expectedValue) {
        Assert.isNotNull((Object)node);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        return this.testPeer(node.getPeer(), property, args, expectedValue);
    }

    protected boolean testPeer(IPeer node, String property, Object[] args, Object expectedValue) {
        String name;
        String value;
        Assert.isNotNull((Object)node);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        if ("name".equals(property) && node.getName() != null && node.getName().equals(expectedValue)) {
            return true;
        }
        if ("nameRegex".equals(property) && expectedValue instanceof String && node.getName() != null && node.getName().matches((String)expectedValue)) {
            return true;
        }
        if ("osName".equals(property) && node.getOSName() != null && node.getOSName().equals(expectedValue)) {
            return true;
        }
        if ("osNameRegex".equals(property) && expectedValue instanceof String && node.getOSName() != null && node.getOSName().matches((String)expectedValue)) {
            return true;
        }
        if ("isStaticPeer".equals(property)) {
            boolean isStaticPeer;
            value = (String)node.getAttributes().get("static.transient");
            boolean bl = isStaticPeer = value != null && Boolean.parseBoolean(value.trim());
            if (expectedValue instanceof Boolean) {
                return (Boolean)expectedValue == isStaticPeer;
            }
        }
        if ("isRedirected".equals(property)) {
            boolean isRedirected = node instanceof PeerRedirector;
            if (expectedValue instanceof Boolean) {
                return (Boolean)expectedValue == isRedirected;
            }
        }
        if ("isProxy".equals(property)) {
            boolean isProxy = node.getAttributes().containsKey("Proxy");
            if (expectedValue instanceof Boolean) {
                return (Boolean)expectedValue == isProxy;
            }
        }
        if ("isValueAdd".equals(property)) {
            boolean isValueAdd;
            value = (String)node.getAttributes().get("ValueAdd");
            boolean bl = isValueAdd = value != null && ("1".equals(value.trim()) || Boolean.parseBoolean(value.trim()));
            if (expectedValue instanceof Boolean) {
                return (Boolean)expectedValue == isValueAdd;
            }
        }
        if ("isOfType".equals(property)) {
            value = (String)node.getAttributes().get("Type");
            if (expectedValue instanceof String) {
                return value != null ? ((String)expectedValue).equals(value) : ((String)expectedValue).equalsIgnoreCase("null");
            }
        }
        if ("hasAttribute".equals(property)) {
            boolean hasAttribute;
            name = args != null && args.length > 0 ? (String)args[0] : null;
            boolean bl = hasAttribute = name != null && !"".equals(name) ? node.getAttributes().containsKey(name) : false;
            if (expectedValue instanceof Boolean) {
                return (Boolean)expectedValue == hasAttribute;
            }
        }
        if ("isAttribute".equals(property)) {
            String value2;
            name = args != null && args.length > 0 ? (String)args[0] : null;
            String string = value2 = name != null && !"".equals(name) ? (String)node.getAttributes().get(name) : null;
            if (expectedValue != null) {
                return expectedValue.toString().equals(value2);
            }
        }
        if ("hasOfflineService".equals(property)) {
            String services = (String)node.getAttributes().get("OfflineServices");
            List<String> list = services != null ? Arrays.asList(services.split(",\\s*")) : Collections.EMPTY_LIST;
            return list.contains(expectedValue);
        }
        return false;
    }

    protected boolean testServices(IPeerModel node, String property, Object[] args, Object expectedValue) {
        Assert.isNotNull((Object)node);
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0, (String)"Illegal Thread Access");
        String services = null;
        ILocatorModel model = node.getModel();
        ILocatorModelPeerNodeQueryService queryService = model.getService(ILocatorModelPeerNodeQueryService.class);
        services = "hasLocalService".equals(property) ? queryService.queryLocalServices(node) : queryService.queryRemoteServices(node);
        if (CoreBundleActivator.getTraceHandler().isSlotEnabled("trace/propertyTester")) {
            CoreBundleActivator.getTraceHandler().trace("testServices: property = " + property + ", expectedValue = " + expectedValue + ", services = " + services, "trace/propertyTester", (Object)this);
        }
        if (services != null) {
            String[] stringArray = services.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String service = stringArray[n2];
                if (service != null && service.trim().equals(expectedValue)) {
                    return true;
                }
                ++n2;
            }
        }
        return false;
    }
}

