/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.locator.services;

import java.util.ArrayList;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.protocol.IPeer;
import org.eclipse.tcf.protocol.Protocol;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.ILocatorModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.nodes.IPeerModel;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelLookupService;
import org.eclipse.tcf.te.tcf.locator.interfaces.services.ILocatorModelPeerNodeQueryService;
import org.eclipse.tcf.te.tcf.locator.services.AbstractLocatorModelService;

public class LocatorModelLookupService
extends AbstractLocatorModelService
implements ILocatorModelLookupService {
    public LocatorModelLookupService(ILocatorModel parentModel) {
        super(parentModel);
    }

    @Override
    public IPeerModel lkupPeerModelById(String id) {
        Assert.isNotNull((Object)id);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        IPeerModel node = null;
        IPeerModel[] iPeerModelArray = this.getLocatorModel().getPeers();
        int n = iPeerModelArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPeerModel candidate = iPeerModelArray[n2];
            IPeer peer = candidate.getPeer();
            if (id.equals(peer.getID())) {
                node = candidate;
                break;
            }
            if (peer.getAttributes().get("remote.id.transient") != null && ((String)peer.getAttributes().get("remote.id.transient")).equals(id)) {
                node = candidate;
                break;
            }
            ++n2;
        }
        return node;
    }

    @Override
    public IPeerModel lkupPeerModelById(String parentId, String id) {
        Assert.isNotNull((Object)parentId);
        Assert.isNotNull((Object)id);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        IPeerModel node = null;
        for (IPeerModel candidate : this.getLocatorModel().getChildren(parentId)) {
            IPeer peer = candidate.getPeer();
            if (id.equals(peer.getID())) {
                node = candidate;
                break;
            }
            if (peer.getAttributes().get("remote.id.transient") == null || !((String)peer.getAttributes().get("remote.id.transient")).equals(id)) continue;
            node = candidate;
            break;
        }
        return node;
    }

    @Override
    public IPeerModel[] lkupPeerModelByAgentId(String agentId) {
        Assert.isNotNull((Object)agentId);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        ArrayList<IPeerModel> nodes = new ArrayList<IPeerModel>();
        IPeerModel[] iPeerModelArray = this.getLocatorModel().getPeers();
        int n = iPeerModelArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPeerModel candidate = iPeerModelArray[n2];
            IPeer peer = candidate.getPeer();
            if (agentId.equals(peer.getAgentID())) {
                nodes.add(candidate);
            }
            ++n2;
        }
        return nodes.toArray(new IPeerModel[nodes.size()]);
    }

    @Override
    public IPeerModel[] lkupPeerModelByAgentId(String parentId, String agentId) {
        Assert.isNotNull((Object)parentId);
        Assert.isNotNull((Object)agentId);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        ArrayList<IPeerModel> nodes = new ArrayList<IPeerModel>();
        for (IPeerModel candidate : this.getLocatorModel().getChildren(parentId)) {
            IPeer peer = candidate.getPeer();
            if (!agentId.equals(peer.getAgentID())) continue;
            nodes.add(candidate);
        }
        return nodes.toArray(new IPeerModel[nodes.size()]);
    }

    @Override
    public IPeerModel[] lkupPeerModelByName(String name) {
        Assert.isNotNull((Object)name);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        ArrayList<IPeerModel> nodes = new ArrayList<IPeerModel>();
        IPeerModel[] iPeerModelArray = this.getLocatorModel().getPeers();
        int n = iPeerModelArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPeerModel candidate = iPeerModelArray[n2];
            IPeer peer = candidate.getPeer();
            if (name.equals(peer.getName())) {
                nodes.add(candidate);
            }
            ++n2;
        }
        return nodes.toArray(new IPeerModel[nodes.size()]);
    }

    @Override
    public IPeerModel[] lkupPeerModelBySupportedServices(String[] expectedLocalServices, String[] expectedRemoteServices) {
        Assert.isTrue((!Protocol.isDispatchThread() ? 1 : 0) != 0, (String)"Illegal Thread Access");
        ILocatorModel model = this.getLocatorModel();
        ILocatorModelPeerNodeQueryService queryService = model.getService(ILocatorModelPeerNodeQueryService.class);
        ArrayList<IPeerModel> nodes = new ArrayList<IPeerModel>();
        IPeerModel[] iPeerModelArray = model.getPeers();
        int n = iPeerModelArray.length;
        int n2 = 0;
        while (n2 < n) {
            String service;
            int n3;
            int n4;
            String[] stringArray;
            IPeerModel candidate = iPeerModelArray[n2];
            String services = queryService.queryLocalServices(candidate);
            boolean matchesExpectations = true;
            if (expectedLocalServices != null && expectedLocalServices.length > 0) {
                if (services != null) {
                    stringArray = expectedLocalServices;
                    n4 = expectedLocalServices.length;
                    n3 = 0;
                    while (n3 < n4) {
                        service = stringArray[n3];
                        if (!services.contains(service)) {
                            matchesExpectations = false;
                            break;
                        }
                        ++n3;
                    }
                } else {
                    matchesExpectations = false;
                }
            }
            if (matchesExpectations) {
                services = queryService.queryRemoteServices(candidate);
                if (expectedRemoteServices != null && expectedRemoteServices.length > 0) {
                    if (services != null) {
                        stringArray = expectedRemoteServices;
                        n4 = expectedRemoteServices.length;
                        n3 = 0;
                        while (n3 < n4) {
                            service = stringArray[n3];
                            if (!services.contains(service)) {
                                matchesExpectations = false;
                                break;
                            }
                            ++n3;
                        }
                    } else {
                        matchesExpectations = false;
                    }
                }
                if (matchesExpectations) {
                    nodes.add(candidate);
                }
            }
            ++n2;
        }
        return nodes.toArray(new IPeerModel[nodes.size()]);
    }

    @Override
    public IPeerModel[] lkupMatchingStaticPeerModels(IPeerModel peerNode) {
        Assert.isNotNull((Object)peerNode);
        Assert.isTrue((boolean)Protocol.isDispatchThread(), (String)"Illegal Thread Access");
        ArrayList<IPeerModel> nodes = new ArrayList<IPeerModel>();
        IPeerModel[] iPeerModelArray = this.getLocatorModel().getPeers();
        int n = iPeerModelArray.length;
        int n2 = 0;
        while (n2 < n) {
            IPeerModel candidate = iPeerModelArray[n2];
            if (candidate.isStatic()) {
                if (candidate.getPeer().getAgentID() != null && candidate.getPeer().getAgentID().equals(peerNode.getPeer().getAgentID())) {
                    nodes.add(candidate);
                } else {
                    String t1 = peerNode.getPeer().getTransportName();
                    String t2 = candidate.getPeer().getTransportName();
                    if (t1 != null && t1.equals(t2) && ("TCP".equals(t1) || "SSL".equals(t1))) {
                        String i1 = (String)peerNode.getPeer().getAttributes().get("Host");
                        String i2 = (String)candidate.getPeer().getAttributes().get("Host");
                        if (i1 != null && i1.equals(i2)) {
                            String p1 = (String)peerNode.getPeer().getAttributes().get("Port");
                            String p2 = (String)candidate.getPeer().getAttributes().get("Port");
                            if (p1 != null && p1.equals(p2)) {
                                nodes.add(candidate);
                            }
                        }
                    }
                }
            }
            ++n2;
        }
        return nodes.toArray(new IPeerModel[nodes.size()]);
    }
}

