/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.tcf.te.tcf.processes.core.model.runtime.services;

import java.util.ArrayList;
import java.util.List;
import java.util.UUID;
import org.eclipse.core.runtime.Assert;
import org.eclipse.tcf.te.runtime.model.interfaces.IContainerModelNode;
import org.eclipse.tcf.te.runtime.model.interfaces.IModelNode;
import org.eclipse.tcf.te.tcf.core.model.interfaces.IModel;
import org.eclipse.tcf.te.tcf.core.model.interfaces.services.IModelLookupService;
import org.eclipse.tcf.te.tcf.core.model.services.AbstractModelService;
import org.eclipse.tcf.te.tcf.processes.core.model.interfaces.runtime.IRuntimeModel;

public class RuntimeModelLookupService
extends AbstractModelService<IRuntimeModel>
implements IModelLookupService {
    public RuntimeModelLookupService(IRuntimeModel model) {
        super((IModel)model);
    }

    public IModelNode lkupModelNodeByUUID(UUID uuid) {
        return ((IRuntimeModel)this.getModel()).find(uuid);
    }

    public IModelNode[] lkupModelNodesById(String id) {
        Assert.isNotNull((Object)id);
        ArrayList<IModelNode> nodes = new ArrayList<IModelNode>();
        nodes.addAll(this.findInContainerByIdRecursively((IContainerModelNode)this.getModel(), id));
        return nodes.toArray(new IModelNode[nodes.size()]);
    }

    private List<IModelNode> findInContainerByIdRecursively(IContainerModelNode container, String id) {
        Assert.isNotNull((Object)container);
        Assert.isNotNull((Object)id);
        ArrayList<IModelNode> nodes = new ArrayList<IModelNode>();
        List candidates = container.getChildren(IModelNode.class);
        for (IModelNode candidate : candidates) {
            if (id.equals(candidate.getStringProperty("id")) && !nodes.contains(candidate)) {
                nodes.add(candidate);
            }
            if (!(candidate instanceof IContainerModelNode)) continue;
            nodes.addAll(this.findInContainerByIdRecursively((IContainerModelNode)candidate, id));
        }
        return nodes;
    }

    public IModelNode[] lkupModelNodesByName(String name) {
        Assert.isNotNull((Object)name);
        ArrayList<IModelNode> nodes = new ArrayList<IModelNode>();
        nodes.addAll(this.findInContainerByNameRecursively((IContainerModelNode)this.getModel(), name));
        return nodes.toArray(new IModelNode[nodes.size()]);
    }

    private List<IModelNode> findInContainerByNameRecursively(IContainerModelNode container, String name) {
        Assert.isNotNull((Object)container);
        Assert.isNotNull((Object)name);
        ArrayList<IModelNode> nodes = new ArrayList<IModelNode>();
        List candidates = container.getChildren(IModelNode.class);
        for (IModelNode candidate : candidates) {
            if (name.equals(candidate.getName()) && !nodes.contains(candidate)) {
                nodes.add(candidate);
            }
            if (!(candidate instanceof IContainerModelNode)) continue;
            nodes.addAll(this.findInContainerByNameRecursively((IContainerModelNode)candidate, name));
        }
        return nodes;
    }
}

